<title>Checkout</title>
<?php $__env->startSection('content'); ?>
<?php echo $__env->make('layouts.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<main id="main">
  <!-- ======= Breadcrumbs Section ======= -->
  <section class="breadcrumbs">
    <div class="container">
      <div class="d-flex justify-content-between align-items-center">
        <ol>
          <li><a href="index"><img src="<?php echo e(asset('assets/img/icons/icon-home.png')); ?>">Home</a></li>
          <li>Checkout</li>
        </ol>
      </div>
    </div>
  </section><!-- End Breadcrumbs Section -->

  <!-- ======= Pricing Section ======= -->
  <section id="pricing" class="pricing inner-page">
    <div class="container" data-aos="fade-up">
        <div class="panel panel-default">
          <div class="panel-heading">
            <h4 class="panel-title">Step 2: Confirm Order</h4>
          </div>
          <div class="panel-body">
            <div class="row">
                <div class="col-sm-12">
                    <?php if(Session::has('msg')): ?> <p class="error text-danger text-bold"><?php echo e(Session::get('msg')); ?></p> <?php endif; ?>

                    <?php $__currentLoopData = $orderData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data1): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    
                      <?php
                        $user_commission = ((6.5/100) * $data1->subPolicy_price);
                      ?>
                        <div class="table-responsive" style="overflow-x: auto">
                          <table class="table table-striped table-bordered">
                            <thead>
                                <tr>
                                    <td>Product Name</td>
                                    <td>Model</td>
                                    <td>Quantity</td>
                                    <td>Unit Price</td>
                                    <td>Total</td>
                                </tr>
                              
                            </thead>
                            <tbody>
                              <tr>
                                <td><?php echo e($data1->subPolicy_name); ?></td>
                                <td><?php echo e($data1->policy_name); ?></td>
                                <td>1</td>
                                <td>&#8358;<?php echo e($data1->subPolicy_price); ?></td>
                                <td>&#8358;<?php echo e($data1->subPolicy_price); ?></td>
                              </tr>
                              <?php if(session()->has('user_id') && session()->has('vkaID')): ?>
                              <tr>
                                <td colspan="4">Commission Paid</td>
                                <td>&#8358;<?php echo e($user_commission); ?></td>
                              </tr>
                              <?php endif; ?>
                              <tr>
                                <td colspan="4">Sub Total:</td>
                                <td>&#8358;<?php echo e($data1->subPolicy_price); ?></td>
                              </tr>
                              <tr>
                                <td colspan="4">Total:</td>
                                <td>&#8358;<?php echo e($data1->subPolicy_price); ?></td>
                              </tr>
                            </tbody>
                          </table>
                        </div>
                        <form method="post" action="<?php echo e(route('pay')); ?>">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" name="user_comm" value="<?php echo e($user_commission); ?>" />
                            <input type="hidden" name="email" value="<?php echo e($data1->email); ?>"> 
                            <input type="hidden" name="amount" value="<?php echo e($data1->subPolicy_price); ?>00"> 
                            <input type="hidden" name="orderID" value="<?php echo e($data1->order_id); ?>">
                            <input type="hidden" name="metadata" value="<?php echo e(json_encode($array = ['orderID' => $data1->order_id, 'premium' => $data1->subPolicy_price, 'user_comm' => $user_commission, 'key_name' => 'value',])); ?>">
                            <input type="hidden" name="callback_url" value="<?php echo e(url('payment/callback')); ?>">
                            <input type="hidden" name="reference" value="<?php echo e($data1->order_id.Paystack::genTranxRef()); ?>"> 
    
                            <p> <input type="checkbox" name="agree" value="1" required />
                                By confirming this order, I have agreed to the terms and conditions of this company and the payment gateway, as well as keeping track of the transactions I have previously made.</p>
                             <input type="submit" value="Confirm Order" class="btn btn-primary">
                        </form>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
          </div>

        </div>
    </div>
  </section><!-- End Pricing Section -->
</main><!-- End #main -->

<?php echo $__env->make('layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('template', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/veritaskapital/retaildemo.veritaskapital.com/resources/views/body/confirmCheckout.blade.php ENDPATH**/ ?>