<title>Veritas Kapital Assurance PLC - Personal Accident Insurance</title>
<?php $__env->startSection('content'); ?>
    <?php echo $__env->make('layouts.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <main id="main">
        <!-- ======= Breadcrumbs Section ======= -->
        <section class="breadcrumbs">
            <div class="container">
                <div class="d-flex justify-content-between align-items-center">
                    <ol>
                        <li><a href="index"><img src="<?php echo e(asset('assets/img/icons/icon-home.png')); ?>">Home</a></li>
                        <li><a href="<?php echo e(url('customerdash')); ?>">My Dashboard</a> </li>
                    </ol>
                </div>
            </div>
        </section><!-- End Breadcrumbs Section -->
        <div id="account-account" class="container dashboard">
            <div class="row">
                <div id="content" class="col-md-9 col-sm-8" style="margin-top:50px;">
                    <div class="dashboard--main">
                        <div class="dashboard--top">
                            <div class="row" >
                                <div class="col-12">
                                    <h2>Order History</h2><br />
                                    <div class="table-responsive" style="overflow-x: auto">
                                        <table class="table table-bordered table-striped table-hover">
                                        <thead>
                                            <th>Transaction Ref</th>
                                            <th>Policy Purchased</th>
                                            <th>Transaction Date</th>
                                            <th>Amount</th>
                                            <th>Status</th>
                                            <th>Action</th>
                                        </thead>
                                        <tbody>
                                            <?php $__currentLoopData = $TransactionData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data1): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php if($data1->order_id == 0): ?>
                                                    <tr>
                                                        <td> No Transactions Has Been Made</td>
                                                    </tr>
                                                <?php else: ?>
                                                    <tr>
                                                        <td>#<?php echo e($data1->transaction_ref); ?></td>
                                                        <td><?php echo e($data1->policy_name); ?> (<?php echo e($data1->subPolicy_name); ?>)</td>
                                                        <td><?php echo e(date('Y-m-d', strtotime($data1->transaction_date))); ?></td>
                                                        <td><?php echo e($data1->amount); ?></td>
                                                        <td><?php echo e($data1->order_status_name); ?></td>
                                                        <td><a href="certificate/<?php echo e($data1->transaction_id); ?>" target="blank"><i
                                                                    class="fa fa-print"
                                                                    title="Print Policy Certificate"></i></a> </td>
                                                    </tr>
                                                <?php endif; ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <aside class="col-md-3 col-sm-4 col-xs-12 content-aside right_column sidebar-offcanvas">
                    <div class="myprofile">
                        <div class="myprofile--detail">
                            <?php $__currentLoopData = $customerData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <h2><?php echo e($data->firstname); ?> <?php echo e($data->lastname); ?></h2>
                                <p><?php echo e($data->email); ?></p>
                                <?php if(session()->has('vkaID')): ?>
                                    <p>Total Comission: &#8358;<?php echo e(number_format($data->comission_paid)); ?></p>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <ul class="list-inline">
                                <li><a class="btn btn-default" href="<?php echo e(url('editaccount')); ?>"
                                        data-original-title="Edit Profile"><i class="fa fa-pencil-square-o"
                                            aria-hidden="true"></i> Edit Profile</a></li>&nbsp;
                                <li><a class="btn btn-success" href="<?php echo e(url('logout')); ?>" data-original-title="Logout"><i
                                            class="fa fa-sign-out" aria-hidden="true"></i> Logout</a></li>
                            </ul>
                        </div>
                    </div>
                    <?php echo $__env->make('layouts.adminnav', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                </aside>

            </div>


    </main><!-- End #main -->

    <?php echo $__env->make('layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('template', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/veritaskapital/retaildemo.veritaskapital.com/resources/views/body/customer/transactions.blade.php ENDPATH**/ ?>