<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/
Route::get('/catalog', 'App\Http\Controllers\ApiCatalogController@catalog')->name('api-catalog');
Route::post('/generateMotorPaymentLink', 'App\Http\Controllers\ApiGeneratePaymentLinkController@generateMotorPaymentLink');// payment link for comprehensive and thirdparty
Route::post('/generateGitPaymentLink', 'App\Http\Controllers\ApiGeneratePaymentLinkController@generateGitPaymentLink');// payment link for comprehensive and thirdparty
Route::post('/generateMarinePaymentLink', 'App\Http\Controllers\ApiGeneratePaymentLinkController@generateMarinePaymentLink');// payment link for comprehensive and thirdparty
Route::get('/verifyTransaction/{id}', 'App\Http\Controllers\ApiPaymentController@verifyCustomerTransaction');// callback to verify customer payment by Insuremart



//Direct Sale of thirdparty insurance without payment
Route::get('/thirdPartycatalog', 'App\Http\Controllers\ApiThirdPartyController@thirdPartyCatalog')->name('thirparty-api-catalog');
Route::post('/thirdPartyPolicy', 'App\Http\Controllers\ApiThirdPartyController@thirdPartyGeneratePolicy')->name('thirparty-api-generate-policy');
Route::post('/rifan/policy/generate', 'App\Http\Controllers\ApiRifanIntegration@generatePolicy')->name('rifan-thirparty-api-generate-policy');//endpoint for RIFAN

// Route::middleware('auth:api')->get('/user', function (Request $request) {
//     return $request->user();
// });
