@extends('template')
<title>Veritas Kapital Assurance PLC - Purchase</title>
@section('content')
@include('layouts.header')

<main id="main">
    <!-- ======= Breadcrumbs Section ======= -->
    <section class="breadcrumbs">
      <div class="container">
            <div class="d-flex justify-content-between align-items-center">
                <ol>
                    <li>Account</li>
                    <li>Policy Purchase</li>
                </ol>
            </div>
      </div>
    </section><!-- End Breadcrumbs Section -->

    <!-- ======= Pricing Section ======= -->
    <section id="pricing" class="pricing inner-page">
      <div class="container" data-aos="fade-up">
        <div class="row">
        <div id="content" class="col-md-9 col-sm-12 fluid-sidebar" style="margin-top:-40px;">
      		<div class="row">
                <div class="col-sm-6">
                    @if (Session::has('errorMsg'))
                        <div class="alert alert-danger text-center" role="alert">
                            {{ Session::get('errorMsg') }} <i class="fa fa-window-close"></i>
                        </div>
                    @elseif (Session::has('successMsg'))
                        <div class="alert alert-success alert-dismissable text-center" role="alert">
                            {{ Session::get('successMsg') }} <i class="fa fa-check"></i>
                        </div>
                    @endif
                    <div class="well col-sm-12 col-md-offset-2">
                        <h2>Make Payment</h2>
                        <h5>Amount: 5000</h5>
                        <form method="post" action="{{ route('pay') }}">
                            @csrf
                            {{-- <input type="hidden" name="user_comm" value="{{ $user_commission }}" /> --}}
                            <input type="hidden" name="email" value="jagbai@veritaskapital.com">
                            <input type="hidden" name="amount" value="500000">
                            <input type="hidden" name="orderID" value="606">
                            <input type="hidden" name="metadata" value="{{ json_encode($array = ['orderID' => 606, 'premium' => 500000]) }}">
                            <input type="hidden" name="callback_url" value="{{ url('payments/repaymentcallback') }}">
                            <input type="hidden" name="reference" value="{{ Paystack::genTranxRef() }}"> {{-- required --}}

                             <input type="submit" value="Make Payment" class="btn btn-primary">
                        </form>
                    </div>






        </div>
      </div>
    </section><!-- End Pricing Section -->
</main><!-- End #main -->

  {{-- @include('layouts.footer')
@endsection --}}
