@extends('template')
<title>Veritas Kapital Assurance PLC - Purchase</title>
@section('content')
@include('layouts.header')

<main id="main">
    <!-- ======= Breadcrumbs Section ======= -->
    <section class="breadcrumbs">
      <div class="container">
            <div class="d-flex justify-content-between align-items-center">
                <ol>
                    <li>Account</li>
                    <li>Policy Purchase</li>
                </ol>
            </div>
      </div>
    </section><!-- End Breadcrumbs Section -->
    @php
        $id = $orderData['0']->transaction_id;
        $addon_message = "";
        
        if($orderData['0']->policyID == 3){
            $addon_message = " and uploaded to NIID";
        }
        
        $cert_url = $orderData['0']->mapfre_certificate_url;
    @endphp
    
    <section id="pricing" class="pricing inner-page">
      <div class="container" data-aos="fade-up">
        <div class="row">
        <div id="content" class="col-md-12 col-sm-12 fluid-sidebar" style="margin-top:-40px;">
      		<div class="row">
                <div class="col-sm-12 text-center">
    
                    @if($orderData['0']->policyID == '6')
                                    
                        @if($orderData['0']->mapfre_error == 'success')
                            <div class="well col-sm-12">
                                <h2>Congratulations!</h2>
                                <p><strong>Policy Purchased Successfully <span class=" fa-fa-check"></span></strong></p>
                                <!--<p><strong>You will receive your certificate in the registered email within 10 minutes</strong></p>-->
                                <a href="{{ $cert_url }}" target="blank" class="btn btn-success">Click Here to View Policy Certificate</a>
                            </div>
                        @else
                            <div class="well col-sm-12">
                                <h2>Oops! Something went wrong</h2>
                                <p><strong>Your purchase was successful but we encountered an issue generating your certificate. </strong></p>
                                <p><strong>Kindly note that you will recieve your certificate via the registered email shortly. </strong></p>
                                <p>Send an email to travel@veritaskapital.com with your payment receipt and passport number if you do not receive your certificate within the next 1 hour</p>
                                
                            </div>
                        @endif
                    @else
                    
                        @if($orderData['0']->naicom_status == "error")
                            <div class="well col-sm-12">
                                <h2>Congratulations!</h2>
                                <p><strong>Policy Purchased Successfully {{ $addon_message }} <span class=" fa-fa-check"></span></strong></p>
                                <br/><br/>
                                <p><b>{{ $orderData['0']->naicom_message }}</b></p>
                            </div>
                        @else
                            <div class="well col-sm-12">
                                <h2>Congratulations!</h2>
                                <p><strong>Policy Purchased Successfully <span class=" fa-fa-check"></span></strong></p>
                                <a href="/certificate/{{$id }}" target="blank" class="btn btn-success">Click Here to View Policy Certificate</a>
                            </div>
                        @endif
                   @endif
                </div>
            </div>
        </div>
    </section>
    
</main><!-- End #main -->

  @include('layouts.footer')
@endsection