@extends('template')
<title>Veritas Kapital Assurance PLC - Purchase Insurance</title>
@section('content')
    @include('layouts.header')

    <main id="main">
        <!-- ======= Breadcrumbs Section ======= -->
        <section class="breadcrumbs">
            <!--div class="container">

                <!--div class="d-flex justify-content-between align-items-center">
                  <ol>
                    <li><a href="index"><img src="{{ asset('assets/img/icons/icon-home.png') }}">Home</a></li>
                    <li>Personal Accident</li>
                  </ol>
                </div>

              </div-->
        </section><!-- End Breadcrumbs Section -->

        <!-- ======= Pricing Section ======= -->
        <section id="pricing" class="pricing inner-page">
            <div class="container" data-aos="fade-up">


                <div class="row">
                    <div style="margin-top:-20px;" class="modal-dialog modal-lg">
                        <div class="modal-content">
                            <div class="modal-body book-policy">
                                <div class="row">
                                    <div class="col-lg-12">
                                        <div class="section-title">
                                            @foreach ($pPolicy as $policyData)
                                                @php
                                                    $id = $policyData->upc;
                                                    $pID = $policyData->policyID;
                                                    $name = $policyData->subPolicy_name;
                                                @endphp
                                                <h2>{{ $policyData->subPolicy_name }}</h2>
                                                <img src="{{ asset($policyData->subPolicy_img) }}">
                                        </div>
                                        <p style="font-size:16px; text-align:center;">An Insurance agent who assists an
                                            applicant to complete an application or proposal form for Insurance shall be
                                            deemed to have done so as the agent of the applicant.</p>
                                        <p style="font-size:16px; text-align:center;">Information to be completed must be in
                                            block letters and will not be accepted if not completed with</p>
                                        @if ($pID === 1)
                                            <p style="font-size:16px; text-align:center;"><a
                                                    href="{{ url('https://veritaskapital.com/terms_conditions/personalAccident_terms.html') }}"
                                                    style="font-size:16px; text-align:center;">Terms and Conditions</a>
                                            @elseif ($pID === 2)
                                            <p style="font-size:16px; text-align:center;"><a
                                                    href="{{ url('https://veritaskapital.com/terms_conditions/householder_terms.html') }}"
                                                    style="font-size:16px; text-align:center;">Terms and Conditions</a>
                                            @elseif ($pID === 3)
                                            <p style="font-size:16px; text-align:center;"><a
                                                    href="{{ url('https://veritaskapital.com/terms_conditions/motor_terms.html') }}"
                                                    style="font-size:16px; text-align:center;">Terms and Conditions</a>
                                            @elseif ($pID === 4)
                                            <p style="font-size:16px; text-align:center;"><a
                                                    href="{{ url('https://veritaskapital.com/terms_conditions/fire_term_condition.html') }}"
                                                    style="font-size:16px; text-align:center;">Terms and Conditions</a>
                                            @elseif ($pID === 5)
                                            <p style="font-size:16px; text-align:center;"><a
                                                    href="{{ url('https://veritaskapital.com/terms_conditions/fire_term_condition.html') }}"
                                                    style="font-size:16px; text-align:center;">Terms and Conditions</a></p>
                                        @endif

                                        <br />
                                        <a class="text-center" href="{{ url('https://veritaskapital.com/privacy/') }}">Privacy Policy</a>
                                        <br />
                                        
                                        @if ($pID === 7)
                                               <h5 style="" class="text-danger text-center">Ensure that official CBN ratings are used for policy purchases.</h5>
                                               <h5 style="" class="text-danger text-center">Only Agreed premium ratings are to be used on this platform during policy purchase</h5>
                                        @endif
                                    </div>
                                    <div class="col-md-1"></div>
                                    <div class="col-md-10">
                                        @if (Session::has('PolicyIntoDBSuccess'))
                                            <div class="alert alert-success text-center" role="alert">
                                                {{ Session::get('PolicyIntoDBSuccess') }} <i class="fa fa-check"></i>
                                            </div>
                                        @endif


                                        {{-- @if ($countUnremitted >= 6 && (session('userLevel') == 2 || session('userLevel') == 3))
                                            <h3 class="alert alert-danger text-center text-danger">Please Settle Unremitted Sales Before
                                                Proceeding!</h3>
                                            @else --}}
                                            @if ($pID === 7)
                                                <form action="{{ route('addMarinePolicyIntoDB') }}" method="POST" id="myForm">
                                            @else
                                                <form action="{{ url('addPersonalPolicyIntoDB') }}" method="POST" id="myForm">
                                            @endif
                                                @csrf
                                                @if (Session::has('user_id'))
                                                    <input type="hidden" name="customerID"
                                                        value="{{ Session::get('user_id') }}">
                                                @else
                                                    <input type="hidden" name="customerID"
                                                        value="{{ Session::get('user_id') }}">
                                                @endif
                                                <input type="hidden" name="subPolicyID" value="{{ $id }}">
                                                <input type="hidden" name="current_url" value="{{ session('current_url') }}">
                                                @if($pID===7)
                                                <br/>
                                                    <div class="form-group col-sm-12">
                                                        <label><small class="text-danger">*</small>Type of Purchase</label>
                                                        <select id="typeOfPurchase" name="typeOfPurchase" class="form-control" required>
                                                            <option value="">Select Type of Purchase</option>
                                                            <option value="self">Self</option>
                                                            <option value="customer">On Customers Behalf</option>
                                                        </select>
                                                    </div>
                                                    <br/>
                                                    <div id="customerDisplay" class="customerDisplay" style="display: none;">
                                                        <div class="form-row">
                                                            <div class="form-group col-sm-6">
                                                                <label><small class="text-danger">*</small> First Name</label>
                                                                <input type="text" name="firstName" placeholder="First Name*"
                                                                    id="input-formfields1" class="form-control">
                                                            </div>
                                                            <div class="form-group col-sm-6">
                                                                <label><small class="text-danger">*</small> Last Name</label>
                                                                <input type="text" name="lastName" placeholder="Last Name*"
                                                                    id="input-formfields2" class="form-control">
                                                            </div>
                                                        </div>
                                                        <div class="form-row">
                                                            <div class="col-sm-6 form-group">
                                                                <label><small class="text-danger">*</small> Email Address</label>
                                                                <input type="email" name="email" placeholder="Email Address*"
                                                                    id="input-formfields4" class="form-control">
                                                            </div>
                                                            <div class="form-group col-sm-6">
                                                                <label><small class="text-danger">*</small> Phone Number</label>
                                                                <input type="text"
                                                                    name="phone"placeholder="Contact number* ex: 80xxxxxxxx"
                                                                    id="input-formfields6"
                                                                    onkeypress="return AllowOnlyNumbers(event);"
                                                                    class="form-control custom_teliphone" maxlength="11">
                                                                <input type="hidden" name="country_code" value="+234"
                                                                    placeholder="Contact number*" class="form-control"
                                                                    disabled="disabled">
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="form-row">
                                                        <div class="form-group col-sm-12">
                                                            <label><small class="text-danger">*</small> Cargo Description</label>
                                                            <input type="text" name="cargoDesc" class="form-control" required placeholder="Enter Description, such as items being transported, details of the cargo, etc">
                                                        </div>
                                                    </div>
                                                    <div class="form-row">
                                                        <div class="form-group col-sm-6">
                                                            <label><small class="text-danger">*</small> Invoice Value<span style="font-size:0.8em !important" class="text-danger">(numbers only)</span></label>
                                                            <input type="text" name="invoiceValue" class="form-control" required placeholder="Value of goods">
                                                        </div>
                                                        <div class="form-group col-sm-6">
                                                            <label><small class="text-danger">*</small> Currency of Invoice Value</label>
                                                            <select id="transCurrency" name="transCurrency" class="form-control" required>
                                                                <option value="">Currency</option>
                                                                <option value="ngn">NGN - Naira</option>
                                                                <option value="usd">USD - US Dollar</option>
                                                                <option value="eur">EUR - Euro</option>
                                                                <option value="gbp">GBP - British Pound Sterling</option>
                                                                <!-- Add more currency options as needed -->
                                                            </select>
                                                        </div>
                                                    </div>
                                                    <div class="form-row">
                                                        <div class="form-group col-sm-5">
                                                            <label><small class="text-danger">*</small>Sum Assured <span style="font-size:0.7em !important" class="text-danger">(add 10% for currency fluctuations)</span></label>
                                                            <input type="text" name="sumAssured" class="form-control" required placeholder="Enter Sum Assured in Naira">
                                                        </div>
                                                         @if (session('isAutoPay')=="Y")
                                                        <div class="form-group col-sm-4">
                                                            <label><small class="text-danger">*</small> Credit Note Number</label>
                                                            <input type="text" name="creditNoteNo" class="form-control" required placeholder="Enter credit note number">
                                                        </div>
                                                        @endif
                                                        @if (session('marineType')=="Unknown")
                                                            <div class="form-group col-sm-4">
                                                                <label><small class="text-danger">*</small>Premium Rate<span style="font-size:0.8em !important" class="text-danger">(Enter numbers and decimals only)</span></label>
                                                                <input type="text" name="premium_rate" class="form-control" required placeholder="Enter Premium Rate">
                                                            </div>
                                                        @endif
                                                    </div>
                                                    <div class="form-row">
                                                        <div class="form-group col-sm-6">
                                                            <label><small class="text-danger">*</small>Tax ID Number</label>
                                                            <input type="text" name="taxIdNo" class="form-control" required placeholder="Enter Tax Identification Number">
                                                        </div>
                                                        <div class="form-group col-sm-6">
                                                            <label><small class="text-danger">*</small>Bank Name</label>
                                                            <input type="text" name="bankName" value="" required placeholder="Enter Bank Name" class="form-control">
                                                        </div>
                                                        
                                                    </div>
                                                    <div class="form-row">
                                                        <div class="form-group col-sm-6">
                                                            <label><small class="text-danger">*</small>Vessel Source</label>
                                                            <input type="text" name="vesselSource" class="form-control" required placeholder="Enter Takeoff Location">
                                                        </div>
                                                        <div class="form-group col-sm-6">
                                                            <label><small class="text-danger">*</small>Vessel Destination</label>
                                                            <input type="text" name="vesselDestination" value="" required placeholder="Enter Destination" class="form-control">
                                                        </div>
                                                    </div>
                                                    <div class="form-row">
                                                        <div class="form-group col-sm-6">
                                                            <label><small class="text-danger">*</small> Address</label>
                                                            <textarea name="address" class="form-control" value="" required placeholder="Address*"></textarea>
                                                        </div>
                                                        <div class="form-group col-sm-6">
                                                            <label><small class="text-danger">*</small> State of Address</label>
                                                            <select name="state" class="form-control" required>
                                                                <option value="">State of Residence*</option>
                                                                <option value="Abia">Abia</option>
                                                                <option value="FCT">FCT</option>
                                                                <option value="Delta">Delta</option>
                                                                <option value="Ebonyi">Ebonyi</option>
                                                                <option value="Edo">Edo</option>
                                                                <option value="Ekiti">Ekiti</option>
                                                                <option value="Enugu">Enugu</option>
                                                                <option value="Gombe">Gombe</option>
                                                                <option value="Imo">Imo</option>
                                                                <option value="Jigawa">Jigawa</option>
                                                                <option value="Kaduna">Kaduna</option>
                                                                <option value="Kano">Kano</option>
                                                                <option value="Adamawa">Adamawa</option>
                                                                <option value="Katsina">Katsina</option>
                                                                <option value="Kebbi">Kebbi</option>
                                                                <option value="Kogi">Kogi</option>
                                                                <option value="Kwara">Kwara</option>
                                                                <option value="Lagos">Lagos</option>
                                                                <option value="Nasarawa">Nasarawa</option>
                                                                <option value="Niger">Niger</option>
                                                                <option value="Ogun">Ogun</option>
                                                                <option value="Ondo">Ondo</option>
                                                                <option value="Osun">Osun</option>
                                                                <option value="Akwa Ibom">Akwa Ibom</option>
                                                                <option value="Oyo">Oyo</option>
                                                                <option value="Plateau">Plateau</option>
                                                                <option value="Rivers">Rivers</option>
                                                                <option value="Sokoto">Sokoto</option>
                                                                <option value="Taraba">Taraba</option>
                                                                <option value="Yobe">Yobe</option>
                                                                <option value="Zamfara">Zamfara</option>
                                                                <option value="Anambra">Anambra</option>
                                                                <option value="Bauchi">Bauchi</option>
                                                                <option value="Bayelsa">Bayelsa</option>
                                                                <option value="Benue">Benue</option>
                                                                <option value="Borno">Borno</option>
                                                                <option value="Cross River">Cross River</option>
                                                            </select>
                                                        </div>
                                                    </div>
                                                @else
                                                    <div class="form-row">
                                                        <div class="form-group col-sm-6">
                                                            <input type="text" name="firstName" placeholder="First Name*"
                                                                id="input-formfields1" class="form-control" required>
                                                        </div>
                                                        <div class="form-group col-sm-6">
                                                            <input type="text" name="lastName" placeholder="Last Name*"
                                                                id="input-formfields2" class="form-control" required>
                                                        </div>
                                                    </div>
                                                    <div class="form-row">
                                                        <div class="col-sm-12 form-group">
                                                            <input type="email" name="email" placeholder="Email Address*"
                                                                id="input-formfields4" class="form-control" required>
                                                        </div>
                                                    </div>
                                                    {{-- <div class="form-row">
                                                    <div class="form-group col-sm-6">
                                                        <input type="date" name="dob" class="form-control" required placeholder="Date of birth*" data-date-format="YYYY-MM-DD" id="input-option3" onfocus="(this.type='date')">
                                                    </div>
                                                    <div class="form-group col-sm-6">
                                                        <input type="text" name="occupation" value="" required placeholder="Occupation*" id="input-formfields5" class="form-control">
                                                    </div>
                                                    </div> --}}
                                                    <div class="form-row">
                                                        <div class="form-group col-sm-12">
                                                            <!--
                                                            <div class="input-group mb-2"><div class="input-group-prepend">
                                                                                    <div class="input-group-text">+234</div>
                                                                                    </div></div>-->
                                                            <input type="text"
                                                                name="phone"placeholder="Contact number* ex: 80xxxxxxxx"
                                                                id="input-formfields6"
                                                                onkeypress="return AllowOnlyNumbers(event);"
                                                                class="form-control custom_teliphone" maxlength="11" required>
                                                            <input type="hidden" name="country_code" value="+234"
                                                                placeholder="Contact number*" class="form-control"
                                                                disabled="disabled">
                                                        </div>
                                                    </div>
                                                    <div class="form-row">
                                                        <div class="form-group col-sm-6">
                                                            <select name="state"
                                                                class="form-control js-example-basic-single"
                                                                id="" required>
                                                                @foreach ($getVehicleState as $make)
                                                                    <option value="{{ $make->code }}">
                                                                        {{ $make->state }}
                                                                    </option>
                                                                @endforeach
                                                            </select>
                                                        </div>
                                                        <div class="form-group col-sm-6">
                                                            <select name="lga"
                                                                class="form-control js-example-basic-single" required>
                                                                    <option value="">Select LGA</option>
                                                                    @foreach ($getVehicleLga as $model)
                                                                        <option value="{{ $model->code }}">
                                                                            {{ $model->lga }}
                                                                        </option>
                                                                    @endforeach

                                                            </select>
                                                        </div>
                                                    </div>
                                                    <div class="form-row">
                                                        <div class="form-group col-sm-12">
                                                            <textarea name="address" rows="5" placeholder="Home Address*" id="input-formfields7" class="form-control"
                                                                required></textarea>
                                                        </div>
                                                    </div>
                                                @endif
                                                @if ($pID === 3)
                                                    <div class="form-row">
                                                        <div class="form-group col-sm-6">
                                                            <select name="vehicle_make"
                                                                class="form-control js-example-basic-single"
                                                                id="vehicle_make" required>
                                                                @if ($id ==='010402')
                                                                    @foreach ($getVehicleMakeTricycle as $make)
                                                                        <option value="{{ $make->code }}">
                                                                            {{ $make->make }}
                                                                        </option>
                                                                    @endforeach
                                                                @elseif ($id ==='010403')
                                                                    @foreach ($getVehicleMakeMotorcycle as $make)
                                                                        <option value="{{ $make->code }}">
                                                                            {{ $make->make }}
                                                                        </option>
                                                                    @endforeach
                                                                @else
                                                                    @foreach ($getVehicleMake as $make)
                                                                        <option value="{{ $make->code }}">
                                                                            {{ $make->make }}
                                                                        </option>
                                                                    @endforeach
                                                                @endif

                                                            </select>
                                                        </div>
                                                        <div class="form-group col-sm-6">
                                                            <select name="vehicle_model" id="vehicle_model"
                                                                class="form-control" required>
                                                                <option value="">Vehicle Model</option>
                                                                    {{-- <option value="">Vehicle Model</option>
                                                                    @foreach ($getVehicleModel as $model)
                                                                        <option value="{{ $model->code }}">
                                                                            {{ $model->model }}
                                                                        </option>
                                                                    @endforeach --}}

                                                            </select>
                                                            {{-- <select name="vehicle_model"
                                                                class="form-control js-example-basic-single" required>
                                                                 @if ($id === '010403')
                                                                    <option value="">Vehicle Model</option>
                                                                    @foreach ($getBikeModel as $model)
                                                                        <option value="{{ $model->title }}">
                                                                            {{ $model->title }}
                                                                        </option>
                                                                    @endforeach
                                                                @elseif($id ==='010402')
                                                                    <option value="">Vehicle Model</option>
                                                                    @foreach ($getCycleModel as $model)
                                                                        <option value="{{ $model->title }}">
                                                                            {{ $model->title }}
                                                                        </option>
                                                                    @endforeach
                                                                @else
                                                                    <option value="">Vehicle Model</option>
                                                                    @foreach ($getVehicleModel as $model)
                                                                        <option value="{{ $model->title }}">
                                                                            {{ $model->title }}
                                                                        </option>
                                                                    @endforeach
                                                                @endif

                                                            </select> --}}
                                                        </div>
                                                    </div>
                                                    <div class="form-row">
                                                        <div class="form-group col-sm-6">
                                                            <select name="engine_capacity"
                                                                class="form-control js-example-basic-single"
                                                                id="" required>
                                                                <option value="">Select Engine Capacity</option>
                                                                @foreach ($getVehicleEngine as $make)
                                                                    <option value="{{ $make->code }}">
                                                                        {{ $make->capacity }}
                                                                    </option>
                                                                @endforeach
                                                            </select>
                                                        </div>
                                                        <div class="form-group col-sm-6">
                                                            <select name="colour"
                                                                class="form-control js-example-basic-single"
                                                                id="" required>
                                                                @foreach ($getVehicleColour as $make)
                                                                    <option value="{{ $make->code }}">
                                                                        {{ $make->colour }}
                                                                    </option>
                                                                @endforeach
                                                            </select>
                                                        </div>
                                                    </div>

                                                    <div class="form-row">
                                                        <div class="form-group col-sm-4">
                                                            <input type="text" name="car_reg_number" value=""
                                                                placeholder="Registration Number" id="input-formfields10"
                                                                class="form-control" required>
                                                        </div>
                                                        <div class="form-group col-sm-4">
                                                            <input type="text" name="chasis_number" value=""
                                                                placeholder="Chasis Number" id="input-formfields10"
                                                                class="form-control" required>
                                                        </div>
                                                        <div class="form-group col-sm-4">
                                                            <input type="text" name="engine_no" value=""
                                                                placeholder="Enter Engine Number" id="input-formfields10"
                                                                class="form-control" required>
                                                        </div>
                                                    </div>
                                                @elseif ($pID === 1)
                                                        <div class="form-row">
                                                            <div class="form-group col-sm-6">
                                                                <input type="text" name="next_of_kin_name" value=""
                                                                    placeholder="Name of Next Kin" id="input-formfields10"
                                                                    class="form-control" required>
                                                            </div>
                                                            <div class="form-group col-sm-6">
                                                                <input type="text" name="next_of_kin_phone" value=""
                                                                    placeholder="Phone Number of Next of Kin" id="input-formfields10"
                                                                    class="form-control" required>
                                                            </div>
                                                        </div>
                                                @endif
                                                <div class="form-row">
                                                    <div class="form-group col-sm-6">
                                                        <div id="input-formfields9">
                                                            <select name="form_of_id" class="form-control" required>
                                                                <option value="">Type of ID</option>
                                                                <option value="Drivers license">Drivers license</option>

                                                                <option value="Intl Passport">Int’l Passport</option>

                                                                <option value="National ID Card">National ID Card</option>

                                                                <!--<option value="CAC Certificate">CAC Certificate</option>-->

                                                            </select>
                                                        </div>
                                                    </div>
                                                    <div class="form-group col-sm-6">
                                                        <input type="text" name="id_number" value=""
                                                            placeholder="ID Number*" id="input-formfields10"
                                                            class="form-control" required>
                                                    </div>
                                                </div>
                                                <div class="form-row">
                                                    <div class="form-group col-sm-12">
                                                        <input type="text" name="bvn" value=""
                                                            placeholder="BVN" id="input-formfields10"
                                                            class="form-control" >
                                                    </div>
                                                </div>
                                                @if (strlen(session('teamId')) > 0)
                                                <!--<div class="form-row">
                                                    <div class="form-group col-sm-12">
                                                        <input type="text" name="remitaID" placeholder="Enter Remitta Code" id="remitaID" class="form-control">
                                                    </div>
                                                </div>-->
                                                @endif
                                                <div class="form-row">
                                                    <div class="form-group col-sm-12" style="font-size:14px;">
                                                        <ul type="ol" style="color:#000;">
                                                            <li><input type="checkbox" id="agree" required /> <br/> I declare that I have read the privacy information on the use of
                                                        personal data and confirm that the information above is correct to
                                                        the
                                                        best of my knowledge </li>
                                                            <li>I also consent to the processing of my personal data in accordance with the Company’s Privacy Policy </li>
                                                        </ul>
                                                    </div>
                                                </div>


                                                <div class="form-row mt-5">
                                                    <div class="form-group col-lg-6 col-md-12 col-sm-12 col-xs-12">
                                                        <input type="submit" value="Submit" id="submitBtn"
                                                            data-loading-text="Loading..." class="vk-btn blue"
                                                            style="width:100%; height:auto; margin-top:0px" />
                                                    </div>
                                                    <div class="form-group col-lg-6 col-md-12 col-sm-12 col-xs-12">
                                                        <input type="reset" value="Clear" class="vk-btn"
                                                            style="width:100%; margin-top:0px">
                                                    </div>
                                                </div>
                                            </form>
                                        {{-- @endif --}}


                                    </div>
                                    @endforeach
                                    <div class="col-md-1"></div>
                                </div>
                            </div>
                        </div>

                    </div>
        </section><!-- End Pricing Section -->
    </main><!-- End #main -->
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script type="text/javascript">
    
        $(document).ready(function() {
            $('.js-example-basic-single').select2();
        });
        
        $(document).ready(function() {
            // Wrap the code inside document ready function
            $(document).on('change', '#typeOfPurchase', function(e) {
                e.preventDefault();
    
                var selected = $(this).val(); // Use $(this) to refer to the changed element
    
                if (selected == 'customer') {
                    $('#customerDisplay').show();
                } else {
                    $('#customerDisplay').hide();
                }
            });
            
            //$('#submitBtn').hide();
            
            $(document).on('click', '#submitBtn', function(e) {
                // Prevent form submission initially
                //e.preventDefault();
                
                // Check if the checkbox is checked
                if ($('#agree').is(':checked')) {
                    // If checked, submit the form
                    //$('#myForm').submit();
                } else {
                    // If not checked, show an alert and highlight the checkbox
                    alert("Please confirm that you have read and accepted the privacy policy.");
                    $('#agree').focus(); // Focus on the checkbox
                    $('#agree').css({
                        'outline': '2px solid red',
                        'box-shadow': '0 0 5px red' // Added box shadow for visibility
                    }); // Highlight the checkbox
                }
            });
            
            // Remove highlight when the checkbox is checked
            $('#agree').on('change', function() {
                if ($(this).is(':checked')) {
                    $('#agree').css({
                        'outline': 'none',
                        'box-shadow': 'none'
                    });// Remove the highlight
                }
            });

        });
    </script>
    @include('layouts.footer')
@endsection
