@extends('template')
<title>Veritas Kapital Assurance PLC - Account/Login</title>
@section('content')
@include('layouts.header')

<main id="main">
    <!-- ======= Breadcrumbs Section ======= -->
    <section class="breadcrumbs">
      <div class="container">
            <div class="d-flex justify-content-between align-items-center">
                <ol>
                    <li>Account</li>
                    <li>Login</li>
                </ol>
            </div>
      </div>
    </section><!-- End Breadcrumbs Section -->

    <!-- ======= Pricing Section ======= -->
    <section id="pricing" class="pricing inner-page">
      <div class="container" data-aos="fade-up">
        <div class="row">
        <div id="content" class="col-md-9 col-sm-12 fluid-sidebar" style="margin-top:-40px;">
      		<div class="row">
                <div class="col-sm-6">
                    <div class="well col-sm-12">
                        <h2>First time Visitor?</h2>
                        <p><strong>Register Account</strong></p>
                        <p>Click the button below to Register</p>
                        <a href="{{ url('register') }}" class="btn btn-success">Continue</a></div>
                    </div>
                
                <div class="col-sm-6">  
                    <div class="well col-sm-12"> 
                        <h2>Have an Account?</h2>
                        @if (Session::has('error'))
                            <div class="alert alert-danger" role="alert">
                            <i class="fa fa-window-close"></i> {{Session::get('error')}} 
                            </div>
				        @endif
                        <p><strong></strong></p>
                        <form action="{{ url('/submitLogin') }}" method="post" enctype="multipart/form-data">
                        @csrf
                        <div class="form-group">
                            <label class="control-label" for="input-email">E-Mail Address</label>
                            <input type="text" name="email" value="{{ old('email') }}" placeholder="E-Mail Address" id="email" class="form-control">
                            <span class="text-danger">@error('email') {{ $message }}  @enderror</span> 
                        </div>
                        <div class="form-group">
                            <label class="control-label" for="input-password">Password</label>
                            <input type="password" name="password" value="" placeholder="Password" class="form-control">
                            <span class="text-danger">@error('password') {{ $message }}  @enderror</span> 
                            <a href="{{ route('forgot-password-form') }}">Forgot Password? Click Here</a></div>                        
                                <input type="submit" value="Login" class="btn btn-success pull-left">            
                        </form>
                    </div>
                </div>
                
  
 

		

        </div>
      </div>
    </section><!-- End Pricing Section -->
</main><!-- End #main -->

  @include('layouts.footer')
@endsection