@extends('template')
<title>Veritas Kapital Assurance PLC - Forgot Password</title>
@section('content')
@include('layouts.header')

<main id="main">
    <!-- ======= Breadcrumbs Section ======= -->
    <section class="breadcrumbs">
      <div class="container">

        <div class="d-flex justify-content-between align-items-center">
          <h3>Password Recovery</h3>
        </div>

      </div>
    </section><!-- End Breadcrumbs Section -->

    <!-- ======= Pricing Section ======= -->
    <section id="pricing" class="pricing inner-page">
      <div class="container" data-aos="fade-up">
        <div class="d-flex justify-content-center align-items-center">
            <div class="col-md-8 col-sm-12 col-xs-12">
                @if (Session::has('verifyError'))
                    <div class="alert alert-danger text-center" role="alert">
                        {{ Session::get('verifyError') }} <i class="fa fa-window-close"></i>
                    </div>
                @endif

                <form action="{{ route('Get-Password-Recovery-Email') }}" method="POST">
                    @csrf
                    <div class="form-group">
                        <label>Enter Your Registered Email Address</label>
                        <input type="email" name="email" placeholder="Enter Your Registered Email Address " class="form-control" required />
                    </div>
                    <div class="form-group">
                        <input type="submit" class="btn btn-success" style="width:100%" />
                    </div>
                </form>

                @if (Session::has('verifySuccess'))
                    <div class="alert alert-success text-center" role="alert">
                        {{ Session::get('verifySuccess') }} <i class="fa fa-check"></i>
                    </div>
                    <br/>
                @endif
            </div>
        </div>

      </div>
    </section><!-- End Pricing Section -->
</main><!-- End #main -->

  @include('layouts.footer')
@endsection

