@extends('template')
<title>Veritas Kapital Assurance PLC - Fire and Perils Insurance</title>
@section('content')
@include('layouts.header')
  <main id="main">

    <!-- ======= Breadcrumbs Section ======= -->
    <section class="breadcrumbs">
      <div class="container">

        <div class="d-flex justify-content-between align-items-center">
          <ol>
            <li><a href="index"><img src="{{ asset('assets/img/icons/icon-home.png') }}">Home</a></li>
            <li>Fire and Special Perils Insurance</li>
          </ol>
        </div>

      </div>
    </section><!-- End Breadcrumbs Section -->

    <!-- ======= Pricing Section ======= -->
    <section id="pricing" class="pricing inner-page">
      <div class="container" data-aos="fade-up">

        <div class="category-title">
          <h1>Fire and Special Perils Insurance</h1>
          <!--p>Magnam dolores commodi suscipit. Necessitatibus eius consequatur ex aliquid fuga eum quidem. Sit sint consectetur velit. Quisquam quos quisquam cupiditate. Et nemo qui impedit suscipit alias ea. Quia fugiat sit in iste officiis commodi quidem hic quas.</p-->
        </div>

        <div class="row">
		@foreach ($fsPolicy as $policyData)
		@php
		$id = $policyData->subPolicy_id;
		$name = $policyData->subPolicy_name;
		@endphp

          <div class="col-lg-4 pro-sec" data-aos="fade-up" data-aos-delay="100">
            <div class="box">
				<div class="ins-det">
					<img src="{{ asset('assets/img/icons/fire.png') }}"><br/><br/>
					<h4><a href="bookPackage/{{ $policyData->subPolicy_id}}" style="font-size:20px;"> {{ $policyData->subPolicy_name }} </a></h4>
					<!--span>A simple start for everyone</span-->
					<h2>₦ {{ number_format($policyData->subPolicy_price) }}</h2>
					<p class="total-sum" style="font-size: 17px;">Total sum insured: ₦ {{ number_format($policyData->sum_insured) }}</p>
					<!--div class="benefits">
						<h6>Benefits:</h6>
						<ul>
							<li><i class="bx bx-check"></i>Death/permanent Disability limit: N1,000,000</li>
							<li><i class="bx bx-check"></i>Medical expenses limit: N25,000</li>    
						</ul>
					</div-->
				</div>
				<a  href="bookPolicy/{{ $id }}"   class="vk-btn light">Buy Policy</a>            </div>
          </div>
		  @endforeach

          <!--div class="col-lg-4 pro-sec" data-aos="fade-up" data-aos-delay="100">
            <div class="box">
				<div class="ins-det">
					<img src="{{ asset('assets/img/icons/fire.png') }}">
					<h4>Gold</h4>
					<span>A simple start for everyone</span>
					<h2>₦ 3,500</h2>
					<p class="total-sum" style="font-size: 17px;">Total sum insured: ₦ 2,000,000</p>
					<!--div class="benefits">
						<h6>Benefits:</h6>
						<ul>
							<li><i class="bx bx-check"></i>Death/permanent Disability limit: N2,000,000</li>
							<li><i class="bx bx-check"></i>Medical expenses limit: N50,000</li>    
						</ul>
					</div>
				</div>
					<a href="Fire-gold" class="vk-btn light">Buy Policy</a>
            </div>
          </div-->

          <!--div class="col-lg-4 pro-sec" data-aos="fade-up" data-aos-delay="100">
            <div class="box">
				<div class="ins-det">
					<img src="{{ asset('assets/img/icons/fire.png') }}">
					<h4>Platinum</h4>
					<!--span>A simple start for everyone</span>
					<h2>₦ 4,500</h2>
					<p class="total-sum" style="font-size: 17px;">Total sum insured: ₦ 3,000,000</p>
					<!--div class="benefits">
						<h6>Benefits:</h6>
						<ul>
							<li><i class="bx bx-check"></i>Death/permanent Disability limit: N3,000,000</li>
							<li><i class="bx bx-check"></i>Medical expenses limit: N75,000</li>    
						</ul>
					</div>
				</div>
					<a href="Fire-platinum" class="vk-btn light">Buy Policy</a>
            </div>
          </div-->
        </div>

      </div>
    </section><!-- End Pricing Section -->
  </main><!-- End #main -->
@include('layouts.footer')
@endsection