@extends('template')
<title>Veritas Kapital Assurance PLC - Personal Accident Insurance</title>
@section('content')
    @include('layouts.header')

    <main id="main">
        <!-- ======= Breadcrumbs Section ======= -->
        <section class="breadcrumbs">
            <div class="container">
                <div class="d-flex justify-content-between align-items-center">
                    <ol>
                        <li><a href="index"><img src="{{ asset('assets/img/icons/icon-home.png') }}">Home</a></li>
                        <li><a href="{{ url('customerdash') }}">My Dashboard</a> </li>
                    </ol>
                </div>
            </div>
        </section><!-- End Breadcrumbs Section -->
        <div id="account-account" class="container dashboard">
            <div class="row">
                <div id="content" class="col-md-9 col-sm-8" style="margin-top:50px;">
                    <div class="dashboard--main">
                        <div class="dashboard--top">
                            @if (Session::has('success'))
                                <div class="alert alert-success" role="alert">
                                    <i class="fa fa-check"></i> {{ Session::get('success') }}
                                </div>
                            @endif
                            <div class="row">
                                <div id="content" class="col-sm-9">
                                    <h2>Newsletter Subscription</h2><br />
                                    @foreach ($customerData as $data)
                                        <form action="{{ url('/newsletterUpdate') }}" method="post">
                                            @csrf
                                            <input type="hidden" name="userID" value="{{ $data->customer_id }}" />
                                            <fieldset>
                                                <div class="form-group">
                                                    <label class="col-md-6 control-label">Subscribe to our
                                                        newsletter?</label>
                                                    <div class="col-sm-10">
                                                        <label class="radio-inline"><input type="radio" name="newsletter"
                                                                value="1" />Yes</label>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                                        <label class="radio-inline"><input type="radio" name="newsletter"
                                                                value="0" checked="checked" />
                                                            No</label>
                                                    </div>
                                                    <input type="submit" value="Update" class="btn btn-primary" />
                                                </div>
                                            </fieldset>
                                        </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <aside class="col-md-3 col-sm-4 col-xs-12 content-aside right_column sidebar-offcanvas">
                    <div class="myprofile">
                        <div class="myprofile--detail">

                            <h2>{{ $data->firstname }} {{ $data->lastname }}</h2>
                            <p>{{ $data->email }}</p>
                            @if (session()->has('vkaID'))
                                <p>Total Comission: &#8358;{{ number_format($data->comission_paid) }}</p>
                            @endif
                            @endforeach
                            <ul class="list-inline">
                                <li><a class="btn btn-default" href="{{ url('editaccount') }}"
                                        data-original-title="Edit Profile"><i class="fa fa-pencil-square-o"
                                            aria-hidden="true"></i> Edit Profile</a></li>&nbsp;
                                <li><a class="btn btn-success" href="{{ url('logout') }}" data-original-title="Logout"><i
                                            class="fa fa-sign-out" aria-hidden="true"></i> Logout</a></li>
                            </ul>
                        </div>
                    </div>
                    @include('layouts.adminnav')

                </aside>

            </div>


    </main><!-- End #main -->

    @include('layouts.footer')
@endsection
