@extends('template')
<title>Veritas Kapital Assurance PLC - Personal Accident Insurance</title>
@section('content')
    @include('layouts.header')

    <main id="main">
        <!-- ======= Breadcrumbs Section ======= -->
        <section class="breadcrumbs">
            <div class="container">
                <div class="d-flex justify-content-between align-items-center">
                    <ol>
                        <li><a href="index"><img src="{{ asset('assets/img/icons/icon-home.png') }}">Home</a></li>
                        <li><a href="{{ url('customerdash') }}">My Dashboard</a> </li>
                    </ol>
                </div>
            </div>
        </section><!-- End Breadcrumbs Section -->
        <div id="account-account" class="container dashboard">
            <div class="row">
                <div id="content" class="col-md-9 col-sm-8" style="margin-top:50px;">
                    <div class="dashboard--main">
                        <div class="dashboard--top">
                            <div class="row">
                                <div class="col-12">
                                    <h2>Pending Commissions To Be Paid</h2><br />
                                    <div class="table-responsive" style="overflow-x: auto">
                                        <table class="table table-bordered table-striped table-hover text-center">
                                        <thead>
                                            <th>S/N</th>
                                            <th>Agent Name</th>
                                            <th>Amount Pending (&#8358;)</th>
                                            <th>Action</th>
                                        </thead>
                                        <tbody>
                                            @foreach ($commissionData as $data1)
                                                    <tr>
                                                        <td>#</td>
                                                        <td>{{ $data1->firstname }} {{ $data1->lastname }}</td>
                                                        <td>{{ number_format($data1->comission_paid) }}</td>
                                                        <td><a href="javascript:void(0)" id="btnUpdateCommission" rel="{{ $data1->customer_id }}" class="vk-btn light">Update Payment <i class="fa fa-save"></i></a>
                                                        </td>
                                                    </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <aside class="col-md-3 col-sm-4 col-xs-12 content-aside right_column sidebar-offcanvas">
                    <div class="myprofile">
                        <div class="myprofile--detail">
                            @foreach ($customerData as $data)
                                <h2>{{ $data->firstname }} {{ $data->lastname }}</h2>
                                <p>{{ $data->email }}</p>
                                @if (session()->has('vkaID'))
                                    <p>Total Comission: &#8358;{{ number_format($data->comission_paid) }}</p>
                                @endif
                            @endforeach
                            <ul class="list-inline">
                                <li><a class="btn btn-default" href="{{ url('editaccount') }}"
                                        data-original-title="Edit Profile"><i class="fa fa-pencil-square-o"
                                            aria-hidden="true"></i> Edit Profile</a></li>&nbsp;
                                <li><a class="btn btn-success" href="{{ url('logout') }}" data-original-title="Logout"><i
                                            class="fa fa-sign-out" aria-hidden="true"></i> Logout</a></li>
                            </ul>
                        </div>
                    </div>
                    @include('layouts.adminnav')

                </aside>

            </div>


    </main><!-- End #main -->

    @include('layouts.footer')
@endsection
