@extends('template')
<title>Veritas Kapital Assurance PLC - Agency Transactions</title>
@section('content')
    @include('layouts.header')

    <main id="main">
        <!-- ======= Breadcrumbs Section ======= -->
        <section class="breadcrumbs">
            <div class="container">
                <div class="d-flex justify-content-between align-items-center">
                    <ol>
                        <li><a href="index"><img src="{{ asset('assets/img/icons/icon-home.png') }}">Home</a></li>
                        <li><a href="{{ url('customerdash') }}">My Dashboard</a> </li>
                    </ol>
                </div>
            </div>
        </section><!-- End Breadcrumbs Section -->
        <div id="account-account" class="container dashboard">
            <div class="row">
                <div id="content" class="col-md-9 col-sm-8" style="margin-top:50px;">
                    <div class="dashboard--main">
                        <div class="dashboard--top">
                            <div class="row" >
                                <div class="col-12">
                                    <h2>Transactions Schedule</h2><br /><br/>
                                    {{-- <form method="post" name="frmFilter" action="{{ route('transaction-filter') }}">
                                        @csrf
                                        <div class="row mb-5">
                                            <div class="col-4">
                                                <label>Date From</label>
                                                <input type="date" name="dateFrom" class="form-control" />
                                            </div>
                                            <div class="col-4">
                                                <label>Date To</label>
                                                <input type="date" name="dateTo" class="form-control" />
                                            </div>
                                            <div class="col-4">
                                                <label>&nbsp;&nbsp;&nbsp;</label>
                                                <input type="submit" name="btnFilter" value="Filter" class="form-control btn btn-lg btn-success" />
                                            </div>
                                        </div>
                                    </form> --}}
                                    <div class="table-responsive" style="overflow-x: auto">
                                        <table class="table table-bordered table-striped table-hover" id="example">
                                        <thead>
                                            <th>Transaction Date</th>
                                            <th>Transaction Ref</th>
                                            
                                            <th>Amount (&#8358;)</th>
                                            <th>Action</th>
                                        </thead>
                                        <tbody>
                                            @foreach ($TransactionData as $data1)
                                                    <tr>
                                                        <td>{{ date('Y-m-d', strtotime($data1->trans_date)) }}</td>
                                                        <td>#{{ $data1->trans_reference }}</td>
                                                        
                                                        <td>{{ number_format(ltrim($data1->amount, 0)) }}</td>
                                                        <td><a href="transactionSchedule/{{ $data1->trans_reference }}" target="blank"><i
                                                                    class="fa fa-list-alt"
                                                                    title="View Schedule"></i></a> </td>
                                                    </tr>

                                            @endforeach
                                        </tbody>
                                    </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <aside class="col-md-3 col-sm-4 col-xs-12 content-aside right_column sidebar-offcanvas">

                    @include('layouts.adminnav')

                </aside>

            </div>


    </main><!-- End #main -->

    @include('layouts.footer')
    <Script>
        $(document).ready(function () {
            var table = $('#example').DataTable( {
                    lengthChange: false,
                    buttons: [ 'copy', 'excel', 'pdf', 'colvis' ],
                    order: [[0, 'desc']]
                });

                table.buttons().container()
                    .appendTo( '#example_wrapper .col-md-6:eq(0)' );
                });
    </Script>
@endsection
