@extends('template')
<title>Veritas Kapital Assurance PLC - Unremitted</title>
@section('content')
    @include('layouts.header')

    <main id="main">
        <!-- ======= Breadcrumbs Section ======= -->
        <section class="breadcrumbs">
            <div class="container">
                <div class="d-flex justify-content-between align-items-center">
                    <ol>
                        <li><a href="index"><img src="{{ asset('assets/img/icons/icon-home.png') }}">Home</a></li>
                        <li><a href="{{ url('customerdash') }}">My Dashboard</a> </li>
                        <li><a href="{{ url('list-team-members') }}">Team Members</a> </li>
                    </ol>
                </div>
            </div>
        </section><!-- End Breadcrumbs Section -->
        <div id="account-account" class="container dashboard">
            <div class="row">
                <div id="content" class="col-md-9 col-sm-8" style="margin-top:50px;">
                    <div class="dashboard--main">
                        <div class="dashboard--top">
                            <div class="row">
                                <div class="col-12">
                                    <h2>Team Members</h2>
                                    <div class="table-responsive" style="overflow-x: auto">
                                        <button type="button" class="btn btn-info pull-right" data-toggle="modal" data-target="#exampleModal1">
                                            + New Member
                                        </button>
                                        <table class="table table-bordered table-striped table-hover" id="example">
                                            <thead>
                                                <th>Name</th>
                                                <th>Email Addres</th>
                                                <th>Phone</th>
                                                <th>Status</th>
                                                <!--<th>Action</th>-->
                                            </thead>
                                            <tbody>

                                                @foreach ($teamData as $data1)
                                                    <tr>
                                                        <td>{{ $data1->firstname }} {{ $data1->lastname }}</td>
                                                        <td>{{ $data1->email }} </td>
                                                        <td>{{ $data1->telephone }}</td>
                                                        <td>{{ $data1->agent_status }}</td>
                                                        <!--<td>-->
                                                        <!--    @if ($data1->agent_status == 'Active')-->
                                                        <!--        <a href="Javascript(0)" rel="{{ $data1->customer_id }}"-->
                                                        <!--            name="btnDeactivate" id="btnDeactivate"-->
                                                        <!--            class="btn btn-danger"><i class="fa fa-close"-->
                                                        <!--                title="Deactivate"></i></a>-->
                                                        <!--    @else-->
                                                        <!--        <a href="certificate/" rel="{{ $data1->customer_id }}"-->
                                                        <!--            name="btnActivate" id="btnActivate"-->
                                                        <!--            class="btn btn-success"><i class="fa fa-close"-->
                                                        <!--                title="Activate"></i></a>-->
                                                        <!--    @endif-->

                                                        <!--</td>-->
                                                    </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <aside class="col-md-3 col-sm-4 col-xs-12 content-aside right_column sidebar-offcanvas">

                    @include('layouts.adminnav')

                </aside>

            </div>


    </main><!-- End #main -->
    <div class="modal fade" id="exampleModal1" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Add New Member</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form id="frmAddMember" name="frmAddMember" method="post" action="javascript:void(0)">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="rlr-authforms__inputgroup">
                                    <label class="rlr-form-label rlr-form-label--light required"> First Name </label>
                                    <input type="text" name="firstName" id="firstName"
                                        class="form-control form-control--light" />
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="rlr-authforms__inputgroup">
                                    <label class="rlr-form-label rlr-form-label--light required"> Last Name </label>
                                    <input type="text" name="lastName" id="lastName"
                                        class="form-control form-control--light" value="" />
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="rlr-authforms__inputgroup">
                                    <label class="rlr-form-label rlr-form-label--light required"> Phone Number </label>
                                    <input type="text" name="phone" name="phone"
                                        class="form-control form-control--light" value="" />
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="rlr-authforms__inputgroup">
                                    <label class="rlr-form-label rlr-form-label--light required"> Email Address
                                    </label>
                                    <input type="email" id="email" name="email"
                                        class="form-control form-control--light" value="" />
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="rlr-authforms__inputgroup">
                                    <label class="rlr-form-label rlr-form-label--light required"> Default Password </label>
                                    <input type="password" id="password" name="password"
                                        class="form-control form-control--light" value="" />
                                </div>
                            </div>
                        </div>
                        <br/>
                        <div class="row">
                            {{-- <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button> --}}
                            <button type="button" id="btnSaveAgent" name="btnSaveAgent" class="btn btn-primary btnSaveAgent">Save</button>
                        </div>

                    </form>
                </div>
                <div class="modal-footer">

                </div>
            </div>
        </div>
    </div>


    @include('layouts.footer')
    <Script>
        function formatErrorMessage(jqXHR, exception) {

            if (jqXHR.status === 0) {
                return ('Not connected.\nPlease verify your network connection.');
            } else if (jqXHR.status == 404) {
                return ('The requested page not found. [404]');
            } else if (jqXHR.status == 500) {
                return ('Internal Server Error [500].');
            } else if (exception === 'parsererror') {
                return ('Requested JSON parse failed.');
            } else if (exception === 'timeout') {
                return ('Time out error.');
            } else if (exception === 'abort') {
                return ('Ajax request aborted.');
            } else {
                return ('Uncaught Error.\n' + jqXHR.responseText);
            }
        }

        function payWithPaystack() {

            $(this).hide();
            var handler = PaystackPop.setup({
                key: 'pk_test_110577d52d444541043c731d463ee7411be83f13',
                email: document.getElementById('user_email').value.trim(),
                amount: document.getElementById('total_amount').value * 100,
                currency: 'NGN',
                callback: function(response) {
                    //this happens after the payment is completed successfully
                    var reference = response.reference;
                    iziToast.success({
                        title: 'Please wait...',
                        message: 'Confirming Payment',
                        position: 'topRight'
                    });
                    //alert('Payment complete! Reference: ' + reference);
                    // Make an AJAX call to your server with the reference to verify the transaction
                    $.ajax({
                        url: '/verify_transaction/' + response.reference +
                            '/vendor/{{ $customerData['0']->teamID }}',
                        method: 'post',
                        data: {
                            "_token": "{{ csrf_token() }}"
                        },
                        dataType: "JSON",
                        success: function(response) {
                            // the transaction status is in response.data.status
                            iziToast.destroy();
                            if (response.status.trim() == "success") {
                                iziToast.success({
                                    title: 'Hurraayy!',
                                    message: response.message,
                                    position: 'topRight'
                                });
                                location.reload();
                            } else {
                                iziToast.error({
                                    title: 'Error',
                                    message: '' + response.message,
                                    position: 'topRight'
                                });
                                $(this).show();
                            }
                        },
                        error: function(x, e) {
                            iziToast.destroy();
                            iziToast.error({
                                title: 'Error',
                                message: '' + formatErrorMessage(x, e),
                                position: 'topRight'
                            });
                            $(this).show();
                        }
                    });
                },
                onClose: function() {
                    alert('Transaction was not completed, window closed.');
                    $(this).show();
                },
            });

            handler.openIframe();

        }
        $(document).ready(function() {
            var table = $('#example').DataTable({
                lengthChange: false,
                buttons: ['copy', 'excel', 'pdf', 'colvis']
            });

            table.buttons().container()
                .appendTo('#example_wrapper .col-md-6:eq(0)');
        });
    </Script>
@endsection
