@extends('template')
<title>Veritas Kapital Assurance PLC - Contact</title>
@section('content')
@include('layouts.header')
  <main id="main">

    <!-- ======= Breadcrumbs Section ======= -->
    <section class="breadcrumbs">
      <div class="container">

        <div class="d-flex justify-content-between align-items-center">
          <ol>
            <li><a href="index"><img src="{{ asset('assets/img/icons/icon-home.png') }}">Home</a></li>
            <li>Contact Us</li>
          </ol>
        </div>

      </div>
    </section><!-- End Breadcrumbs Section -->

    <!-- ======= Pricing Section ======= -->
    <section id="whatsapp" style="margin-top: -60px !important;">
      <div class="container" data-aos="fade-up">

        <div class="row"  style="padding-top: 20px !important;">
            <div class="col-md-8">
                <h1>Product Enquiry</h1>
                <p>For immediate attention you can call us on +234(0)700 1000 500
                    or fill out the form below:</p>
                <form action="Mail_post.php" method="post" role="form" class="" data-aos="fade-up">
                    <div class="row">
                        <div class="col-md-4 form-group">
                            <input placeholder="Full Name" type="text" name="name" class="form-control"
                                id="name" data-rule="minlen:4" data-msg="Please enter at least 4 chars" />
                            <div class="validate"></div>
                        </div>
                        <div class="col-md-4 form-group">
                            <input type="hidden" name="subject" value="Product inquiry Form">
                            <input placeholder="Contact Number" type="text" class="form-control"
                                name="number" id="number" data-rule="minlen:4"
                                data-msg="Please enter at least 8 chars of number" />
                            <div class="validate"></div>
                        </div>
                        <div class="col-md-4 form-group">
                            <input placeholder="Your Email" type="email" class="form-control" name="email"
                                id="email" data-rule="email" data-msg="Please enter a valid email" />
                            <div class="validate"></div>
                        </div>
                        <div class="col-md-6 form-group">
                            
                            <input placeholder="Which Product are you interested in?" type="type" class="form-control" name="product"
                                id="product" data-rule="required" data-msg="Please enter a Product" />
                            <div class="validate"></div>
                        </div>
                        <div class="col-md-6 form-group">
                            
                            <input placeholder="Business Address" type="type" class="form-control" name="address"
                                id="address" data-rule="required" data-msg="Please enter Buiness Address" />
                            <div class="validate"></div>
                        </div>
                        <div class="col-md-12 form-group">
                            <textarea placeholder="Brief comment/description of required cover:"
                                class="form-control" name="message" rows="5" data-rule="required"
                                data-msg="Please write something for us"></textarea>
                            <div class="validate"></div>
                        </div>
                        <div class="col-md-12 text-center"><button style="border-radius: 5px;" class="vk-btn green form-control" type="submit">Send
                                Message</button></div>
                    </div>
                </form>
            </div>
        </div>

      </div>
    </section><!-- End Pricing Section -->
  </main><!-- End #main -->
@include('layouts.footer')
@endsection