<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Storage;
use Paystack;
use Illuminate\Support\Facades\Log;
use Carbon\Carbon;

class SoapController extends Controller
 {
    
    public function getNiidData()
    {
        //$current_year = Carbon::now()->format('Y');
        //dd('ok');
        //DB::enableQueryLog(); //query time
        
        $getData = DB::table('3rd_niid_web_service_register')
        ->where('is_successful', '=', 0)
        ->where('eff_from_date', '>', '2022-11-01')
        //->whereYear('eff_from_date', $current_year)
        ->get();
        
       // dd($getData); // query time

        foreach ($getData as $data) {
            
            $update_response = $this->uploadToNiid($data, $data->id);
        }
        
    }
    
    public function uploadCustomerToNiid($policy_number)
    {
        //$current_year = Carbon::now()->format('Y');
        //dd('ok');
        //DB::enableQueryLog(); //query time
        
        $getData = DB::table('3rd_niid_web_service_register')
        ->where('id', '=', $policy_number)
        //->whereYear('eff_from_date', $current_year)
        ->get();
        
       //dd($getData); // query time 

        $update_response = $this->uploadToNiid($getData[0], $getData[0]->id);
        
        echo $update_response;
    }
    
    public function bulkUploadCustomerToNiid($date_from, $date_to)
    {
        //$current_year = Carbon::now()->format('Y');
        //dd('ok');
        //DB::enableQueryLog(); //query time
        
        $getData = DB::table('3rd_niid_web_service_register')
            ->whereBetween('eff_from_date', [$date_from, $date_to])
            ->get();
        
       //dd($getData); // query time 
       
       foreach($getData as $record){
           //dd($record);
           $update_response = $this->uploadToNiid($record, $record->id);
        
            echo json_encode($record)."<hr/>".$update_response;
            echo "<hr/><hr/><hr/>";
       }

        
    }

    public function uploadToNiid($data, $id = 0)
    {
         
        $curl = curl_init();

        curl_setopt_array($curl, array(
        CURLOPT_URL => 'https://www.niid.org/NIA_API/Service.asmx?WSDL',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS =>'<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:hts="http://hts.org/">
        <soapenv:Header/>
        <soapenv:Body>
            <hts:Vehicle_Policy_Push>
                <!--Optional:-->
                <hts:Username>Unityweb</hts:Username>
                <!--Optional:-->
                <hts:Password>ukaWEB@24?7</hts:Password>
                <!--Optional:-->
                <hts:NiaNaicomID>TBA</hts:NiaNaicomID>
                <!--Optional:-->
                <hts:PolicyNo>'.$data->policy_no.'</hts:PolicyNo>
                <!--Optional:-->
                <hts:InsuredName>'.$data->insured_name.'</hts:InsuredName>
                <!--Optional:-->
                <hts:ContactAddress>'.$data->contact_address.'</hts:ContactAddress>
                <!--Optional:-->
                <hts:GSMNo>'.$data->gsm.'</hts:GSMNo>
                <!--Optional:-->
                <hts:Email>'.$data->email.'</hts:Email>
                <!--Optional:-->
                <hts:EffectiveCoverDate>'.$data->eff_from_date.'</hts:EffectiveCoverDate>
                <!--Optional:-->
                <hts:ExpirationDate>'.$data->eff_to_date.'</hts:ExpirationDate>
                <!--Optional:-->
                <hts:TypeOfCover>T</hts:TypeOfCover>
                <!--Optional:-->
                <hts:VehicleCategory>Motor Thirdparty</hts:VehicleCategory>
                <!--Optional:-->
                <hts:EngineNo>'.$data->registration_no.'</hts:EngineNo>
                <!--Optional:-->
                <hts:ChasisNo>'.$data->chasis_no.'</hts:ChasisNo>
                <!--Optional:-->
                <hts:VehicleColor>custom</hts:VehicleColor>
                <!--Optional:-->
                <hts:YearofMake>2009</hts:YearofMake>
                <!--Optional:-->
                <hts:VehicleMake>'.$data->vehicle_make.'</hts:VehicleMake>
                <!--Optional:-->
                <hts:RegistrationNo>'.$data->registration_no.'</hts:RegistrationNo>
                <!--Optional:-->
                <hts:OldRegistrationNo>'.$data->registration_no.'</hts:OldRegistrationNo>
                <!--Optional:-->
                <hts:VehicleType>'.$data->vehicle_type.'</hts:VehicleType>
                <!--Optional:-->
                <hts:EngineCapacity>TBA</hts:EngineCapacity>
                <!--Optional:-->
                <hts:VehicleModel>'.$data->vehicle_model.'</hts:VehicleModel>
                <hts:SumAssured>'.$data->sum_assured.'</hts:SumAssured>
                <hts:Premium>'.$data->premium.'</hts:Premium>
                <!--Optional:-->
                <hts:CoverNoteNo>TBA</hts:CoverNoteNo>
                <!--Optional:-->
                <hts:CertificateNo>TBA</hts:CertificateNo>
                <!--Optional:-->
                <hts:GeographicalZone>'.$data->geographical_zone.'</hts:GeographicalZone>
            </hts:Vehicle_Policy_Push>
        </soapenv:Body>
        </soapenv:Envelope>',
        CURLOPT_HTTPHEADER => array(
            'Content-Type: text/xml',
            'Authorization: Basic VW5pdHl3ZWI6dWthV0VCQDI0Pzc='
        ),
        ));

        $response = curl_exec($curl);

        curl_close($curl);


        $myXMLData = $response;
        $json = json_encode($response);

        $array = json_decode($json);
        //return $array."(".$data->registration_no.")";
        //dd($myXMLData);
        
        if(strlen($myXMLData) < 1){
            return "No Response from NIID - ".$json;
        }
        
        $doc = new \DOMDocument();
        $doc->loadXML($myXMLData);
        $xpath = new \DOMXPath($doc);
        //dd($xpath);

        $description_tag = $doc->getElementsByTagName("Vehicle_Policy_PushResult")->item(0)->nodeValue;
        //dd($description_tag);

        if (strtolower($description_tag) == "successful") {
            $msg = $description_tag; $is_success = '1';
        }else{
            $msg = $description_tag; $is_success = '0';
            
            if($id > 0){
                $data->niid_message = $description_tag;
                $SendCustomerEmail = (new MailController)->sendNiidErrorEmail($data, $id);
                
                //return $SendCustomerEmail;
            }
        }


        $updateData = DB::table('3rd_niid_web_service_register')
            ->where('id', $data->id)
                ->update(['message' =>$msg, 'is_successful'=>$is_success]);
                
        return $msg;
        //dd($updateData);
    }
    
    public function getWhatsappNiidData()
    {
        $current_year = Carbon::now()->format('Y');
        
        $getData = DB::connection('mysql2')
                    ->table('3rd_niid_web_service_register')
                    ->whereYear('eff_from_date', $current_year)
                    ->where('id', '>', 145000)
                    ->where('is_successful', '=', 0)
                     ->get();
                      //dd($getData);
        foreach ($getData as $data) {
            //dd($data);
            $update_response = $this->uploadWhatsappToNiid($data);
        }
    }
    
    public function uploadWhatsappToNiid($data)
    {

        $curl = curl_init();

        curl_setopt_array($curl, array(
        CURLOPT_URL => 'https://www.niid.org/NIA_API/Service.asmx?WSDL',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS =>'<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:hts="http://hts.org/">
        <soapenv:Header/>
        <soapenv:Body>
            <hts:Vehicle_Policy_Push>
                <!--Optional:-->
                <hts:Username>Unityweb</hts:Username>
                <!--Optional:-->
                <hts:Password>ukaWEB@24?7</hts:Password>
                <!--Optional:-->
                <hts:NiaNaicomID>TBA</hts:NiaNaicomID>
                <!--Optional:-->
                <hts:PolicyNo>'.$data->policy_no.'</hts:PolicyNo>
                <!--Optional:-->
                <hts:InsuredName>'.$data->insured_name.'</hts:InsuredName>
                <!--Optional:-->
                <hts:ContactAddress>'.$data->contact_address.'</hts:ContactAddress>
                <!--Optional:-->
                <hts:GSMNo>'.$data->gsm.'</hts:GSMNo>
                <!--Optional:-->
                <hts:Email>'.$data->email.'</hts:Email>
                <!--Optional:-->
                <hts:EffectiveCoverDate>'.$data->eff_from_date.'</hts:EffectiveCoverDate>
                <!--Optional:-->
                <hts:ExpirationDate>'.$data->eff_to_date.'</hts:ExpirationDate>
                <!--Optional:-->
                <hts:TypeOfCover>T</hts:TypeOfCover>
                <!--Optional:-->
                <hts:VehicleCategory>Motor Thirdparty</hts:VehicleCategory>
                <!--Optional:-->
                <hts:EngineNo>'.$data->registration_no.'</hts:EngineNo>
                <!--Optional:-->
                <hts:ChasisNo>'.$data->registration_no.'</hts:ChasisNo>
                <!--Optional:-->
                <hts:VehicleColor>custom</hts:VehicleColor>
                <!--Optional:-->
                <hts:YearofMake>2009</hts:YearofMake>
                <!--Optional:-->
                <hts:VehicleMake>'.$data->vehicle_make.'</hts:VehicleMake>
                <!--Optional:-->
                <hts:RegistrationNo>'.$data->registration_no.'</hts:RegistrationNo>
                <!--Optional:-->
                <hts:OldRegistrationNo>'.$data->registration_no.'</hts:OldRegistrationNo>
                <!--Optional:-->
                <hts:VehicleType>Private</hts:VehicleType>
                <!--Optional:-->
                <hts:EngineCapacity>TBA</hts:EngineCapacity>
                <!--Optional:-->
                <hts:VehicleModel>'.$data->vehicle_model.'</hts:VehicleModel>
                <hts:SumAssured>'.$data->sum_assured.'</hts:SumAssured>
                <hts:Premium>'.$data->premium.'</hts:Premium>
                <!--Optional:-->
                <hts:CoverNoteNo>TBA</hts:CoverNoteNo>
                <!--Optional:-->
                <hts:CertificateNo>TBA</hts:CertificateNo>
                <!--Optional:-->
                <hts:GeographicalZone>'.$data->geographical_zone.'</hts:GeographicalZone>
            </hts:Vehicle_Policy_Push>
        </soapenv:Body>
        </soapenv:Envelope>',
        CURLOPT_HTTPHEADER => array(
            'Content-Type: text/xml',
            'Authorization: Basic VW5pdHl3ZWI6dWthV0VCQDI0Pzc='
        ),
        ));

        $response = curl_exec($curl);

        curl_close($curl);


        $myXMLData = $response;
        $json = json_encode($response);

        $array = json_decode($json);
        //dd($array);
        $doc = new \DOMDocument();
        $doc->loadXML($myXMLData);
        $xpath = new \DOMXPath($doc);
        //dd($xpath);

        $description_tag = $doc->getElementsByTagName("Vehicle_Policy_PushResult")->item(0)->nodeValue;
        //dd($description_tag);

        if ($description_tag == "successful") {
            $msg = $description_tag; $is_success = 1;
        }else{
            $msg = $description_tag; $is_success = 0;
        }


        $updateData = DB::connection('mysql2')
                    ->table('3rd_niid_web_service_register')
                    ->where('id', $data->id)
                ->update(['message' =>$msg, 'is_successful'=>$is_success, 'date_attempted'=>now()]);
        //dd($updateData);
    }
 }
