<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Redirect;
use PDF;
use Illuminate\Support\Facades\Storage;
use Paystack;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Carbon;
use Illuminate\Support\Str;
use DateTime;

class PolicyController extends Controller
{
    public function marinePolicy()
    {
        //$modal = ['S', 'G', 'P'];
        $Policy = DB::table('tbl_subpolicy')
            ->WHERE('policyID', '=', 7)
        ->get();

        $getAccessStatus = DB::table('tbl_team_has_policy_marine')
            ->WHERE('teamID', '=', session('teamId'))
            ->WHERE('policyID', '=', 7)
        ->first();
        //dd($getAccessStatus);

        if (!$getAccessStatus) {
            $accessStatus = 0;
        }else{
            $accessStatus = 1;
        }


        return view('body.marine.Marine', compact('Policy', 'accessStatus'));

    }
    
    public function personalPolicy()
    {
        //$modal = ['S', 'G', 'P'];
        $Policy = DB::table('tbl_subpolicy')
            ->WHERE('policyID', '=', 1)
        ->get();
        
        $getAccessStatus = DB::table('tbl_team_has_policy')
            ->WHERE('teamID', '=', session('teamId'))
            ->WHERE('policyID', '=', 1)
        ->first();
        //dd($getAccessStatus);

        if (!$getAccessStatus) {
            $accessStatus = 0;
        }else{
            $accessStatus = 1;
        }


        return view('body.personal.Personal', compact('Policy', 'accessStatus'));

    }
    

    public function householderPolicy()
    {
        $hPolicy = DB::table('tbl_subpolicy')
            ->WHERE('policyID', '=', 2)
            ->get();
        //dd($Policy);

        $getAccessStatus = DB::table('tbl_team_has_policy')
            ->WHERE('teamID', '=', session('teamId'))
            ->WHERE('policyID', '=', 2)
        ->first();
        //dd($getAccessStatus);

        if (!$getAccessStatus) {
            $accessStatus = 0;
        }else{
            $accessStatus = 1;
        }

        return view('body.house.Householder', compact('hPolicy', 'accessStatus'));
    }

    public function firePolicy()
    {
        $fPolicy = DB::table('tbl_subpolicy')
            ->WHERE('policyID', '=', 4)
            ->get();
        //dd($Policy);

        $getAccessStatus = DB::table('tbl_team_has_policy')
            ->WHERE('teamID', '=', session('teamId'))
            ->WHERE('policyID', '=', 4)
        ->first();
        //dd($getAccessStatus);

        if (!$getAccessStatus) {
            $accessStatus = 0;
        }else{
            $accessStatus = 1;
        }

        return view('body.fire.Fire', compact('fPolicy', 'accessStatus'));
    }

    public function motorPolicy()
    {
        $mPolicy = DB::table('tbl_subpolicy')
            ->WHERE('policyID', '=', 3)
            ->get();
        //dd($mPolicy);
        
        $accessStatus = 0;

      $getAccessStatus = DB::table('tbl_team_has_policy')
            ->WHERE('teamID', '=', session('teamId'))
            ->WHERE('policyID', '=', 3)
        ->first();
        //dd($getAccessStatus);

        if (!$getAccessStatus) {
            $accessStatus = 0;
        }else{
            $accessStatus = 1;
        }
       

        return view('body.motor.Motor', compact('mPolicy', 'accessStatus'));
    }

    public function fire_sPolicy()
    {
        $fsPolicy = DB::table('tbl_subpolicy')
            ->WHERE('policyID', '=', 5)
            ->get();
        //dd($mPolicy);
         $getAccessStatus = DB::table('tbl_team_has_policy')
            ->WHERE('teamID', '=', session('teamId'))
            ->WHERE('policyID', '=', 5)
        ->first();
        //dd($getAccessStatus);

        if (!$getAccessStatus) {
            $accessStatus = 0;
        }else{
            $accessStatus = 1;
        }

        return view('body.fire_and_perils.fire_sIndex', compact('fsPolicy', 'accessStatus'));
    }
    
    public function travelPolicy()
    {
        
        
        $fPolicy = DB::table('tbl_subpolicy')
        ->WHERE('policyID', '=', 6)
        ->get();
        
        //live mappings
        // $schengen = [27];
        // $europe_schengen = [28];
        // $student_worldwide = [29, 30, 31];
        // $student_worldwide_1 = [39, 40, 41];
        // $worldwide = [32, 33, 34, 35];
        // $pilgrimage = [36, 37, 38];
        
        //demo mappings
        $schengen = [27];
        $europe_schengen = [28];
        $student_worldwide = [29, 30, 31];
        $worldwide = [32, 33, 34, 35];
        $pilgrimage = [36, 37, 38];
        
        //filter schengen policies
        $schengen_policies = collect($fPolicy)->filter(function ($subPolicy) use ($schengen) {
            // Check if the subPolicy_id is in the $subPolicyIds array
            return in_array($subPolicy->subPolicy_id, $schengen);
        });
        $schengen_plan = (object)["name" => "Schengen Only Plans", "list" => $schengen_policies];
        
        //filter europe schengen policies
        $europe_schengen_policies = collect($fPolicy)->filter(function ($subPolicy) use ($europe_schengen) {
            // Check if the subPolicy_id is in the $subPolicyIds array
            return in_array($subPolicy->subPolicy_id, $europe_schengen);
        });
        $europe_schengen_plan = (object)["name" => "Europe & Schengen Plans", "list" => $europe_schengen_policies];
        
        //filter student worldwide policies
        $student_worldwide_policies = collect($fPolicy)->filter(function ($subPolicy) use ($student_worldwide) {
            // Check if the subPolicy_id is in the $subPolicyIds array
            return in_array($subPolicy->subPolicy_id, $student_worldwide);
        });
        $student_worldwide_plan = (object)["name" => "Student Worldwide Plans", "list" => $student_worldwide_policies];
        
        //filter worldwide policies
        $worldwide_policies = collect($fPolicy)->filter(function ($subPolicy) use ($worldwide) {
            // Check if the subPolicy_id is in the $subPolicyIds array
            return in_array($subPolicy->subPolicy_id, $worldwide);
        });
        $worldwide_plan = (object)["name" => "Worldwide Plans", "list" => $worldwide_policies];
        
        //filter pilgrimage policies
        $pilgrimage_policies = collect($fPolicy)->filter(function ($subPolicy) use ($pilgrimage) {
            // Check if the subPolicy_id is in the $subPolicyIds array
            return in_array($subPolicy->subPolicy_id, $pilgrimage);
        });
        $pilgrimage_plan = (object)["name" => "Pilgrimage Plans", "list" => $pilgrimage_policies];
        
        //create travel plan grouping
        $grouping = [$schengen_plan, $europe_schengen_plan, $student_worldwide_plan, $worldwide_plan, $pilgrimage_plan];
        
        //dd($grouping);

        $policyCountries = DB::table('tbl_policy_countries')
        ->join('tbl_country', 'tbl_country.id', '=', 'tbl_policy_countries.countryID')
        ->WHERE('subPolicyID', '=', 6)
        ->get();

        $dob_min_date = date('Y-m-d');
        $date_day = (date('d'));
        $max_date = date('Y-m-'.$date_day.'');

        //dd($Policy);
         $getAccessStatus = DB::table('tbl_team_has_policy')
            ->WHERE('teamID', '=', session('teamId'))
            ->WHERE('policyID', '=', 3)
        ->first();
        if (!$getAccessStatus) {
            $accessStatus = 0;
        }else{
            $accessStatus = 1;
        }
        
        return view('body.travel.travel', 
            compact('fPolicy', 'max_date', 'policyCountries', 'dob_min_date', 'accessStatus', 'grouping')
        );
    }

    public function getPolicyCountries($subPolicyID)
    {
        $policyCountries = DB::table('tbl_policy_countries')
        ->join('tbl_country', 'tbl_country.id', '=', 'tbl_policy_countries.countryID')
        ->WHERE('subPolicyID', '=', $subPolicyID)
        ->orderby('tbl_country.nicename', 'ASC')
        ->get();
        
        $country_list = '-1';
        if(count($policyCountries) > 0){
            $country_list = '<option value="-1">Select Destination Country</option>';
            foreach ($policyCountries as $country => $value) {
                if($value->id == "206" || strtolower($value->iso) == "ch" || strtolower($value->nicename) == "switzerland"){
                    continue;
                }
                $country_list .= '<option value="' . $value->iso . '">'.$value->nicename.'</option>';
            }
        }

        if($country_list == '-1'){
            return response()->json([
                'status' => 'error',
                'message' => 'No Record Available',
            ]);
        }

        return response()->json([
            'status' => 'success',
            'records' => $country_list,
        ]);
        
        //dd($Policy);
    }

    public function getDateDifference($fromDate, $toDate)
    {
        $to = Carbon::createFromFormat('Y-m-d', $toDate);

        $from = Carbon::createFromFormat('Y-m-d', $fromDate);

        $diff_in_days = $to->diffInDays($from);
        
        //date difference does not include the start date in the days count, we add 1 to get the accurate number of days
        return ($diff_in_days + 1);
    }
    
    public function calculateAge($date) 
    {
        $date = new \Carbon\Carbon($date);
        return (int) $date->diffInYears();
    }

    public function getSubPolicyPlans(Request $request)
    {

        //dd($request);
        $validator = Validator::make($request->all(), [
            'firstName' => 'required',
            'return_date' => 'required',
            'lastName' => 'required',
            'email' => 'required',
            'phone' => 'required',
            'customer_phone_number' => 'required',
            'dob' => 'required',
            'address' => 'required',
            'state' => 'required',
            'id_number' => 'required',
            'departure_date' => 'required',
            'return_date' => 'required',
            'cmbCountry' => 'required',
            'subPolicyID' => 'required',
        ]);

        if ($validator->fails()) {
            return response()->json([
                'status' => 'error',
                'message' => 'Please fill in required fields',
            ]);
        }

        $subPolicyID = $request->subPolicyID;
        $destination_country = $request->cmbCountry;
        $departure_date = $request->departure_date;
        $return_date = $request->return_date;
        $dateOfBirth = $request->dob;

        $date_difference = $this->getDateDifference($departure_date, $return_date);
        $age = $this->calculateAge($dateOfBirth);
        
        $marketing_data = array(
            "firstName" => $request->firstName,
            "lastName" => $request->lastName,
            "email" => $request->email,
            "phone" => $request->phone,
            "address" => $request->address,
            "state" => $request->state,
            "cmbCountry" => $request->cmbCountry
        );
        DB::table('tbl_travel_marketing_list')->insert($marketing_data);
        
        

        $plans = DB::table('tbl_plans')
        ->join('tbl_subpolicy', 'tbl_subpolicy.subPolicy_id', '=', 'tbl_plans.subPolicyID')
        ->WHERE('subPolicyID', '=', $subPolicyID)
        ->WHERE('max_travel_days', '>=', $date_difference)
        ->orderBy('max_travel_days', 'asc')
        ->take(1)
        ->first();
        
        //dd($plans);

        if (!$plans) {
            return response()->json([
                'status' => 'error',
                'message' => 'No Record Available',
            ]);
        }
        
        if ($age >= 81 && ($plans->subPolicyID != "27" && $plans->subPolicyID != "28") ) {
            // Only the Europe/Schengen Policy shall be available
            return response()->json([
                'status' => 'error',
                'message' => "We're sorry, but we can only provide coverage to Europe/Schengen countries for customers aged 81 and above. 
                              For assistance, please contact our support team.",
            ]);

        }
        
        $amount = $plans->amount;
        $premium = $this->calculatePremium($dateOfBirth, $amount);
        $note = "";
        
        if ($age >= 3 && $age <= 18) {
            //$note = "Kindly note that a 50% discount has been applied for this customer because the age is between 3 months and 18 years";
            $amount *= 0.5;
        } elseif ($age >= 66 && $age <= 75) {
            // Increase of 50% for persons aged between 66 and 75 years
            $amount *= 1.5;
        } elseif ($age >= 76 && $age <= 80) {
            // Increase of 100% for persons aged between 76 and 80 years
            $amount *= 2;
        } elseif ($age >= 81) {
            // Increase of 300% for persons aged from 81 years
            // Only the Europe/Schengen Policy shall be available
            $amount *= 4; // Increase by 300% is equivalent to multiplying by 4
        }

        return response()->json([
            'status' => 'success',
            'records' => $plans,
            'premium' => $premium,
            'salutation' => "Hi ".$request->firstName.' '.$request->lastName,
            'duration' => $date_difference,
            'note' => $note,
            'travel_date' => "From ".date('M d, Y', strtotime($departure_date)).' to '. date('M d, Y', strtotime($return_date)),
        ]);

        //dd($Policy);
    }
    
    public function calculatePremium($dateOfBirth, $amount)
    {
        // Convert date of birth string to Carbon instance
        $dob = Carbon::createFromFormat('Y-m-d', $dateOfBirth);
        
        // Calculate age
        $age = $dob->diffInYears(Carbon::now());

        // Apply premium adjustments based on age
        if ($age >= 3 && $age <= 18) {
            // Reduction of 50% for persons between 3 months and 18 years
            $amount *= 0.5;
        } elseif ($age >= 66 && $age <= 75) {
            // Increase of 50% for persons aged between 66 and 75 years
            $amount *= 1.5;
        } elseif ($age >= 76 && $age <= 80) {
            // Increase of 100% for persons aged between 76 and 80 years
            $amount *= 2;
        } elseif ($age >= 81) {
            // Increase of 300% for persons aged from 81 years
            // Only the Europe/Schengen Policy shall be available
            $amount *= 4; // Increase by 300% is equivalent to multiplying by 4
        }

        // Return the adjusted premium amount
        return $amount;
    }

    public function bookPolicy($id)
    {
        $pPolicy = DB::table('tbl_subpolicy')
            ->WHERE('upc', '=', $id)
            ->get();
        $getVehicleMake = DB::table('tbl_niip_vehicle_make')->get();
        $getVehicleMakeMotorcycle = DB::table('tbl_niip_vehicle_make')->where('category','tricycle')->get();
        $getVehicleMakeTricycle = DB::table('tbl_niip_vehicle_make')->where('category','tricycle')->get();
        $getVehicleModel = DB::table('tbl_niip_vehicle_model')->get();
        $getVehicleColour = DB::table('tbl_niip_vehicle_colour')->get();
        $getVehicleEngine = DB::table('tbl_niip_engine_capacity')->get();
        $getVehicleState = DB::table('tbl_niip_state')->get();
        $getVehicleLga = DB::table('tbl_niip_lga')->get();
        
        //dd($getVehicleModel);
        
        // $getVehicleMake = DB::table('vehicle_make')->get();
        // $getVehicleModel = DB::table('vehicle_model')->where('v_type', '<>', 'motorbike')->get();
        // $getBikeModel = DB::table('vehicle_model')->where('v_type', '=', 'motorbike')->get();
        // $getCycleModel = DB::table('vehicle_model')->where('v_type', '=', 'motorcycle')->get();
        
            $countUnremitted = DB::table('tbl_order')
                ->join('tbl_customer','tbl_order.customerID','=','tbl_customer.customer_id')
                ->join('tbl_transaction', 'tbl_transaction.orderID', '=', 'tbl_order.order_id')
                ->WHERE('teamID', '=', session('teamId'))
                ->WHERE('payment_statusID', '<>', 5)
            ->count();
        return view(
            'body.personal.bookPersonal',
            compact(
                'pPolicy',
                'getVehicleMake',
                'getVehicleModel',
                'getVehicleColour',
                'getVehicleEngine',
                'getVehicleState',
                'getVehicleLga',
                'getVehicleMakeMotorcycle',
                'getVehicleMakeTricycle',
                'countUnremitted'
            )
        );
    }

    // public function getVehicleModel($id)
    // {
    //     $getVehicleModel = DB::table('vehicle_model')
    //         ->get();

    // }

    public function bookPackage($id)
    {
        $pPolicy = DB::table('tbl_subpolicy')
            // ->join('contacts', 'users.id', '=', 'contacts.user_id')
            ->join(
                'tbl_policy',
                'tbl_subPolicy.policyID',
                '=',
                'tbl_policy.policy_id'
            )
            ->WHERE('upc', '=', $id)
            ->get();
        //dd($pPolicy);
        return view('body.package_descr', compact('pPolicy'));
    }
    
    public function getVehicleModels($makeCode)
    {
        // Get the vehicle models for the selected make
        $vehicleModels = DB::table('tbl_niip_vehicle_model')
            ->where('makeID', $makeCode)
            ->get();

        // Return the models as JSON
        return response()->json($vehicleModels);
    }
    
    public function confirmCheckout()
    {
        $order_id = 0;
        
        if(session('orderID')){
            $order_id = session('orderID');
        }
        
        
        if($order_id > 0){
            $orderData = [];
        
            if(session('planID')){ //if policy is travel insurance
            
                $orderData = DB::table('tbl_order')
                ->join(
                    'tbl_customer',
                    'tbl_order.customerID',
                    '=',
                    'tbl_customer.customer_id'
                )
                ->join(
                    'tbl_subpolicy',
                    'tbl_subpolicy.upc',
                    '=',
                    'tbl_order.subPolicyID'
                )
                ->join(
                    'tbl_policy',
                    'tbl_policy.policy_id',
                    '=',
                    'tbl_subpolicy.policyID'
                )
                 ->join(
                    'tbl_plans',
                    'tbl_plans.id',
                    '=',
                    'tbl_order.planID'
                )
                //->join('tbl_order_status', 'tbl_order_status.order_status_id', '=', 'tbl_order.order_statusID')
                ->WHERE('order_id', '=', $order_id)
                ->limit(1)
                ->get()
                ->toArray();
                
                //dd($orderData);
                
                if(count($orderData) < 1){
                    return Redirect::back()->withErrors(['msg' => 'Oops!! Unexpected error. If error persists, Refresh the page and try again']);
                }
                
                $dest_country = trim($orderData[0]->destination_country);
                $orderData[0]->subPolicy_price = $orderData[0]->amount;
                $orderData[0]->dest_country = $dest_country;
            }else{
                $orderData = DB::table('tbl_order')
                ->join(
                    'tbl_customer',
                    'tbl_order.customerID',
                    '=',
                    'tbl_customer.customer_id'
                )
                ->join(
                    'tbl_subpolicy',
                    'tbl_subpolicy.upc',
                    '=',
                    'tbl_order.subPolicyID'
                )
                ->join(
                    'tbl_policy',
                    'tbl_policy.policy_id',
                    '=',
                    'tbl_subpolicy.policyID'
                )
                ->join(
                    'tbl_order_status',
                    'tbl_order_status.order_status_id',
                    '=',
                    'tbl_order.order_statusID'
                )
                ->WHERE('order_id', '=', $order_id)
                ->get();
                //  dd($orderData); exit();
            }
            
            //dd($orderData);
    
            if (count($orderData) < 1) {
                return Redirect::back()->withErrors(['msg' => 'Oops!! Unexpected error. Try again']);
                // return response()->json([
                //     'status' => 'error',
                //     'message' => 'Oops!! Unexpected error. Try again'
                // ]);
            }
            
            return view('body.confirmCheckout', compact('orderData'));
        }else{
            return Redirect::back()->withErrors(['msg' => 'Something went wrong. Unable to complete request']);
        }
        
    }
    
    public function ajaxAddPersonalPolicyIntoDB(Request $request)
    {
        /*
            Check if policy record exist before proceeding to payment
            Error: Message: A policy exists with the same Passport Number with a validity period that overlaps the current policy period
        */
        $is_policy_exist = DB::table('tbl_order')
            ->WHERE('id_number', '=', $request->id_number)
            ->WHERE('order_statusID', '=', 5)
            ->whereBetween('departure_date', [$request->departure_date, $request->return_date])
            ->WhereBetween('return_date',  [$request->departure_date, $request->return_date])
            ->get();
            
            
        if(count($is_policy_exist) > 0){
            return response()->json([
                'status' => 'error',
                'message' => 'Oops!! A policy exists with the same Passport Number and <br/> a validity period that overlaps the current policy period'
            ]);
        }
            
        session()->pull('planID');
        //dd($request);
        $x = DB::table('tbl_order')->insertGetId([
            'customerID' => $request->customerID,
            'subPolicyID' => $request->upc,
            'firstName' => $request->firstName,
            'lastName' => $request->lastName,
            'email' => $request->email,
            'dob' => $request->dob,
            'planID' => $request->planID,
            'phone' => $request->customer_phone_number,
            'gender' => $request->gender,
            'form_of_id' => $request->form_of_id,
            'id_number' => $request->id_number,
            'refer_code' => $request->refer_code,
            'address' => $request->address,
            'destination_country' => $request->cmbCountry,
            'departure_date' => $request->departure_date,
            'return_date' => $request->return_date,
            'order_statusID' => 9,
            'sale_channel' => 'retail site',
            'state' => $request->state,
        ]);
        
        // $orderData = DB::table('tbl_order')
        //     ->join(
        //         'tbl_customer',
        //         'tbl_order.customerID',
        //         '=',
        //         'tbl_customer.customer_id'
        //     )
        //     ->join(
        //         'tbl_subpolicy',
        //         'tbl_subpolicy.upc',
        //         '=',
        //         'tbl_order.subPolicyID'
        //     )
        //     ->join(
        //         'tbl_policy',
        //         'tbl_policy.policy_id',
        //         '=',
        //         'tbl_subpolicy.policyID'
        //     )
        //     ->join(
        //         'tbl_order_status',
        //         'tbl_order_status.order_status_id',
        //         '=',
        //         'tbl_order.order_statusID'
        //     )
        //     ->WHERE('order_id', '=', $x)
        //     ->get();
            
        $orderData = [];
        
        if(session('planID')){ //if policy is travel insurance
            $orderData = DB::table('tbl_order')
            ->join(
                'tbl_customer',
                'tbl_order.customerID',
                '=',
                'tbl_customer.customer_id'
            )
            ->join(
                'tbl_subpolicy',
                'tbl_subpolicy.upc',
                '=',
                'tbl_order.subPolicyID'
            )
            ->join(
                'tbl_policy',
                'tbl_policy.policy_id',
                '=',
                'tbl_subpolicy.policyID'
            )
             ->join(
                'tbl_plans',
                'tbl_plans.id',
                '=',
                'tbl_order.planID'
            )
            //->join('tbl_order_status', 'tbl_order_status.order_status_id', '=', 'tbl_order.order_statusID')
            ->WHERE('order_id', '=', $x)
            ->limit(1)
            ->get()
            ->toArray();
            
            $dateOfBirth = $request->dob;
            $age = $this->calculateAge($dateOfBirth);
            $amount = $orderData[0]->amount;
            $premium = $this->calculatePremium($dateOfBirth, $amount);

            //$dest_country = $this->getDestinationCountry($orderData[0]->destination_country);
            $dest_country = trim($orderData[0]->destination_country);
            $orderData[0]->subPolicy_price = $premium;
            $orderData[0]->dest_country = $dest_country;
        }else{
            $orderData = DB::table('tbl_order')
            ->join(
                'tbl_customer',
                'tbl_order.customerID',
                '=',
                'tbl_customer.customer_id'
            )
            ->join(
                'tbl_subpolicy',
                'tbl_subpolicy.upc',
                '=',
                'tbl_order.subPolicyID'
            )
            ->join(
                'tbl_policy',
                'tbl_policy.policy_id',
                '=',
                'tbl_subpolicy.policyID'
            )
            ->join(
                'tbl_order_status',
                'tbl_order_status.order_status_id',
                '=',
                'tbl_order.order_statusID'
            )
            ->WHERE('order_id', '=', $x)
            ->get();
            //  dd($orderData); exit();
        }
        
        //dd($orderData); exit();

        if (count($orderData) < 0) {
            return response()->json([
                'status' => 'error',
                'message' => 'Oops!! Unexpected error. Try again'
            ]);
        }

        $request->session()->put('orderID', $x);
        $request->session()->put('planID', $request->planID);

        if (session('user_id')) {
            //if user already logged in, update tbl_order and set customerID, also fetch records to be displayed in confirm checkout.

            return response()->json([
                'status' => 'success',
                'message' => 'confirmCheckout',
                'data' => compact('orderData'),
                'view' => view('body.confirmCheckout', compact('orderData'))
            ]);

        } else {
            return response()->json([
                'status' => 'success',
                'message' => 'checkout',
                'view' => view('body.checkout')
            ]);
        }

    }
    
    public function ajaxProceedToCheckout($order_id)
    {
        //dd($order_id);
        if (session('user_id')) {
            $orderData = [];
            
            if(session('planID')){ //if policy is travel insurance
                $orderData = DB::table('tbl_order')
                ->join(
                    'tbl_customer',
                    'tbl_order.customerID',
                    '=',
                    'tbl_customer.customer_id'
                )
                ->join(
                    'tbl_subpolicy',
                    'tbl_subpolicy.upc',
                    '=',
                    'tbl_order.subPolicyID'
                )
                ->join(
                    'tbl_policy',
                    'tbl_policy.policy_id',
                    '=',
                    'tbl_subpolicy.policyID'
                )
                ->join(
                    'tbl_plans',
                    'tbl_plans.id',
                    '=',
                    'tbl_order.planID'
                )
                //->join('tbl_order_status', 'tbl_order_status.order_status_id', '=', 'tbl_order.order_statusID')
                ->WHERE('order_id', '=', $order_id)
                ->limit(1)
                ->get()
                ->toArray();
                //$dest_country = $this->getDestinationCountry($orderData[0]->destination_country);
                
                $dateOfBirth = $orderData[0]->dob;
                $age = $this->calculateAge($dateOfBirth);
                $amount = $orderData[0]->amount;
                $premium = $this->calculatePremium($dateOfBirth, $amount);
                
                //$dest_country = $this->getDestinationCountry($orderData[0]->destination_country);
                $dest_country = trim($orderData[0]->destination_country);
                $orderData[0]->subPolicy_price = $premium;
                $orderData[0]->dest_country = $dest_country;
            }else{
                $orderData = DB::table('tbl_order')
                ->join(
                    'tbl_customer',
                    'tbl_order.customerID',
                    '=',
                    'tbl_customer.customer_id'
                )
                ->join(
                    'tbl_subpolicy',
                    'tbl_subpolicy.upc',
                    '=',
                    'tbl_order.subPolicyID'
                )
                ->join(
                    'tbl_policy',
                    'tbl_policy.policy_id',
                    '=',
                    'tbl_subpolicy.policyID'
                )
                ->join(
                    'tbl_order_status',
                    'tbl_order_status.order_status_id',
                    '=',
                    'tbl_order.order_statusID'
                )
                ->WHERE('order_id', '=', $order_id)
                ->get();
                //  dd($orderData); exit();
            }
            
            //dd($orderData);

            if (count($orderData) < 0) {
                return response()->json([
                    'status' => 'error',
                    'message' => 'Oops!! Unexpected error. Try again'
                ]);
            }

            return view('body.confirmCheckout', compact('orderData'));
        } else {
           return redirect()->action([PolicyController::class, 'checkoutPage', ]);
        }

        //return back()->with('PolicyIntoDBSuccess', 'Order Submitted Successfully');
    }

    public function addMarinePolicyIntoDB(Request $request)
    {

        $customerData = DB::table('tbl_customer')->where('customer_id', $request->customerID)->first();
        
        if($request->typeOfPurchase=="customer"){
            $firstName = $request->firstName;
            $lastName = $request->lastName;
            $phone = $request->phone;
            $email = $request->email;
        }else{
            $firstName = $customerData->firstname;
            $lastName = $customerData->lastname;
            $phone = $customerData->telephone;
            $email = $customerData->email;
        }
        
        $getWallet = DB::table('tbl_wallet')
            ->WHERE('customerID', '=', session('user_id'))
        ->first();
        
        //Calculate excess
        $excess_calc = (10/100) * $request->sumAssured;

        if ($request->sumAssured > 500000000) {
            $excess = "500,000.00 OR 10.00 % of claim whichever is higher";
        }elseif ($request->sumAssured >= 100000000 && $request->sumAssured <= 99000000) {
            $excess = "250,000.00 OR 10.00 % of claim whichever is higher";
        }elseif ($request->sumAssured  < 99000000) {
            $excess = "50,000.00 OR 10.00 % of claim whichever is higher";
        }


        $sum = $request->fobValue + $request->fleetValue;
        $percentLoad = (10/100) * $sum;

        // if($request->transCurrency==="ngn"){
        //     $sumInsured = $sum;
        // }else{
        //     $sumInsured = $sum + $percentLoad;
        // }


        $x = DB::table('tbl_order')->insertGetId([
            'customerID' => $request->customerID,
            'subPolicyID' => $request->subPolicyID,
            'firstName' => $firstName,
            'lastName' => $lastName,
            'email' => $email,
            'dob' => $request->dob,
            'phone' => $phone,
            'address' => $request->address,
            'occupation' => $request->occupation,
            'form_of_id' => $request->form_of_id,
            'id_number' => $request->id_number,
            'invoice_value' => $request->invoiceValue,


            'bank_name' => $request->bankName,
            'tax_id_no' => $request->taxIdNo,
            'currency' => $request->transCurrency,
            'marine_from' => $request->vesselSource,
            'marine_to' => $request->vesselDestination,

            
            'percent_premium' => $request->premium_rate,
            'percent_sum_insured' => $request->sumAssured,
            'credit_note_number' => $request->creditNoteNo,
            //'fob_value' => $request->fobValue,
            //'fleet_value' => $request->fleetValue,
            'cargo_description' => $request->cargoDesc,
            'marine_excess' => $excess,
            // 'vessel_make_model' => $request->vesselMakeModel,
            // 'vessel_reg_number' => $request->vesselRegNo,
            // 'vessel_type' => $request->vesselType,
            'order_statusID' => 1,
            'sale_channel' => 'retail site',
            'state' => $request->state,

        ]);

        $request->session()->put('orderID', $x);

        if (session('user_id')) {
            //if user already logged in, update tbl_order and set customerID, also fetch records to be displayed in confirm checkout.
            $updatequery = DB::table('tbl_order')
                ->where('order_id', $x)
                ->update(['customerID' => session('user_id')]);
            //dd($updatequery);

            $orderData = DB::table('tbl_order')
                ->join(
                    'tbl_customer',
                    'tbl_order.customerID',
                    '=',
                    'tbl_customer.customer_id'
                )
                ->join(
                    'tbl_subpolicy',
                    'tbl_subpolicy.upc',
                    '=',
                    'tbl_order.subPolicyID'
                )
                ->join(
                    'tbl_policy',
                    'tbl_policy.policy_id',
                    '=',
                    'tbl_subpolicy.policyID'
                )
                 ->join(
                    'tbl_team_has_policy_marine',
                    'tbl_team_has_policy_marine.subPolicyId',
                    '=',
                    'tbl_subpolicy.upc'
                )
                ->join(
                    'tbl_order_status',
                    'tbl_order_status.order_status_id',
                    '=',
                    'tbl_order.order_statusID'
                )
               
                ->WHERE('order_id', '=', $x)
                ->WHERE('tbl_team_has_policy_marine.subPolicyId', $request->subPolicyID)
                ->WHERE('tbl_team_has_policy_marine.teamID', session('teamId'))
                ->get();
                //dd($orderData);

            // $premium = floatval($request->premium_rate/100 * $request->sumAssured);
            // //$premium = number_format($premiumSum, 0);
            
            if (session('marineType')=="Known") {
                $premium = floatval(
                    ($orderData['0']->premium_percentage / 100) * $request->sumAssured
                );
            }else{
                $premium = floatval(
                    ($request->premium_rate / 100) * $request->sumAssured
                );
            }
            $policyID = $orderData['0']->policyID;

            return view('body.confirmCheckout', compact('orderData', 'premium', 'policyID', 'getWallet'));
        } else {
            return redirect()->action([
                PolicyController::class,
                'checkoutPage',
            ]);
        }

        //return back()->with('PolicyIntoDBSuccess', 'Order Submitted Successfully');
    }

    public function addPersonalPolicyIntoDBPage()
    {

        $x = session()->get('orderID');

        if (session('user_id')) {
            $updatequery = DB::table('tbl_order')
            ->where('order_id', $x)
            ->update(['customerID' => session('user_id')]);
        //var_dump($updatequery); exit();
        $orderData = DB::table('tbl_order')
            ->join(
                'tbl_customer',
                'tbl_order.customerID',
                '=',
                'tbl_customer.customer_id'
            )
            ->join(
                'tbl_subpolicy',
                'tbl_subpolicy.upc',
                '=',
                'tbl_order.subPolicyID'
            )
            ->join(
                'tbl_policy',
                'tbl_policy.policy_id',
                '=',
                'tbl_subpolicy.policyID'
            )
            ->join(
                'tbl_order_status',
                'tbl_order_status.order_status_id',
                '=',
                'tbl_order.order_statusID'
            )
            ->WHERE('order_id', '=', $x)
            ->get();
             //dd($orderData); exit();
            return view('body.confirmCheckout', compact('orderData'));
        } else {
            return redirect()->action([
                PolicyController::class,
                'checkoutPage',
            ]);
        }

        //return back()->with('PolicyIntoDBSuccess', 'Order Submitted Successfully');
    }
    
    private function getVehicleMakeName($stuff)
    {
        $get = DB::table('tbl_niip_vehicle_make')
            ->WHERE('code', '=', $stuff)
        ->first();

        if ($get) {
            return $get->make;
        }else{
            return NULL;
        }

    }

    private function getVehicleModelName($stuff)
    {
        $get = DB::table('tbl_niip_vehicle_model')
            ->WHERE('code', '=', $stuff)
        ->first();

        if ($get) {
            return $get->model;
        }else{
            return NULL;
        }

    }

    private function getVehicleColourName($stuff)
    {
        $get = DB::table('tbl_niip_vehicle_colour')
            ->WHERE('code', '=', $stuff)
        ->first();

        if ($get) {
            return $get->colour;
        }else{
            return NULL;
        }

    }

    private function getVehicleCapacityName($stuff)
    {
        $get = DB::table('tbl_niip_engine_capacity')
            ->WHERE('code', '=', $stuff)
        ->first();

        if ($get) {
            return $get->capacity;
        }else{
            return NULL;
        }

    }

    private function getStateName($stuff)
    {
        $get = DB::table('tbl_niip_state')
            ->WHERE('code', '=', $stuff)
        ->first();

        if ($get) {
            return $get->state;
        }else{
            return NULL;
        }

    }

    private function getLgaName($stuff)
    {
        $get = DB::table('tbl_niip_lga')
            ->WHERE('code', '=', $stuff)
        ->first();
        if ($get) {
            return $get->lga;
        }else{
            return NULL;
        }

    }

    public function addPersonalPolicyIntoDB(Request $request)
    {
        //dd($request);
         if ($request->subPolicyID=='010403') {
                $vmodel = 'Bike: '.$request->vehicle_model;
            }elseif ($request->subPolicyID=='010402') {
                $vmodel = 'Tricycle: '.$request->vehicle_model;
            }else {
                $vmodel = $request->vehicle_model;
            }
            
            if ($request->current_url=='https://retaildemo.veritaskapital.com/?rel=12FB345') {
                $adSource = 'Facebook Ad';
            }elseif($request->current_url=='https://retaildemo.veritaskapital.com/?rel=32IG154') {
                $adSource = 'Instagram Ad';
            }else{
                $adSource = 'NIL';
            }
            
        $vehiclemake = $this->getVehicleMakeName($request->vehicle_make);
        $vehiclemodel = $this->getVehicleModelName($request->vehicle_model);
        $vehiclecolour = $this->getVehicleColourName($request->colour);
        $state = $this->getStateName($request->state);
        $lga = $this->getLgaName($request->lga);

        switch ($request->subPolicyID) {
            case '010102':
                $purposeID = 3;
                break;
            case '010202':
                $purposeID = 8;
                break;
            case '010403':
                $purposeID = 4;
                break;
            case '010402':
                $purposeID = 7;
                break;
            case '010205':
                $purposeID = 5;
                break;
            case '010203':
                $purposeID = 9;
                break;
            default:
                $purposeID = 3;
                break;
        }

        // $x = DB::table('tbl_order')->insertGetId([
        //     'customerID' => $request->customerID,
        //     'subPolicyID' => $request->subPolicyID,
        //     'firstName' => $request->firstName,
        //     'lastName' => $request->lastName,
        //     'email' => $request->email,
        //     'dob' => $request->dob,
        //     'phone' => $request->phone,
        //     'vehicle_make' => $request->vehicle_make,
        //     'vehicle_model' => $vmodel,
        //     'form_of_id' => $request->form_of_id,
        //     'id_number' => $request->id_number,
        //     'refer_code' => $request->refer_code,
        //     'car_reg_number' => $request->car_reg_number,
        //     'chasis_number' => $request->chasis_number,
        //     'colour' => $request->colour,
        //     'address' => $request->address,
        //     'occupation' => $request->occupation,
        //     'order_statusID' => 9,
        //     'sale_channel' => 'retail site',
        //     'state' => $request->state,
        //     'remitaID' => $request->remitaID,
        //     'next_of_kin_name' => $request->next_of_kin_name,
        //     'next_of_kin_phone' => $request->next_of_kin_phone,
        //     'ad_source' => $adSource,
        // ]);
        
        $x = DB::table('tbl_order')->insertGetId([
            'customerID' => $request->customerID,
            'subPolicyID' => $request->subPolicyID,
            'firstName' => $request->firstName,
            'lastName' => $request->lastName,
            'email' => $request->email,
            'dob' => $request->dob,
            'phone' => $request->phone,
            'bvn' => $request->bvn,
            'vehicle_make' => $vehiclemake,
            'vehicle_model' => $vehiclemodel,
            'form_of_id' => $request->form_of_id,
            'id_number' => $request->id_number,
            'refer_code' => $request->refer_code,
            'car_reg_number' => $request->car_reg_number,
            'chasis_number' => $request->chasis_number,
            'colour' => $vehiclecolour,
            'address' => $request->address,
            'occupation' => $request->occupation,
            'order_statusID' => 1,
            'sale_channel' => 'retail site',
            'state' => $state,
            'remitaID' => $request->remitaID,
            'next_of_kin_name' => $request->next_of_kin_name,
            'next_of_kin_phone' => $request->next_of_kin_phone,
            'ad_source' => $adSource,
        ]);

        $y = DB::table('tbl_niip_upload')->insert([
            'orderID' => $x,
            'first_name' => $request->firstName,
            'last_name' => $request->lastName,
            'phone_number' => $request->phone,
            'email_address' => $request->email,
            'nin' => $request->id_number,
            'engine_capacity' => $request->engine_capacity,
            'vehicle_make' => $request->vehicle_make,
            'vehicle_model' => $request->vehicle_model,
            'engine_no' => $request->engine_no,
            'reg_no' => $request->car_reg_number,
            'chasis_no' => $request->chasis_number,
            'state' => $request->state,
            'lga' => $request->lga,
            'vehicle_colour' => $request->colour,
            'address' => $request->address,
            'purpose' => $purposeID,

        ]);
        
        
        $request->session()->put('orderID', $x);
        session()->pull('current_url');
        
        $getWallet = DB::table('tbl_wallet')
            ->WHERE('customerID', '=', session('user_id'))
        ->first();

        if (session('user_id')) {
            //if user already logged in, update tbl_order and set customerID, also fetch records to be displayed in confirm checkout.
            $updatequery = DB::table('tbl_order')
                ->where('order_id', $x)
                ->update(['customerID' => session('user_id')]);
            //var_dump($updatequery); exit();
            $orderData = DB::table('tbl_order')
                ->join(
                    'tbl_customer',
                    'tbl_order.customerID',
                    '=',
                    'tbl_customer.customer_id'
                )
                ->join(
                    'tbl_subpolicy',
                    'tbl_subpolicy.upc',
                    '=',
                    'tbl_order.subPolicyID'
                )
                ->join(
                    'tbl_policy',
                    'tbl_policy.policy_id',
                    '=',
                    'tbl_subpolicy.policyID'
                )
                ->join(
                    'tbl_order_status',
                    'tbl_order_status.order_status_id',
                    '=',
                    'tbl_order.order_statusID'
                )
                ->WHERE('order_id', '=', $x)
                ->get();
            //  dd($orderData); exit();
                $policyID = $orderData[0]->policyID;

            return view('body.confirmCheckout', compact('orderData', 'policyID', 'getWallet'));
        } else {
            return redirect()->action([
                PolicyController::class,
                'checkoutPage',
            ]);
        }

        //return back()->with('PolicyIntoDBSuccess', 'Order Submitted Successfully');
    }

    public function accountVerify(request $request)
    {
        $orderData = "";
        if (session('planID')) {
            $orderData = DB::table('tbl_order')
                ->join(
                    'tbl_subpolicy',
                    'tbl_subpolicy.upc',
                    '=',
                    'tbl_order.subPolicyID'
                )
                ->join(
                    'tbl_policy',
                    'tbl_policy.policy_id',
                    '=',
                    'tbl_subpolicy.policyID'
                )
                ->join(
                    'tbl_order_status',
                    'tbl_order_status.order_status_id',
                    '=',
                    'tbl_order.order_statusID'
                )
                ->join(
                    'tbl_plans',
                    'tbl_plans.id',
                    '=',
                    'tbl_order.planID'
                )
                ->WHERE('order_id', '=', session('orderID'))
                ->get()
                ->toArray();
            $orderData[0]->subPolicy_price = $orderData[0]->amount;
            
            $dateOfBirth = $orderData[0]->dob;
            $amount = $orderData[0]->amount;
            $premium = $this->calculatePremium($dateOfBirth, $amount);
            
            $orderData[0]->subPolicy_price = $premium;
        }else{
            $orderData = DB::table('tbl_order')
                ->join(
                    'tbl_subpolicy',
                    'tbl_subpolicy.upc',
                    '=',
                    'tbl_order.subPolicyID'
                )
                ->join(
                    'tbl_policy',
                    'tbl_policy.policy_id',
                    '=',
                    'tbl_subpolicy.policyID'
                )
                ->join(
                    'tbl_order_status',
                    'tbl_order_status.order_status_id',
                    '=',
                    'tbl_order.order_statusID'
                )
                ->WHERE('order_id', '=', session('orderID'))
                ->get()
                ->toArray();
            //dd($orderData);
        }
        
        if ($request->account == 'register') {
            return redirect()->action([
                RouterController::class,
                'account_register',
            ]);
        } elseif ($request->account == 'guest') {
            
            //dd($orderData);
            if ($orderData) {
                $policyID = $orderData[0]->policyID;
                return view('body.confirmCheckout', compact('orderData', 'policyID'));
            }
        } else {
            return back()->with('error', 'Do Nothing');
        }
        
    }

    public function checkoutLogin(request $request)
    {
        $request->validate([
            'email' => 'required|email',
            'password' => 'required|min:5|max:12',
        ]);
        $verifyEmail = DB::table('tbl_customer')
            ->WHERE('email', '=', $request->email)
            ->get();
        //dd($verifyEmail);

        //var_dump($x); exit();
        if (!$verifyEmail) {
            return back()->with('error', 'Invalid login credentials provided');
        } else {
            //check password
            if (Hash::check($request->password, $verifyEmail['0']->password)) {
                $request->session()->put('user_id', $verifyEmail['0']->customer_id);
                $request->session()->put('vkaID', $verifyEmail['0']->vka_id);
                $request->session()->put('userLevel', $verifyEmail['0']->user_level);
                
                //update order table to take present user that just logged in since he placed order as a guest
                $updatequery = DB::table('tbl_order')
                    ->where('order_id', session('orderID'))
                    ->update(['customerID' => $verifyEmail['0']->customer_id]);
                    
                $orderData = DB::table('tbl_order')
                    ->join(
                        'tbl_customer',
                        'tbl_order.customerID',
                        '=',
                        'tbl_customer.customer_id'
                    )
                    ->join(
                        'tbl_subpolicy',
                        'tbl_subpolicy.upc',
                        '=',
                        'tbl_order.subPolicyID'
                    )
                    ->join(
                        'tbl_policy',
                        'tbl_policy.policy_id',
                        '=',
                        'tbl_subpolicy.policyID'
                    )
                    ->join(
                        'tbl_order_status',
                        'tbl_order_status.order_status_id',
                        '=',
                        'tbl_order.order_statusID'
                    )
                    ->WHERE('order_id', '=', session('orderID'))
                    ->get()
                    ->toArray();
                
                //if policy is travel insurance
                if ($orderData['0']->policyID == 6 && strlen($orderData[0]->planID) > 0) {
                    
                    $orderData = DB::table('tbl_order')
                        ->join(
                            'tbl_customer',
                            'tbl_order.customerID',
                            '=',
                            'tbl_customer.customer_id'
                        )
                        ->join(
                            'tbl_subpolicy',
                            'tbl_subpolicy.upc',
                            '=',
                            'tbl_order.subPolicyID'
                        )
                        ->join(
                            'tbl_policy',
                            'tbl_policy.policy_id',
                            '=',
                            'tbl_subpolicy.policyID'
                        )
                        ->join(
                            'tbl_plans',
                            'tbl_plans.id',
                            '=',
                            'tbl_order.planID'
                        )
                        ->join(
                            'tbl_order_status',
                            'tbl_order_status.order_status_id',
                            '=',
                            'tbl_order.order_statusID'
                        )
                        ->WHERE('order_id', '=', session('orderID'))
                        ->get()
                        ->toArray();
                        
                    //$dest_country = $this->getDestinationCountry($orderData[0]->destination_country);
                    $dateOfBirth = $orderData[0]->dob;
                    $amount = $orderData[0]->amount;
                    $premium = $this->calculatePremium($dateOfBirth, $amount);
                    
                    //$dest_country = $this->getDestinationCountry($orderData[0]->destination_country);
                    $dest_country = trim($orderData[0]->destination_country);
                    $orderData[0]->subPolicy_price = $premium;
                    $orderData[0]->dest_country = $dest_country;
                }
                
                //dd($orderData);

                return view('body.confirmCheckout', compact('orderData'));
            } else {
                return back()->with('error', 'Invalid Password');
            }
        }
    }

    public function submitLoginForm(Request $request)
    {
        //return $request->input();
        $request->validate([
            'email' => 'required|email',
            'password' => 'required|min:5|max:12',
        ]);
        $x = DB::table('tbl_customer')
            ->WHERE('email', '=', $request->email)
            ->get();
        //dd($x);

        //var_dump($x); exit();
        if ( count($x) < 1) {
            return back()->with('error', 'Email Not Valid');
        } else {
            //check password
            if (Hash::check($request->password, $x['0']->password)) {
                
                $y = DB::table('tbl_team')
                ->WHERE('team_id', '=', $x['0']->teamID)
                ->first();
                
                if(!is_null($y)){
                    $request->session()->put('isAutoPay', $y->is_auto_payment);
                }
                $checkIfMarineUser = DB::table('tbl_team_has_policy_marine')->WHERE('teamID', '=', $x['0']->teamID)->first();

                //dd($checkIfMarineUser);
                $insertLog = DB::table('tbl_user_audit_log')->insert([
                    'userID' => $x['0']->customer_id,
                    'action' => 'login',
                    'platform' => 'retail',
                ]);

                $request->session()->put('marineUser', $checkIfMarineUser);
                
                $request->session()->put('user_id', $x['0']->customer_id);
                $request->session()->put('vkaID', $x['0']->vka_id);
                $request->session()->put('userLevel', $x['0']->user_level);
                $request->session()->put('teamId', $x['0']->teamID);
                $request->session()->put('agentPin', $x['0']->agent_unique_pin);
                $request->session()->put('marineType', $x['0']->marine_team_type);
                
                return redirect()->action([
                    PolicyController::class,
                    'customerDashboard',
                ]);
            } else {
                return back()->with('error', 'Invalid Password');
            }
        }
    }

    public function submitRegistrationForm(Request $request)
    {
        $request->validate([
            'email' => 'required|email|unique:tbl_customer',
            'password' => [
                'required',
                'min:8',  // At least 8 characters
                'regex:/[A-Z]/',  // At least one upper case letter
                'regex:/[a-z]/',  // At least one lower case letter
                'regex:/[!@#$%^&*(),.?":{}|<>]/',  // At least one special character
            ],
        ]);
        //return $request->input();

            $getCrmDetails = DB::connection('CRM_DB')
               ->table('users')
               ->WHERE('email', '=', $request->email)
               ->get();
            //dd($getCrmDetails);
            if(strlen($request->vka_id) > 5){
                if($getCrmDetails[0]->email == $request->email && $getCrmDetails[0]->clo_id == $request->vka_id){
                    $insertIntoDB = DB::table('tbl_customer')->insert([
                        'firstName' => $request->firstname,
                        'lastName' => $request->lastname,
                        'email' => $request->email,
                        'telephone' => $request->phone,
                        'password' => Hash::make($request->password),
                        'newsletter' => $request->newsletter,
                        'vka_id' => $request->vka_id,
                        'date_added' => now(),
                    ]);
                } else{
                    return back()->with('RegistrationError', 'Email and VKA ID Does not match!' );
                }
            }else{
                $insertIntoDB = DB::table('tbl_customer')->insert([
                    'firstName' => $request->firstname,
                    'lastName' => $request->lastname,
                    'email' => $request->email,
                    'telephone' => $request->phone,
                    'password' => Hash::make($request->password),
                    'newsletter' => $request->newsletter,
                    //'vka_id' => $request->vka_id,
                    'date_added' => now(),
                ]);
            }

        $x = DB::table('tbl_customer')
            ->WHERE('email', '=', $request->email)
            ->get();

        if ($insertIntoDB && $x['0']->vka_id !== NULL) {
            $request->session()->put('user_id', $x['0']->customer_id);
            $request->session()->put('vkaID', $x['0']->vka_id);
            return redirect()->action([PolicyController::class, 'customerDashboard',]);
            //return back()->with('RegistrationSuccess', 'Registration Successfully Done' );
        }else{

            $request->session()->put('user_id', $x['0']->customer_id);
            return redirect()->action([PolicyController::class, 'customerDashboard',]);

        }
    }

    public function account_login()
    {
        return view('body.login');
    }

    public function account_logout()
    {
        if (session()->has('user_id')) {

            $inserLog = DB::table('tbl_user_audit_log')->insert([
                'userID' => session('user_id'),
                'action' => 'logout',
                'platform' => 'retail',
            ]);

            if (session()->pull('user_id')) {
                session()->flush();
                return redirect()->action([PolicyController::class,'account_login', ]);
            }
        }
    }

    public function customerDashboard()
    {
        $customerData = DB::table('tbl_customer')
            ->WHERE('customer_id', '=', session('user_id'))
        ->get();

        $countUnremitted = DB::table('tbl_order')
            ->join('tbl_customer','tbl_order.customerID','=','tbl_customer.customer_id')
            ->join('tbl_transaction', 'tbl_transaction.orderID', '=', 'tbl_order.order_id')
            ->WHERE('teamID', '=', session('teamId'))
            ->WHERE('payment_statusID', '<>', 5)
        ->count();
        //dd($customerData); exit();

        return view('body.customer.dashboard', compact('customerData', 'countUnremitted'));
    }

    public function commissionPayment()
    {
        $countUnremitted = DB::table('tbl_order')
            ->join('tbl_customer','tbl_order.customerID','=','tbl_customer.customer_id')
            ->join('tbl_transaction', 'tbl_transaction.orderID', '=', 'tbl_order.order_id')
            ->WHERE('teamID', '=', session('teamId'))
            ->WHERE('payment_statusID', '<>', 5)
        ->count();
        $customerData = DB::table('tbl_customer')
            ->WHERE('customer_id', '=', session('user_id'))
            ->get();

        $commissionData = DB::table('tbl_customer')
            ->WHERE('vka_id', '<>', '')
            ->WHERE('comission_paid', '<>', '')
            ->get();
        //dd($customerData); exit();

        return view('body.customer.commissions', compact('commissionData', 'customerData', 'countUnremitted'));
    }

    public function UpdateCommission(request $request)
    {
        $updatePayment = DB::table('tbl_customer')
            ->where('customer_id', $request->id)
            ->update(['comission_paid' => '']);

        if ($updatePayment) {
                return 'success';
        }else return 'failed';
    }

    public function newsletter()
    {
        $customerData = DB::table('tbl_customer')
            ->WHERE('customer_id', '=', session('user_id'))
            ->get();
        $countUnremitted = DB::table('tbl_order')
            ->join('tbl_customer','tbl_order.customerID','=','tbl_customer.customer_id')
            ->join('tbl_transaction', 'tbl_transaction.orderID', '=', 'tbl_order.order_id')
            ->WHERE('teamID', '=', session('teamId'))
            ->WHERE('payment_statusID', '<>', 5)
        ->count();
        return view('body.customer.newsletter', compact('customerData', 'countUnremitted'));
    }

    public function newsletterUpdate(request $request)
    {
        //return $request->input();
        $updatequery = DB::table('tbl_customer')
            ->where('customer_id', $request->userID)
            ->update(['newsletter' => $request->newsletter]);
        if ($updatequery) {
            return back()->with(
                'success',
                'Update on Newsletter Subscription Successful!'
            );
        }
    }

    public function checkoutPage()
    {
        return view('body.checkout');
    }

    public function editaccount()
    {
        $customerData = DB::table('tbl_customer')
            ->WHERE('customer_id', '=', session('user_id'))
        ->get();

        $countUnremitted = DB::table('tbl_order')
            ->join('tbl_customer','tbl_order.customerID','=','tbl_customer.customer_id')
            ->join('tbl_transaction', 'tbl_transaction.orderID', '=', 'tbl_order.order_id')
            ->WHERE('teamID', '=', session('teamId'))
            ->WHERE('payment_statusID', '<>', 5)
        ->count();

        return view('body.customer.editaccount', compact('customerData', 'countUnremitted'));
    }

    public function orders()
    {
        $customerData = DB::table('tbl_customer')
            ->WHERE('customer_id', '=', session('user_id'))
        ->get();

        $countUnremitted = DB::table('tbl_order')
            ->join('tbl_customer','tbl_order.customerID','=','tbl_customer.customer_id')
            ->join('tbl_transaction', 'tbl_transaction.orderID', '=', 'tbl_order.order_id')
            ->WHERE('teamID', '=', session('teamId'))
            ->WHERE('payment_statusID', '<>', 5)
        ->count();

        $orderData = DB::table('tbl_order')
            ->join(
                'tbl_customer',
                'tbl_order.customerID',
                '=',
                'tbl_customer.customer_id'
            )
            ->join(
                'tbl_subpolicy',
                'tbl_subpolicy.upc',
                '=',
                'tbl_order.subPolicyID'
            )
            ->join(
                'tbl_policy',
                'tbl_policy.policy_id',
                '=',
                'tbl_subpolicy.policyID'
            )
            ->join(
                'tbl_order_status',
                'tbl_order_status.order_status_id',
                '=',
                'tbl_order.order_statusID'
            )
            ->WHERE('customerID', '=', session('user_id'))
        ->get();
        // dd($orderData); exit();

        return view(
            'body.customer.orders',
            compact('customerData', 'orderData', 'countUnremitted')
        );
    }

    public function order_detail($id)
    {
        $countUnremitted = DB::table('tbl_order')
            ->join('tbl_customer','tbl_order.customerID','=','tbl_customer.customer_id')
            ->join('tbl_transaction', 'tbl_transaction.orderID', '=', 'tbl_order.order_id')
            ->WHERE('teamID', '=', session('teamId'))
            ->WHERE('payment_statusID', '<>', 5)
        ->count();

        $orderData = DB::table('tbl_order')
            ->join(
                'tbl_customer',
                'tbl_order.customerID',
                '=',
                'tbl_customer.customer_id'
            )
            ->join(
                'tbl_subpolicy',
                'tbl_subpolicy.upc',
                '=',
                'tbl_order.subPolicyID'
            )
            ->join(
                'tbl_policy',
                'tbl_policy.policy_id',
                '=',
                'tbl_subpolicy.policyID'
            )
            ->join(
                'tbl_order_status',
                'tbl_order_status.order_status_id',
                '=',
                'tbl_order.order_statusID'
            )
            ->WHERE('order_id', '=', $id)
            ->get();

        //dd($orderData);

        return view('body.customer.order_detail', compact('orderData', 'countUnremitted'));
    }

    public function transactions()
    {
        $countUnremitted = DB::table('tbl_order')
            ->join('tbl_customer','tbl_order.customerID','=','tbl_customer.customer_id')
            ->join('tbl_transaction', 'tbl_transaction.orderID', '=', 'tbl_order.order_id')
            ->WHERE('teamID', '=', session('teamId'))
            ->WHERE('payment_statusID', '<>', 5)
        ->count();

        $customerData = DB::table('tbl_customer')
            ->WHERE('customer_id', '=', session('user_id'))
            ->get();

        $TransactionData = DB::table('tbl_transaction')
            ->join(
                'tbl_order',
                'tbl_order.order_id',
                '=',
                'tbl_transaction.orderID'
            )
            ->join(
                'tbl_subpolicy',
                'tbl_subpolicy.upc',
                '=',
                'tbl_order.subPolicyID'
            )
            ->join(
                'tbl_policy',
                'tbl_policy.policy_id',
                '=',
                'tbl_subpolicy.policyID'
            )
            ->join(
                'tbl_order_status',
                'tbl_order_status.order_status_id',
                '=',
                'tbl_transaction.payment_statusID'
            )
            ->WHERE('tbl_order.customerID', '=', session('user_id'))
            ->orderBy('transaction_date', 'DESC')
            ->get();

        return view(
            'body.customer.transactions',
            compact('customerData', 'TransactionData', 'countUnremitted')
        );
    }
    
    public function validateDate($date, $format = 'Y-m-d')
    {
        $d = DateTime::createFromFormat($format, $date);
        // The Y ( 4 digits year ) returns TRUE for any integer with any number of digits so changing the comparison from == to === fixes the issue.
        return $d && $d->format($format) === $date;
    }
    
    public function transactionsFilter(Request $request)
    {
        $TransactionData = [];
        $dateFrom = $this->validateDate($request->dateFrom);
        $dateTo = $this->validateDate($request->dateTo);
        
        $customerData = DB::table('tbl_customer')
            ->WHERE('customer_id', '=', session('user_id'))
            ->get();
        
        if(!$dateFrom && !$dateTo){
            return view(
                'body.customer.transactions',
                compact('customerData', 'TransactionData')
            );
        }
        
        if($dateFrom && $dateTo){
            
            $from = date($request->dateFrom);
            $to = date($request->dateTo);
            
            $TransactionData = DB::table('tbl_transaction')
            ->join(
                'tbl_order',
                'tbl_order.order_id',
                '=',
                'tbl_transaction.orderID'
            )
            ->join(
                'tbl_subpolicy',
                'tbl_subpolicy.upc',
                '=',
                'tbl_order.subPolicyID'
            )
            ->join(
                'tbl_policy',
                'tbl_policy.policy_id',
                '=',
                'tbl_subpolicy.policyID'
            )
            ->join(
                'tbl_order_status',
                'tbl_order_status.order_status_id',
                '=',
                'tbl_transaction.payment_statusID'
            )
            ->WHERE('tbl_order.customerID', '=', session('user_id'))
            ->whereBetween("tbl_transaction.transaction_date", [$from, $to])
            ->get();
            
        }
        
        if($dateFrom && !$dateTo){
            $from = date($request->dateFrom);
            $TransactionData = DB::table('tbl_transaction')
            ->join(
                'tbl_order',
                'tbl_order.order_id',
                '=',
                'tbl_transaction.orderID'
            )
            ->join(
                'tbl_subpolicy',
                'tbl_subpolicy.upc',
                '=',
                'tbl_order.subPolicyID'
            )
            ->join(
                'tbl_policy',
                'tbl_policy.policy_id',
                '=',
                'tbl_subpolicy.policyID'
            )
            ->join(
                'tbl_order_status',
                'tbl_order_status.order_status_id',
                '=',
                'tbl_transaction.payment_statusID'
            )
            ->WHERE('tbl_order.customerID', '=', session('user_id'))
            ->where("tbl_transaction.transaction_date", "=", $from)
            ->get();
        }

        return view(
            'body.customer.transactions',
            compact('customerData', 'TransactionData')
        );
    }

    public function personaldetailsUpload(request $request)
    {
        //updates user profile data

        //return $request->input();
        $updateCustomer = DB::table('tbl_customer')
            ->WHERE('customer_id', '=', $request->userID)
            ->update([
                'firstName' => $request->firstname,
                'lastName' => $request->lastname,
                'email' => $request->email,
                'telephone' => $request->phone,
            ]);
        if ($updateCustomer) {
            return back()->with(
                'success',
                'Your profile has been updated Successfully!'
            );
        }
    }

    public function changePassword()
    {
        $countUnremitted = DB::table('tbl_order')
            ->join('tbl_customer','tbl_order.customerID','=','tbl_customer.customer_id')
            ->join('tbl_transaction', 'tbl_transaction.orderID', '=', 'tbl_order.order_id')
            ->WHERE('teamID', '=', session('teamId'))
            ->WHERE('payment_statusID', '<>', 5)
        ->count();

        $customerData = DB::table('tbl_customer')
            ->WHERE('customer_id', '=', session('user_id'))
            ->get();
        return view('body.customer.changePassword', compact('customerData', 'countUnremitted'));
    }

    public function updateChangePassword(request $request)
    {
        $request->validate([
            'oldpassword' => 'required',
            'password' => [
                'required',
                'min:8',  // At least 8 characters
                'regex:/[A-Z]/',  // At least one upper case letter
                'regex:/[a-z]/',  // At least one lower case letter
                'regex:/[!@#$%^&*(),.?":{}|<>]/',  // At least one special character
            ],
            'confirmPass' => 'required|same:password',
        ]);

        $getOldPword = DB::table('tbl_customer')
            ->where('customer_id', $request->userID)
        ->first();

        if (! Hash::check($request->oldpassword, $getOldPword->password)){
            return back()->with('error', 'Old Password Incorrect');
        }

        if ($request->password == $request->confirmPass) {
            $updatequery = DB::table('tbl_customer')
                ->where('customer_id', $request->userID)
                ->update(['password' => Hash::make($request->password)]);
            if ($updatequery) {
                return back()->with(
                    'success',
                    'Password has been updated successfully'
                );
            }
        } else {
            return back()->with('error', 'Passwords Do Not Match');
        }
    }

    private function createSplitPayment($data)
    {

        $url = "https://api.paystack.co/transaction/initialize";

        //"transaction_charge" => $data['user_comm'],

        $fields = [
            'email' => $data['email'],
            'amount' => $data['amount'],
            'subaccount' => getEnv('PAYSTACK_SUB_ACCOUNT'),
            "callback_url" => url('payment/callback'),
            "metadata" => $data['metadata']
        ];

        $fields_string = http_build_query($fields);

        //open connection
        $ch = curl_init();

        //set the url, number of POST vars, POST data
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $fields_string);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            "Authorization: Bearer ".getEnv('PAYSTACK_SECRET_KEY'),
            "Cache-Control: no-cache",
        ));

        //So that curl_exec returns the contents of the cURL; rather than echoing it
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        //execute post
        $curl_result = curl_exec($ch);
        $result = json_decode($curl_result);

        if($result->status){
            $auth_url = $result->data->authorization_url;
            return $auth_url;
        }else{
            Log::error(['status' => 'false', 'message' => $result->message]);
            return null;
        }
    }

    public function redirectToGateway()
    {
        //dd($_POST); 
        if (session('planID')) {
            //get actual policy price from DB for travel and other policies 
            // $getActualPrice = DB::table('tbl_subpolicy')
            // ->where('subPolicy_id', $_POST['subPolicyId'])
            // ->first();
            
            $getActualPrice = DB::table('tbl_order')
                ->join(
                    'tbl_subpolicy',
                    'tbl_subpolicy.upc',
                    '=',
                    'tbl_order.subPolicyID'
                )
                ->join(
                    'tbl_policy',
                    'tbl_policy.policy_id',
                    '=',
                    'tbl_subpolicy.policyID'
                )
                ->join(
                    'tbl_plans',
                    'tbl_plans.id',
                    '=',
                    'tbl_order.planID'
                )
                ->join(
                    'tbl_order_status',
                    'tbl_order_status.order_status_id',
                    '=',
                    'tbl_order.order_statusID'
                )
                ->WHERE('order_id', '=', session('orderID'))
                ->get()
                ->toArray();
                
                //dd(session('orderID'));
                
            $dateOfBirth = $getActualPrice[0]->dob;
            $amount = $getActualPrice[0]->amount;
            $premium = $this->calculatePremium($dateOfBirth, $amount);
            $getActualPrice[0]->subPolicy_price = $premium;
        
        }else{        
            // $getActualPrice = DB::table('tbl_plans')
            // //->join('tbl_plans','tbl_plans.id','=','tbl_order.planID')
            //  ->where('subPolicyID', $_POST['subPolicyId'])
            //  ->where('id', session('planID'))
            //  ->first();
            //  $getActualPrice->subPolicy_price = $getActualPrice->amount;
            
            $getActualPrice = DB::table('tbl_order')
                ->join(
                    'tbl_subpolicy',
                    'tbl_subpolicy.upc',
                    '=',
                    'tbl_order.subPolicyID'
                )
                ->join(
                    'tbl_policy',
                    'tbl_policy.policy_id',
                    '=',
                    'tbl_subpolicy.policyID'
                )
                ->join(
                    'tbl_order_status',
                    'tbl_order_status.order_status_id',
                    '=',
                    'tbl_order.order_statusID'
                )
                ->WHERE('order_id', '=', session('orderID'))
                ->get()
                ->toArray();
                
            $premium = $getActualPrice[0]->subPolicy_price;
                
            // $getActualPrice = DB::table('tbl_subpolicy')
            // ->where('subPolicy_id', $_POST['subPolicyId'])
            // ->first();
                
            //dd($getActualPrice2);
        }
        
        //dd($getActualPrice);
        if( ($getActualPrice[0]->policyID ?? $getActualPrice[0]->policyID) != 7 && $premium != ($_POST['amount']/100) ){
            dd('Ooops!!! Unauthorized Request, Contact Administrator.');
        }else{
            try {
    
                if (session()->has('vkaID') && session('userLevel')<>10) {
                    $payment_url = $this->createSplitPayment($_POST);
                    //dd($payment_url);
                    if($payment_url == null){
                        return redirect()->route('addPersonalPolicyIntoDBPage')->with([
                            'msg' => 'Paystack Error: Invalid Token Provided',
                            'type' => 'error',
                        ]);
                    }
                    return Paystack::getAuthorizationUrl()->redirectNow($payment_url);
                } else {
                   return Paystack::getAuthorizationUrl()->redirectNow();
                }
    
            } catch (\Exception $e) {
                //dd($e);
                return redirect()->route('addPersonalPolicyIntoDBPage')->with([
                    'msg' => 'The paystack token has expired. Please refresh the page and try again. ',
                    'type' => 'error',
                ]);
            }
        }
    }

    /**
     * Obtain Paystack payment information
     * return void
     */
    public function handleGatewayCallback()
    {
        // try {
        //     $paymentDetails = Paystack::getPaymentData();
        // } catch (RequestException $e) {
        //     return back()->with('error', 'Passwords Do Not Match');
        // }
        // dd($paymentDetails);

        $paymentDetails = Paystack::getPaymentData();
        
        if($paymentDetails['data']['metadata']['policyID'] ===7){
            $amount = $paymentDetails['data']['amount']/100;
        }else{
            $amount = $paymentDetails['data']['metadata']['premium'];
        }
        //


        // if (session()->has('vkaID') && session('userLevel')<>10) {

        //     $insertIntoDB = DB::table('tbl_transaction')->insertGetId([
        //         'orderID' => $paymentDetails['data']['metadata']['orderID'],
        //         'transaction_ref' => $paymentDetails['data']['reference'],
        //         'payment_method' => 'PAYSTACK',
        //         'payment_statusID' => 5,
        //         'amount' => $paymentDetails['data']['metadata']['premium'],
        //         'transaction_date' => now(),
        //         'is_split' => 'Y',
        //     ]);

        //     $insertIntoDB2 = DB::table('tbl_split_transaction')->insertGetId([
        //         'transaction_ref' => $paymentDetails['data']['reference'],
        //         'transactionID' => $insertIntoDB,
        //         'amount' => $paymentDetails['data']['fees_split']['integration']
        //     ]);
        // }else{
        //     $insertIntoDB = DB::table('tbl_transaction')->insertGetId([
        //         'orderID' => $paymentDetails['data']['metadata']['orderID'],
        //         'transaction_ref' => $paymentDetails['data']['reference'],
        //         'payment_method' => 'PAYSTACK',
        //         'payment_statusID' => 5,
        //         'amount' => $paymentDetails['data']['metadata']['premium'],
        //         'transaction_date' => now(),
        //     ]);
        // }
        
        // $amount_paid = $paymentDetails['data']['amount'];
        // $premium = $paymentDetails['data']['metadata']['premium'];
        
        // if($amount_paid != $premium){
        //     dd('Oops! Unauthorized Request. Contact Administrator');
        // }
        $now = now();
        $CheckRefExist = DB::table('tbl_transaction')
            ->where('transaction_ref', '=', $paymentDetails['data']['reference'])
            ->where('transaction_date','Like', '%' . $now)
            ->first();

        //if (!$CheckRefExist) {
            
            if (!session('planID')) {
                //get actual policy price from DB for other policies
                $getActualPrice = DB::table('tbl_subpolicy')
                ->where('subPolicy_id', $paymentDetails['data']['metadata']['subPolicyID'])
                ->first();
            
            }else{        
                //get actual policy price from DB for travel policies
                $getActualPrice = DB::table('tbl_plans')
                 ->where('subPolicyID', $paymentDetails['data']['metadata']['subPolicyID'])
                 ->where('id', session('planID'))
                 ->first();
                 $getActualPrice->subPolicy_price = $getActualPrice->amount;
            }
            
            // if($getActualPrice->subPolicy_price != $paymentDetails['data']['amount']/100){
            //     dd('Ooops!!! Unauthorized Request, Contact Administrator.');
            // }
            
            //dd($amount);

            if (session()->has('vkaID') && session('userLevel')<>10) {

                $insertIntoDB = DB::table('tbl_transaction')->insertGetId([
                    'orderID' => $paymentDetails['data']['metadata']['orderID'],
                    'transaction_ref' => $paymentDetails['data']['reference'],
                    'payment_method' => 'PAYSTACK',
                    'payment_statusID' => 5,
                    'amount' => $amount,
                    'transaction_date' => now(),
                    'is_split' => 'Y',
                ]);

                $insertIntoDB2 = DB::table('tbl_split_transaction')->insertGetId([
                    'transaction_ref' => $paymentDetails['data']['reference'],
                    'transactionID' => $insertIntoDB,
                    'amount' => $paymentDetails['data']['fees_split']['integration']
                ]);
            }else{
                $insertIntoDB = DB::table('tbl_transaction')->insertGetId([
                    'orderID' => $paymentDetails['data']['metadata']['orderID'],
                    'transaction_ref' => $paymentDetails['data']['reference'],
                    'payment_method' => 'PAYSTACK',
                    'payment_statusID' => 5,
                    'amount' => $amount,
                    'transaction_date' => now(),
                ]);
            }
            //dd($insertIntoDB);

        //}else{
            //do nothing
       // }



        $usr_comm = $paymentDetails['data']['metadata']['user_comm'];
        if(session('user_id')){
            //get the present user commisison
            $getUserComm = DB::table('tbl_customer')
                            ->where('customer_id', session('user_id'))
                            ->get();
            //dd($getUserComm);
            //calculate new user commission
            $newUserComm = $usr_comm + $getUserComm[0]->comission_paid;

            //dd($newUserComm);

            //update user table to carry new user commission
            $upateComm = DB::table('tbl_customer')
            ->where('customer_id', session('user_id'))
            ->update(['comission_paid' => $newUserComm]);

        }
        //$amount = $paymentDetails['data']['metadata']['premium'];
        $transRef = $paymentDetails['data']['reference'];
        $orderid = $paymentDetails['data']['metadata']['orderID']; //update order table to show transaction has been confirmed
        $updatequery = DB::table('tbl_order')
            ->where('order_id', $orderid)
            ->update(['order_statusID' => 5]);

        $today = date('Y-m-d H:i:s');
        //$today = date_format(date_create("2023-03-05"),"Y-m-d H:i:s");
        $eff_date = date_create($today);
        $duration = date_add(
            $eff_date,
            date_interval_create_from_date_string('364 days')
        );
        $end_date = date_format($duration, 'Y-m-d H:i:s');
        $dest_country = "";

        if ($insertIntoDB) {
            if (session('planID')) {
 
                $orderData = DB::table('tbl_order')
                ->join(
                    'tbl_transaction',
                    'tbl_transaction.orderID',
                    '=',
                    'tbl_order.order_id'
                )
                ->join(
                    'tbl_subpolicy',
                    'tbl_subpolicy.upc',
                    '=',
                    'tbl_order.subPolicyID'
                )
                ->join(
                    'tbl_policy',
                    'tbl_policy.policy_id',
                    '=',
                    'tbl_subpolicy.policyID'
                )
                 ->join(
                    'tbl_plans',
                    'tbl_plans.id',
                    '=',
                    'tbl_order.planID'
                )
                //->join('tbl_order_status', 'tbl_order_status.order_status_id', '=', 'tbl_order.order_statusID')
                ->WHERE('order_id', '=', $orderid)
                ->orderBy('transaction_date', 'desc')
                ->limit(1)
                ->get()
                ->toArray();
                
                //dd($orderData);
                //$dest_country = $this->getDestinationCountry($orderData[0]->destination_country);
                $orderData[0]->subPolicy_price = $orderData[0]->amount;
                $orderData[0]->dest_country = trim($orderData[0]->destination_country);
                
            }else{
                $orderData = DB::table('tbl_order')
                    ->join(
                        'tbl_transaction',
                        'tbl_transaction.orderID',
                        '=',
                        'tbl_order.order_id'
                    )
                    ->join(
                        'tbl_subpolicy',
                        'tbl_subpolicy.upc',
                        '=',
                        'tbl_order.subPolicyID'
                    )
                    ->join(
                        'tbl_policy',
                        'tbl_policy.policy_id',
                        '=',
                        'tbl_subpolicy.policyID'
                    )
                    //->join('tbl_order_status', 'tbl_order_status.order_status_id', '=', 'tbl_order.order_statusID')
                    ->WHERE('order_id', '=', $orderid)
                    ->orderBy('transaction_date', 'desc')
                    ->limit(1)
                    ->get();
                    
                //if policy is travel insurance
                if ($orderData['0']->policyID == 6 && strlen($orderData[0]->planID) > 0) {
                    
                    $orderData = DB::table('tbl_order')
                    ->join(
                        'tbl_transaction',
                        'tbl_transaction.orderID',
                        '=',
                        'tbl_order.order_id'
                    )
                    ->join(
                        'tbl_subpolicy',
                        'tbl_subpolicy.upc',
                        '=',
                        'tbl_order.subPolicyID'
                    )
                    ->join(
                        'tbl_policy',
                        'tbl_policy.policy_id',
                        '=',
                        'tbl_subpolicy.policyID'
                    )
                     ->join(
                        'tbl_plans',
                        'tbl_plans.id',
                        '=',
                        'tbl_order.planID'
                    )
                    //->join('tbl_order_status', 'tbl_order_status.order_status_id', '=', 'tbl_order.order_statusID')
                    ->WHERE('order_id', '=', $orderid)
                    ->orderBy('transaction_date', 'desc')
                    ->limit(1)
                    ->get()
                    ->toArray();
                    
                    session(['planID' => $orderData[0]->planID]);
                    //$dest_country = $this->getDestinationCountry($orderData[0]->destination_country);
                    $dest_country = trim($orderData[0]->destination_country);
                    $orderData[0]->subPolicy_price = $orderData[0]->amount;
                    $orderData[0]->dest_country = $dest_country;
                    
                }
            }

            $policyno =
                'VKA/' .
                $orderData['0']->sku .
                '/' .
                date('Y') .
                '/' .
                $orderData['0']->upc .
                '/' .
                '10' .
                $orderData['0']->order_id;
            //dd($orderData);

            
            /*else{
            return view('body.purchaseSuccess');
        }*/
            //echo "Transaction Successful";
        }
        
        if ($insertIntoDB || $uploadToNiid) {
            //naicom upload
            //dd($uploadToNiid);
            $car_reg = trim(preg_replace("/\s+/", "", $orderData['0']->car_reg_number));
            
            $sid_live = 'f409a7ac-1140-4d39-8348-bb72310f60aa';
            $token_live = 'R+b4Xf3W2Eispwn0QBE5TYNIu3IxD2Cq';
            $sid_test = 'd5c6ffef-a99a-405a-9f85-6392f86bffb1';
            $token_test = 'RJFKerqc2Ejv/8bVmqlaQJ+FY5L4a/+x';
            $companyType = 'G';
            $companyId = '74';
            $means_of_id = 'PASSPORT'; //$orderData['0']->form_of_id ?? $orderData['0']->form_of_id ?: 'PASSPORT';
            $means_of_id_number = $orderData['0']->id_number ?? $orderData['0']->id_number ?: '123456789';
            $insured =$orderData['0']->firstName . ' ' . $orderData['0']->lastName;
            $effective_date = date('m/d/Y H:i:s A', strtotime($today));
            $expiration_date = date('m/d/Y H:i:s A ', strtotime($end_date));
            $premium = $orderData['0']->subPolicy_price;
            $product_name = $orderData['0']->policy_name;
            $policy_number = $policyno;
            $sum_insured = $orderData['0']->sum_insured;
            $registration_number = $car_reg;
            $address = $orderData['0']->address;
            $phone =trim($orderData['0']->phone) ?? trim($orderData['0']->phone) ?:'+234(0)700 1000 500';
            $email =trim($orderData['0']->email) ?? trim($orderData['0']->email) ?:'info@veritaskapital.com';
            $last_name = $orderData['0']->lastName ?? $$orderData->lastName[1] ?: 'n/a';
            
            $orderData[0]->mapfre_certificate_url = "";
            $orderData[0]->mapfre_policy_number = "";
            $orderData[0]->mapfre_policy_id = "";
            $orderData[0]->mapfre_error_message = "";
            $orderData[0]->mapfre_error = "";
            
            //dd($effective_date);

            switch ($orderData['0']->policyID) {
                case '3':
                    $post_data = [
                        // "SID" => $sid_live,
                        // "Token" => $sid_live,
                        'SID' => $sid_live,
                        'Token' => $token_live,
                        'Type' => 'Auto',
                        'DataGroup' => [
                            [
                                'GroupName' => 'Basic Info',
                                'GroupTag' => 0,
                                'GroupCount' => 0,
                                'AttArray' => [
                                    [
                                        'Name' => 'TypeID',
                                        'Value' => '127',
                                    ],
                                    [
                                        'Name' => 'CoverageStartDate',
                                        'Value' => $effective_date,
                                    ],
                                    [
                                        'Name' => 'CoverageEndDate',
                                        'Value' => $expiration_date,
                                    ],
                                    [
                                        'Name' => 'PolicyInternalID',
                                        'Value' => $policy_number,
                                    ],
                                    [
                                        'Name' => 'PolicyDescription',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'RecorderType',
                                        'Value' => 'Company',
                                    ],
                                ],
                            ],
                            [
                                'GroupName' => 'Detail Info',
                                'GroupTag' => 1,
                                'GroupCount' => 0,
                                'AttArray' => [
                                    [
                                        'Name' => 'CoverageType',
                                        'Value' => 'THIRD_PARTY',
                                    ],
                                    [
                                        'Name' => 'OwnerType',
                                        'Value' => 'PERSON',
                                    ],
                                    [
                                        'Name' => 'OwnerLicense',
                                        'Value' => $registration_number,
                                    ],
                                    [
                                        'Name' => 'PersonNameLast',
                                        'Value' => $last_name,
                                    ],
                                    [
                                        'Name' => 'PersonNameFirst',
                                        'Value' => $insured,
                                    ],
                                    [
                                        'Name' => 'OrgType',
                                        'Value' => 'PRIVATE',
                                    ],
                                    [
                                        'Name' => 'OrgName',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'OrgID',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'AddressLine',
                                        'Value' => $address,
                                    ],
                                    [
                                        'Name' => 'CityLGA',
                                        'Value' => 'Garki',
                                    ],
                                    [
                                        'Name' => 'State',
                                        'Value' => 'Kogi',
                                    ],
                                    [
                                        'Name' => 'PostCode',
                                        'Value' => '11755',
                                    ],
                                    [
                                        'Name' => 'Phone',
                                        'Value' => $phone,
                                    ],
                                    [
                                        'Name' => 'Email',
                                        'Value' => $email,
                                    ],
                                    [
                                        'Name' => 'InsuredValue',
                                        'Value' => '1000000',
                                    ],
                                    [
                                        'Name' => 'Premium',
                                        'Value' => $premium,
                                    ],
                                    [
                                        'Name' => 'CommissionFee',
                                        'Value' => '0',
                                    ],
                                    [
                                        'Name' => 'ExtraFee',
                                        'Value' => '0',
                                    ],
                                    [
                                        'Name' => 'PremiumNote',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Terms',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Preamble',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Endorsements',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Exclusions',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Exceptions',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Conditions',
                                        'Value' => 'n/a',
                                    ],
                                ],
                            ],
                            [
                                'GroupName' => 'Insured Info',
                                'GroupTag' => 2,
                                'GroupCount' => 0,
                                'AttArray' => [
                                    [
                                        'Name' => 'InsuredNo',
                                        'Value' => '1',
                                    ],
                                    [
                                        'Name' => 'VehicleID',
                                        'Value' => $registration_number,
                                    ],
                                    [
                                        'Name' => 'PlateNo',
                                        'Value' => $registration_number,
                                    ],
                                    [
                                        'Name' => 'RegNo',
                                        'Value' => $registration_number,
                                    ],
                                    [
                                        'Name' => 'RegDate',
                                        'Value' => 'June 07, 2020', //strtotime('m d, Y')
                                    ],
                                    [
                                        'Name' => 'RegExpDate',
                                        'Value' => 'June 07, 2024',
                                    ],
                                    [
                                        'Name' => 'RegMileage',
                                        'Value' => '100000',
                                    ],
                                    [
                                        'Name' => 'AutoType',
                                        'Value' => 'CAR',
                                    ],
                                    [
                                        'Name' => 'AutoMake',
                                        'Value' =>
                                            $orderData['0']->vehicle_make,
                                    ],
                                    [
                                        'Name' => 'AutoModel',
                                        'Value' =>
                                            $orderData['0']->vehicle_model,
                                    ],
                                    [
                                        'Name' => 'AutoColor',
                                        'Value' => 'Custom',
                                    ],
                                    [
                                        'Name' => 'AutoYear',
                                        'Value' => '2020',
                                    ],
                                    [
                                        'Name' => 'EngineCap',
                                        'Value' => '2.5',
                                    ],
                                    [
                                        'Name' => 'SeatCap',
                                        'Value' => '5',
                                    ],
                                    [
                                        'Name' => 'AutoNote',
                                        'Value' => 'n/a',
                                    ],
                                ],
                            ],
                        ],
                    ];
                    break;
                case '4':
                    $product_type_id = '30';
                    $post_data = [
                        'SID' => $sid_live,
                        'Token' => $token_live,
                        'Type' => 'Fire',
                        'DataGroup' => [
                            [
                                'GroupName' => 'Basic Info',
                                'GroupTag' => 0,
                                'GroupCount' => 0,
                                'AttArray' => [
                                    [
                                        'Name' => 'TypeID',
                                        'Value' => $product_type_id,
                                    ],
                                    [
                                        'Name' => 'CoverageStartDate',
                                        'Value' => $effective_date,
                                    ],
                                    [
                                        'Name' => 'CoverageEndDate',
                                        'Value' => $expiration_date,
                                    ],
                                    [
                                        'Name' => 'PolicyInternalID',
                                        'Value' => $policy_number,
                                    ],
                                    [
                                        'Name' => 'PolicyDescription',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'RecorderType',
                                        'Value' => 'Company',
                                    ],
                                ],
                            ],
                            [
                                'GroupName' => 'Detail Info',
                                'GroupTag' => 1,
                                'GroupCount' => 0,
                                'AttArray' => [
                                    [
                                        'Name' => 'CustomerName',
                                        'Value' => $insured,
                                    ],
                                    [
                                        'Name' => 'CustomerBuildingDoorNo',
                                        'Value' => '3',
                                    ],
                                    [
                                        'Name' => 'CustomerBuildingName',
                                        'Value' => 'Personal Building',
                                    ],
                                    [
                                        'Name' => 'CustomerBuildingAddressLine',
                                        'Value' => $address,
                                    ],
                                    [
                                        'Name' =>
                                            'CustomerBuildingAddressCityLGA',
                                        'Value' => 'Abuja',
                                    ],
                                    [
                                        'Name' =>
                                            'CustomerBuildingAddressState',
                                        'Value' => 'Kaduna',
                                    ],
                                    [
                                        'Name' =>
                                            'CustomerBuildingAddressPostCode',
                                        'Value' => '900211',
                                    ],
                                    [
                                        'Name' => 'CustomerPhone',
                                        'Value' => $phone,
                                    ],
                                    [
                                        'Name' => 'CustomerEmail',
                                        'Value' => $email,
                                    ],
                                    [
                                        'Name' => 'PropertyBusiness',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'PropertyConstruction',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'PropertyConstructionValue',
                                        'Value' => $sum_insured,
                                    ],
                                    [
                                        'Name' => 'PropertyContent',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'PropertyContentValue',
                                        'Value' => $sum_insured,
                                    ],
                                    [
                                        'Name' => 'FireCoverageDetail',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'FireProtectionDetail',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'FireHistory',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'BurglaryCoverageDetail',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'BurglaryAntiTheftDetail',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'BurglaryHistory',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'HouseBuildingType',
                                        'Value' => 'PRIVATE_DEVELLING',
                                    ],
                                    [
                                        'Name' => 'HouseCoverageDetail',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'HouseSecurityDetail',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'HouseHistory',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'InsuredValue',
                                        'Value' => $sum_insured,
                                    ],
                                    [
                                        'Name' => 'Premium',
                                        'Value' => $premium,
                                    ],
                                    [
                                        'Name' => 'CommissionFee',
                                        'Value' => '0',
                                    ],
                                    [
                                        'Name' => 'ExtraFee',
                                        'Value' => '0',
                                    ],
                                    [
                                        'Name' => 'PremiumNote',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Terms',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Preamble',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Endorsements',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Exclusions',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Exceptions',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Conditions',
                                        'Value' => 'n/a',
                                    ],
                                ],
                            ],
                        ],
                    ];
                    //End of Fire Insurance
                    break;

                case '1':
                    $product_type_id = '53';

                    $post_data = [
                        'SID' => $sid_live,
                        'Token' => $token_live,
                        'Type' => 'misc',
                        'DataGroup' => [
                            [
                                'GroupName' => 'Basic Info',
                                'GroupTag' => 0,
                                'GroupCount' => 0,
                                'AttArray' => [
                                    [
                                        'Name' => 'TypeID',
                                        'Value' => 53,
                                    ],
                                    [
                                        'Name' => 'CoverageStartDate',
                                        'Value' => $effective_date,
                                    ],
                                    [
                                        'Name' => 'CoverageEndDate',
                                        'Value' => $expiration_date,
                                    ],
                                    [
                                        'Name' => 'PolicyInternalID',
                                        'Value' => $policy_number,
                                    ],
                                    [
                                        'Name' => 'PolicyDescription',
                                        'Value' => $product_name,
                                    ],
                                    [
                                        'Name' => 'RecorderType',
                                        'Value' => 'Company',
                                    ],
                                ],
                            ],
                            [
                                'GroupName' => 'Detail Info',
                                'GroupTag' => 1,
                                'GroupCount' => 0,
                                'AttArray' => [
                                    [
                                        'Name' => 'HolderType',
                                        'Value' => 'INDIVIDUAL',
                                    ],
                                    [
                                        'Name' => 'PersonNameLast',
                                        'Value' => $insured,
                                    ],
                                    [
                                        'Name' => 'PersonNameFirst',
                                        'Value' => $last_name,
                                    ],
                                    [
                                        'Name' => 'PersonIDDoc',
                                        'Value' => $means_of_id,
                                    ],
                                    [
                                        'Name' => 'PersonIDNo',
                                        'Value' => $means_of_id_number,
                                    ],
                                    [
                                        'Name' => 'AddressLine',
                                        'Value' => $address,
                                    ],
                                    [
                                        'Name' => 'CityLGA',
                                        'Value' => 'Abuja',
                                    ],
                                    [
                                        'Name' => 'State',
                                        'Value' => 'Abia',
                                    ],
                                    [
                                        'Name' => 'PostCode',
                                        'Value' => '90211',
                                    ],
                                    [
                                        'Name' => 'Phone',
                                        'Value' => $phone,
                                    ],
                                    [
                                        'Name' => 'Email',
                                        'Value' => $email,
                                    ],
                                    [
                                        'Name' => 'InsuranceDescription',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'InsuredValue',
                                        'Value' => $sum_insured,
                                    ],
                                    [
                                        'Name' => 'Premium',
                                        'Value' => $premium,
                                    ],
                                    [
                                        'Name' => 'CommissionFee',
                                        'Value' => '0',
                                    ],
                                    [
                                        'Name' => 'ExtraFee',
                                        'Value' => '0',
                                    ],
                                    [
                                        'Name' => 'PremiumNote',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Terms',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Preamble',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Endorsements',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Exclusions',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Exceptions',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Conditions',
                                        'Value' => 'n/a',
                                    ],
                                ],
                            ],
                        ],
                    ];
                    //End of Personal Insurance
                    break;

                case '2':
                    $product_type_id = '53';

                    $post_data = [
                        'SID' => $sid_live,
                        'Token' => $token_live,
                        'Type' => 'misc',
                        'DataGroup' => [
                            [
                                'GroupName' => 'Basic Info',
                                'GroupTag' => 0,
                                'GroupCount' => 0,
                                'AttArray' => [
                                    [
                                        'Name' => 'TypeID',
                                        'Value' => '54',
                                    ],
                                    [
                                        'Name' => 'CoverageStartDate',
                                        'Value' => $effective_date,
                                    ],
                                    [
                                        'Name' => 'CoverageEndDate',
                                        'Value' => $expiration_date,
                                    ],
                                    [
                                        'Name' => 'PolicyInternalID',
                                        'Value' => $policy_number,
                                    ],
                                    [
                                        'Name' => 'PolicyDescription',
                                        'Value' => $product_name,
                                    ],
                                    [
                                        'Name' => 'RecorderType',
                                        'Value' => 'Company',
                                    ],
                                ],
                            ],
                            [
                                'GroupName' => 'Detail Info',
                                'GroupTag' => 1,
                                'GroupCount' => 0,
                                'AttArray' => [
                                    [
                                        'Name' => 'HolderType',
                                        'Value' => 'INDIVIDUAL',
                                    ],
                                    [
                                        'Name' => 'PersonNameLast',
                                        'Value' => $insured,
                                    ],
                                    [
                                        'Name' => 'PersonNameFirst',
                                        'Value' => $last_name,
                                    ],
                                    [
                                        'Name' => 'PersonIDDoc',
                                        'Value' => $means_of_id,
                                    ],
                                    [
                                        'Name' => 'PersonIDNo',
                                        'Value' => $means_of_id_number,
                                    ],
                                    [
                                        'Name' => 'AddressLine',
                                        'Value' => $address,
                                    ],
                                    [
                                        'Name' => 'CityLGA',
                                        'Value' => 'Abuja',
                                    ],
                                    [
                                        'Name' => 'State',
                                        'Value' => 'Abia',
                                    ],
                                    [
                                        'Name' => 'PostCode',
                                        'Value' => '90211',
                                    ],
                                    [
                                        'Name' => 'Phone',
                                        'Value' => $phone,
                                    ],
                                    [
                                        'Name' => 'Email',
                                        'Value' => $email,
                                    ],
                                    [
                                        'Name' => 'InsuranceDescription',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'InsuredValue',
                                        'Value' => $sum_insured,
                                    ],
                                    [
                                        'Name' => 'Premium',
                                        'Value' => $premium,
                                    ],
                                    [
                                        'Name' => 'CommissionFee',
                                        'Value' => '0',
                                    ],
                                    [
                                        'Name' => 'ExtraFee',
                                        'Value' => '0',
                                    ],
                                    [
                                        'Name' => 'PremiumNote',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Terms',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Preamble',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Endorsements',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Exclusions',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Exceptions',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Conditions',
                                        'Value' => 'n/a',
                                    ],
                                ],
                            ],
                        ],
                    ];
                    //End of House Holder Insurance
                    break;
                case '7':
                        $post_data = [
                        'SID' => $sid_live,
                        'Token' => $token_live,
                        // 'SID' => $sid_test,
                        // 'Token' => $token_test,
                        'Type' => 'Marine',
                        'DataGroup' => [
                            [
                                'GroupName' => 'Basic Info',
                                'GroupTag' => 0,
                                'GroupCount' => 0,
                                'AttArray' => [
                                    [
                                        'Name' => 'Insurer',
                                        'Value' => 'Veritas Kapital Assurance PLC',
                                    ],[
                                        'Name' => 'TypeID',
                                        'Value' => '41',
                                    ],[
                                        'Name' => 'CoverageStartDate',
                                        'Value' => $effective_date,
                                    ],[
                                        'Name' => 'CoverageEndDate',
                                        'Value' => $expiration_date,
                                    ],[
                                        'Name' => 'PolicyInternalID',
                                        'Value' => $policy_number,
                                    ],[
                                        'Name' => 'PolicyDescription',
                                        'Value' => 'n/a',
                                    ],[
                                        'Name' => 'RecorderType',
                                        'Value' => 'Company',
                                    ],[
                                        'Name' => 'DetailType',
                                        'Value' => 'Marine',
                                    ],[
                                        'Name' => 'InsuredType',
                                        'Value' => 'Marine',
                                    ],
                                ],
                            ],
                            [
                                'GroupName' => 'Detail Info',
                                'GroupTag' => 1,
                                'GroupCount' => 0,
                                'AttArray' => [
                                    [
                                        'Name' => 'OwnerName',
                                        'Value' => $insured,
                                    ],[
                                        'Name' => 'AddressLine',
                                        'Value' => $address,
                                    ],
                                    [
                                        'Name' => 'CityLGA',
                                        'Value' => 'Garki',
                                    ],
                                    [
                                        'Name' => 'State',
                                        'Value' => 'Kogi',
                                    ],
                                    [
                                        'Name' => 'PostCode',
                                        'Value' => '11755',
                                    ],
                                    [
                                        'Name' => 'Phone',
                                        'Value' => $phone,
                                    ],[
                                        'Name' => 'CoverageType',
                                        'Value' => 'General',
                                    ],
                                    [
                                        'Name' => 'Email',
                                        'Value' => $email,
                                    ],
                                    [
                                        'Name' => 'InsuredValue',
                                        'Value' => $orderData['0']->percent_sum_insured,
                                    ],
                                    [
                                        'Name' => 'Premium',
                                        'Value' => $premium,
                                    ],
                                    [
                                        'Name' => 'CommissionFee',
                                        'Value' => '0',
                                    ],
                                    [
                                        'Name' => 'ExtraFee',
                                        'Value' => '0',
                                    ],
                                    [
                                        'Name' => 'PremiumNote',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Terms',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Preamble',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Endorsements',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Exclusions',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Exceptions',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Conditions',
                                        'Value' => 'n/a',
                                    ],
                                ],
                            ],
                            [
                                'GroupName' => 'Insured Info',
                                'GroupTag' => 2,
                                'GroupCount' => 0,
                                'AttArray' => [
                                    [
                                        'Name' => 'InsuredNo',
                                        'Value' => '1',
                                    ],
                                    [
                                        'Name' => 'VessleName',
                                        'Value' => 'VESSEL',
                                    ],
                                    [
                                        'Name' => 'VessleRegNo',
                                        'Value' => 'VESSEL',
                                    ],
                                    [
                                        'Name' => 'VessleType',
                                        'Value' => 'VESSEL',
                                    ],
                                    [
                                        'Name' => 'VessleInsuredValue',
                                        'Value' => '0',
                                    ],
                                    [
                                        'Name' => 'VessleBuildYear',
                                        'Value' => '2020',
                                    ],
                                    [
                                        'Name' => 'VessleMakeModel',
                                        'Value' => 'VESSEL',
                                    ],
                                    [
                                        'Name' => 'VesslePurchaseYear',
                                        'Value' => '2020',
                                    ],
                                    [
                                        'Name' => 'VesslePurchaseValue',
                                        'Value' => '0',
                                    ],
                                    [
                                        'Name' => 'VessleUsage',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'VessleCapacityPassenger',
                                        'Value' => '12',
                                    ],
                                    [
                                        'Name' => 'VessleNote',
                                        'Value' => 'n/a',
                                    ],
                                ],
                            ],
                        ],
                    ];
            }
            
            //if policy is travel insurance, make an an API call to mapfre for certificate
            if ($orderData['0']->policyID == 6) {
                
                if (!session('planID')) {
                    session(['planID' => $orderData[0]->planID]);
                }
                
                $today = date('Y-m-d H:i:s');
                $eff_date = date_create($today);
                $duration = date_add(
                    $eff_date,
                    date_interval_create_from_date_string('365 days')
                );
                $end_date = date_format($duration, 'Y-m-d H:i:s');

                $create_effective_date = date_create($orderData[0]->departure_date);
                $effective_date = date_format($create_effective_date, "Y-m-d H:i:s");
                $create_expiration_date = date_create($orderData[0]->return_date);
                $expiration_date = date_format($create_expiration_date, "Y-m-d H:i:s");
                $sum_insured = 'N/A';
                $eff_date = $effective_date;
                $end_date = $expiration_date;
                
                $orderData[0]->mapfre_certificate_url = "";
                $orderData[0]->mapfre_policy_number = "";
                $orderData[0]->mapfre_policy_id = "";
                $orderData[0]->mapfre_error_message = "";
                $orderData[0]->mapfre_error = "";
				
				$mapfre_obj = new MapfreController;
                $generate_token = $mapfre_obj->generateToken();
                
                if($generate_token->getData()->status == 'success'){
                    $auth_token = $generate_token->getData()->data;
                    
                    $dt = new DateTime($orderData[0]->departure_date);
                    $d_date = $dt->format('Y-m-d');
                    $dt1 = new DateTime($orderData[0]->return_date);
                    $r_date = $dt1->format('Y-m-d');
                    
                    $travel_duration = $this->getDateDifference($d_date, $r_date);
                    $customer_age = $this->calculateAge($orderData[0]->dob);
                    
                    //date difference does not include the start date in the days count, we add 1 to get the accurate number of days
                    $travel_duration = $travel_duration;
                    
                    $params = [
    					"auth_token" => $auth_token,
    					"travel_start_date" => $dt->format('d/m/Y'),
    					"travel_end_date" => $dt1->format('d/m/Y'),
    					"travel_duration" => $travel_duration,
    					"travel_country_id" => $orderData[0]->dest_country,
    					"xml_product_code" => $orderData[0]->xml_product_code,
    					"xml_product_id" => $orderData[0]->xml_product_id,
    					"xml_suffijo" => $orderData[0]->xml_suffijo,
    					"xml_cmbdestinosv" => $orderData[0]->xml_cmbdestinosv,
    					"xml_cober_data" => $orderData[0]->xml_cober_data,
    					"customer_first_name" => $orderData[0]->firstName,
    					"customer_last_name" => $orderData[0]->lastName,
    					"customer_dob" => $orderData[0]->dob,
    					"customer_age" => $customer_age,
    					"customer_passport_number" => $orderData[0]->id_number,
    					"customer_phone_number" => $orderData[0]->phone,
    				];
    				
    				$generate_policy = $mapfre_obj->generatePolicy($params);
    				
    				if($generate_policy->getData()->status == 'success'){
    				    
    				    /*
    				        sample response
    				        &lt;idRegContrato&gt;620772&lt;/idRegContrato&gt;&lt;numContrato&gt;14WTVKNI&lt;/numContrato&gt;&lt;guid&gt;
    				        E4C0DA60-F02E-46B2-B3EE-9EA10BD66756&lt;/guid&gt;&lt;file&gt;
    				        https://www.mapfrewarranty.com/tmpfiles/943f3b4ed96b20a252f45111ae2cedac6f.pdf&lt;/file&gt;
    				    */
    				    
                        $policy_data = $generate_policy->getData()->data;
                        
                        //dd($policy_data);
                        
                        $mapfre_cert_url = $mapfre_obj->getStringpart($policy_data, "http", "&lt;/file&gt");
                        $mapfre_policy_number = $mapfre_obj->getStringpart($policy_data, "&lt;numContrato&gt;", "&lt;/numContrato&gt;");
                        $mapfre_policy_number = substr($mapfre_policy_number, 19);
                        $mapfre_policy_id = $mapfre_obj->getStringpart($policy_data, "&lt;idRegContrato&gt;", "&lt;/idRegContrato&gt;");
                        $mapfre_policy_id = substr($mapfre_policy_id, 21);
                        
                        $orderData[0]->mapfre_certificate_url = $mapfre_cert_url;
                        $orderData[0]->mapfre_policy_number = $mapfre_policy_number;
                        $orderData[0]->mapfre_policy_id = $mapfre_policy_id;
                        $orderData[0]->mapfre_error_message = "";
                        $orderData[0]->mapfre_error = "success";
                        
                        //dd($mapfre_policy_number.' = '.$mapfre_cert_url);
    				}else{
    				    //Handle error if policy is not generated
    				    //dd($generate_policy);
    				    $error_message = $generate_policy->getData()->message;
    				    $orderData[0]->mapfre_certificate_url = "";
                        $orderData[0]->mapfre_policy_number = "";
                        $orderData[0]->mapfre_policy_id = "";
                        $orderData[0]->mapfre_error_message = $error_message;
                        $orderData[0]->mapfre_error = "error";
                        
                        $SendErrorEmail = (new MailController)->sendTravelInsuranceErrorEmail($orderData[0], $error_message);
    				}
    				
                }else{
                    //Handle error if token is not generated
                    $error_message = $generate_token->getData()->message;
                    $orderData[0]->mapfre_certificate_url = "";
                    $orderData[0]->mapfre_policy_number = "";
                    $orderData[0]->mapfre_policy_id = "";
                    $orderData[0]->mapfre_error_message = $error_message;
                    $orderData[0]->mapfre_error = "error";
                    
                    $SendErrorEmail = (new MailController)->sendTravelInsuranceErrorEmail($orderData[0], $error_message);
                    
                    //dd($generate_token);
                }
                
            }
    
            $url_live = 'https://portal.naicom.gov.ng/api/v1/cp/policy/new';
            $url_test =
                'https://testportal.naicom.gov.ng:8443/api/v1/cp/policy/new';

            // $curl = curl_init();
            // curl_setopt($curl, CURLOPT_VERBOSE, true);
            // curl_setopt($curl, CURLOPT_HEADER, false);
            // curl_setopt($curl, CURLOPT_POST, true);
            // curl_setopt($curl, CURLOPT_URL, $url_live);

            // curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode($post_data, true));
            // $response = curl_exec($curl);
            // $status = curl_getinfo($curl, CURLINFO_HTTP_CODE);
            // curl_close($curl);
            
            if($orderData['0']->policyID == 6){//do not upload to NAICOM if policy is travel Insurance
                $uploadToNaicom = true;
                $naicom_upload['PolicyUniqueID'] = "";
            }else{
                //this should be uncommented only when NAICOM portal is down.
                // $orderData['0']->naicom_status = "error";
                // $orderData['0']->naicom_message = "However, note that you will receive your certificate via the registered email as soon as NAICOM Portal is back online";
                // return view('body.purchaseSuccess', compact('orderData'));
            
                $curl = curl_init();

                curl_setopt_array($curl, [
                    CURLOPT_URL => $url_live,
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => '',
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 0,
                    CURLOPT_FOLLOWLOCATION => true,
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    CURLOPT_CUSTOMREQUEST => 'POST',
                    CURLOPT_POSTFIELDS => json_encode($post_data),
                    CURLOPT_HTTPHEADER => ['Content-Type: application/json'],
                ]);
    
                $response = curl_exec($curl);
    
                curl_close($curl);
                // echo $response;
                // return $response;
    
                $naicom_upload = json_decode($response, true);
                //dd($curl);
                //dd($naicom_upload);
                //SAVE NAICOM RETURN RECORD TO DB
                $uploadToNaicom = DB::table('naicom_upload')->insert([
                    'policy_number' => $policyno,
                    'naicom_uid' => $naicom_upload['PolicyUniqueID'],
                    'naicom_policy_id' => $naicom_upload['PolicyID'],
                    'insured_name' => $insured,
                    'contact_address' => $address,
                    'phone' => $phone,
                    'email' => $email,
                    'eff_from_date' => date('Y-m-d', strtotime($effective_date)),
                    'eff_to_date' => date('Y-m-d', strtotime($end_date)),
                    'sum_assured' => $sum_insured,
                    'premium' => $premium,
                    'product_name' => $product_name,
                    'date_attempted' => date('Y-m-d H:i:s'),
                    'message' => !empty($naicom_upload['ErrMsgs']['0'])
                        ? $naicom_upload['ErrMsgs']['0']
                        : 'Successful',
                    'is_successful' => $naicom_upload['IsSucceed'],
                    'create_by' => $email,
                ]);
                //$naicom_data =  new stdClass();
                //dd($uploadToNaicom);
                
                if ($orderData['0']->policyID == 3) {
                    //Upload to New NIIP
                   $uploadToNiid = (new NiipController)->niipUpload($orderData['0']->order_id, $policyno, $eff_date, $naicom_upload['PolicyUniqueID']);
                } 
            }
            
            //dd($orderData);

            // add NAICOM uid and policy_no to transactions table
            if ($uploadToNaicom || $uploadToNiid) {
                $car_reg = trim(preg_replace("/\s+/", "", $orderData['0']->car_reg_number));
                $updatetransactions = DB::table('tbl_transaction')
                    ->where('transaction_id', $orderData['0']->transaction_id)
                    ->update([
                        'policy_number' => $policyno,
                        'naicom_uid' => $naicom_upload['PolicyUniqueID'],
                        'eff_from_date' => date(
                            'Y-m-d',
                            strtotime($today)
                        ),
                        'eff_to_date' => date('Y-m-d', strtotime($end_date)),
                        'mapfre_certificate_url' => $orderData[0]->mapfre_certificate_url,
                        'mapfre_policy_number' => $orderData[0]->mapfre_policy_number,
                        'mapfre_policy_id' => $orderData[0]->mapfre_policy_id,
                        'mapfre_response' => $orderData[0]->mapfre_error_message,
                    ]);

                    $uploadToReports = DB::table('retail_report')->insert([
                        'firstname' => $orderData['0']->firstName,
                        'lastname' => $last_name,
                        'email' => $email,
                        'address' => $address,
                        'telephone' => $phone,
                        'order_id' => $orderid,
                        'order_status' => $orderData['0']->order_statusID,
                        'product_name' => $product_name,
                        'product_model' => $product_name,
                        'price' => $premium,
                        'policy_number' => $policyno,
                        'sku' => $orderData['0']->sku,
                        'upc' => $orderData['0']->upc,
                        'form_of_id' => $orderData['0']->form_of_id,
                        'id_number' => $orderData['0']->id_number,
                        'vehicle_make' => $orderData['0']->vehicle_make,
                        'vehicle_model' => $orderData['0']->vehicle_model,
                        'reg_no' => $car_reg,
                        'chassis_no' => $orderData['0']->chasis_number,
                        'color' => $orderData['0']->colour,
                        'date_added' => date('Y-m-d H:i:s'),
                        'end_date' => $end_date,
                    ]);
                # code...
                if ($updatetransactions && $uploadToReports) {
                    $SendCustomerEmail = (new MailController)->sendCustomerEmail($orderData, $insertIntoDB, $email);
                    $SendRetailEmail = (new MailController)->sendRetailEmail($orderData, $policyno, $eff_date, $end_date, $transRef, $amount);
                    session()->pull('orderID');
                    
                    if (session('planID')) {
                        $SendCustomerEmail = (new MailController)->sendTravelInsuranceEmail($orderData[0], $email);
                        session()->pull('planID');
                    } 

                    //session()->put('transID', $orderData['0']->transaction_id);
                    $orderData['0']->naicom_status = "success";
                    $orderData['0']->naicom_message = "Success";

                    return view('body.purchaseSuccess', compact('orderData'));
                }else{
                    dd('Oops! NAICOM Server currently unavailable. Try again later');
                }
            }else{
                dd('Oops! NAICOM Server currently unavailable. Try again later');
            }
        }
    }

    public function generateCertificate($id)
    {
        $transData = DB::table('tbl_transaction')
            ->join(
                'tbl_order',
                'tbl_order.order_id',
                '=',
                'tbl_transaction.orderID'
            )
            ->join(
                'tbl_subpolicy',
                'tbl_subpolicy.upc',
                '=',
                'tbl_order.subPolicyID'
            )
            ->join(
                'tbl_policy',
                'tbl_policy.policy_id',
                '=',
                'tbl_subpolicy.policyID'
            )
            //->join('tbl_order_status', 'tbl_order_status.order_status_id', '=', 'tbl_order.order_statusID')
            ->WHERE('transaction_id', '=', $id)
            ->get();

        //dd($transData);
        //session()->forget('transID');
        if ($transData['0']->policyID == 3) {
            $pdf = PDF::loadView('body.Mcertificate', compact('transData'));
            return $pdf->download('certificate.pdf');
            //return view ('body.Mcertificate', compact('transData'));
        } elseif ($transData['0']->policyID == 6) {
            $pdf = PDF::loadView('body.Tcertificate', compact('transData'));
            return $pdf->download($transData[0]->mapfre_certificate_url);
            //return view ('body.Mcertificate', compact('transData'));
        } elseif($transData['0']->policyID == 7) {
            // $pdf = PDF::loadView('body.certificate', compact('transData'));
            // return $pdf->download('certificate.pdf');
            $pdf = PDF::loadView('body.marine_certificate', compact('transData'));
            return $pdf->download('certificate.pdf');
        }else {
            // $pdf = PDF::loadView('body.certificate', compact('transData'));
            // return $pdf->download('certificate.pdf');
            $pdf = PDF::loadView('body.certificate', compact('transData'));
            return $pdf->download('certificate.pdf');
        }
    }
    
    public function repushNaicom($id)
    {
        $orderData = DB::table('tbl_order')
                ->join(
                    'tbl_transaction',
                    'tbl_transaction.orderID',
                    '=',
                    'tbl_order.order_id'
                )
                ->join(
                    'tbl_subpolicy',
                    'tbl_subpolicy.upc',
                    '=',
                    'tbl_order.subPolicyID'
                )
                ->join(
                    'tbl_policy',
                    'tbl_policy.policy_id',
                    '=',
                    'tbl_subpolicy.policyID'
                )
                //->join('tbl_order_status', 'tbl_order_status.order_status_id', '=', 'tbl_order.order_statusID')
                ->WHERE('order_id', '=', $id)
                ->orderBy('transaction_date', 'desc')
                ->limit(1)
                ->get();

            $policyno ='VKA/' .$orderData['0']->sku .'/' .date('Y') .'/' .$orderData['0']->upc .'/' .'10' .$orderData['0']->order_id;
            $today = date('Y-m-d H:i:s');
            $eff_date = date_create($today);
            $duration = date_add($eff_date,date_interval_create_from_date_string('364 days'));
            $end_date = date_format($duration, 'Y-m-d H:i:s');
            
            if ($orderData['0']->policyID == 3) {
                
                $car_reg = trim(preg_replace("/\s+/", "", $orderData['0']->car_reg_number));
                
                //upload motor policy to NIID
                 $uploadToNiid = DB::connection('mysql2')
                    ->table('3rd_niid_web_service_register')
                     ->insert([
                        'policy_no' => $policyno,
                      'insured_name' =>
                             $orderData['0']->firstName .
                             ' ' .
                            $orderData['0']->lastName,
                         'contact_address' => $orderData['0']->address,
                         'gsm' => $orderData['0']->phone,
                        'email' => $orderData['0']->email,
                         'eff_from_date' => $today,
                        'eff_to_date' => $end_date,
                        'type_of_cover' => 'T',
                        'vehicle_category' => 'TBA',
                         'engine_no' => $orderData['0']->chasis_number,
                         'chasis_no' => $orderData['0']->chasis_number,
                         'vehicle_color' => $orderData['0']->colour,
                         'year_of_make' => 'year_made',
                         'vehicle_make' => $orderData['0']->vehicle_make,
                        'registration_no' => $car_reg,
                         'vehicle_type' => $orderData['0']->subPolicy_name,
                         'engine_capacity' => 'TBA',
                         'vehicle_model' => $orderData['0']->vehicle_model,
                         'sum_assured' => $orderData['0']->sum_insured,
                         'premium' => $orderData['0']->subPolicy_price,
                         'cover_note_no' => 'TBA',
                         'certificate_no' => 'TBA',
                         'geographical_zone' => $orderData['0']->state,
                         'message' => '',
                         'is_successful' => 0,
                         'date_attempted' => now(),
                     ]);

                
            }
            

            $sid_live = 'f409a7ac-1140-4d39-8348-bb72310f60aa';
            $token_live = 'R+b4Xf3W2Eispwn0QBE5TYNIu3IxD2Cq';
            $sid_test = 'd5c6ffef-a99a-405a-9f85-6392f86bffb1';
            $token_test = 'RJFKerqc2Ejv/8bVmqlaQJ+FY5L4a/+x';
            $companyType = 'G';
            $companyId = '74';
            $means_of_id = $orderData['0']->form_of_id ?? $orderData['0']->form_of_id ?: 'PASSPORT';
            $means_of_id_number = $orderData['0']->id_number ?? $orderData['0']->id_number ?: '123456789';
            $insured =$orderData['0']->firstName . ' ' . $orderData['0']->lastName;
            $effective_date = date('m/d/Y H:i:s A', strtotime($today));
            $expiration_date = date('m/d/Y H:i:s A ', strtotime($end_date));
            $premium = $orderData['0']->subPolicy_price;
            $product_name = $orderData['0']->policy_name;
            $policy_number = $policyno;
            $sum_insured = $orderData['0']->sum_insured;
            if ($orderData['0']->policyID == 3) $registration_number = $car_reg; else $registration_number =0;
            $address = $orderData['0']->address;
            $phone =trim($orderData['0']->phone) ?? trim($orderData['0']->phone) ?:'+234(0)700 1000 500';
            $email =trim($orderData['0']->email) ?? trim($orderData['0']->email) ?:'info@veritaskapital.com';
            $last_name = $orderData['0']->lastName ?? $$orderData->lastName[1] ?: 'n/a';

            switch ($orderData['0']->policyID) {
                case '3':
                    $post_data = [
                        // "SID" => $sid_live,
                        // "Token" => $sid_live,
                        'SID' => $sid_live,
                        'Token' => $token_live,
                        'Type' => 'Auto',
                        'DataGroup' => [
                            [
                                'GroupName' => 'Basic Info',
                                'GroupTag' => 0,
                                'GroupCount' => 0,
                                'AttArray' => [
                                    [
                                        'Name' => 'TypeID',
                                        'Value' => '127',
                                    ],
                                    [
                                        'Name' => 'CoverageStartDate',
                                        'Value' => $effective_date,
                                    ],
                                    [
                                        'Name' => 'CoverageEndDate',
                                        'Value' => $expiration_date,
                                    ],
                                    [
                                        'Name' => 'PolicyInternalID',
                                        'Value' => $policy_number,
                                    ],
                                    [
                                        'Name' => 'PolicyDescription',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'RecorderType',
                                        'Value' => 'Company',
                                    ],
                                ],
                            ],
                            [
                                'GroupName' => 'Detail Info',
                                'GroupTag' => 1,
                                'GroupCount' => 0,
                                'AttArray' => [
                                    [
                                        'Name' => 'CoverageType',
                                        'Value' => 'THIRD_PARTY',
                                    ],
                                    [
                                        'Name' => 'OwnerType',
                                        'Value' => 'PERSON',
                                    ],
                                    [
                                        'Name' => 'OwnerLicense',
                                        'Value' => $registration_number,
                                    ],
                                    [
                                        'Name' => 'PersonNameLast',
                                        'Value' => $last_name,
                                    ],
                                    [
                                        'Name' => 'PersonNameFirst',
                                        'Value' => $insured,
                                    ],
                                    [
                                        'Name' => 'OrgType',
                                        'Value' => 'PRIVATE',
                                    ],
                                    [
                                        'Name' => 'OrgName',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'OrgID',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'AddressLine',
                                        'Value' => $address,
                                    ],
                                    [
                                        'Name' => 'CityLGA',
                                        'Value' => 'Garki',
                                    ],
                                    [
                                        'Name' => 'State',
                                        'Value' => 'Kogi',
                                    ],
                                    [
                                        'Name' => 'PostCode',
                                        'Value' => '11755',
                                    ],
                                    [
                                        'Name' => 'Phone',
                                        'Value' => $phone,
                                    ],
                                    [
                                        'Name' => 'Email',
                                        'Value' => $email,
                                    ],
                                    [
                                        'Name' => 'InsuredValue',
                                        'Value' => '1000000',
                                    ],
                                    [
                                        'Name' => 'Premium',
                                        'Value' => $premium,
                                    ],
                                    [
                                        'Name' => 'CommissionFee',
                                        'Value' => '0',
                                    ],
                                    [
                                        'Name' => 'ExtraFee',
                                        'Value' => '0',
                                    ],
                                    [
                                        'Name' => 'PremiumNote',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Terms',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Preamble',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Endorsements',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Exclusions',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Exceptions',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Conditions',
                                        'Value' => 'n/a',
                                    ],
                                ],
                            ],
                            [
                                'GroupName' => 'Insured Info',
                                'GroupTag' => 2,
                                'GroupCount' => 0,
                                'AttArray' => [
                                    [
                                        'Name' => 'InsuredNo',
                                        'Value' => '1',
                                    ],
                                    [
                                        'Name' => 'VehicleID',
                                        'Value' => $registration_number,
                                    ],
                                    [
                                        'Name' => 'PlateNo',
                                        'Value' => $registration_number,
                                    ],
                                    [
                                        'Name' => 'RegNo',
                                        'Value' => $registration_number,
                                    ],
                                    [
                                        'Name' => 'RegDate',
                                        'Value' => 'June 07, 2020', //strtotime('m d, Y')
                                    ],
                                    [
                                        'Name' => 'RegExpDate',
                                        'Value' => 'June 07, 2024',
                                    ],
                                    [
                                        'Name' => 'RegMileage',
                                        'Value' => '100000',
                                    ],
                                    [
                                        'Name' => 'AutoType',
                                        'Value' => 'CAR',
                                    ],
                                    [
                                        'Name' => 'AutoMake',
                                        'Value' =>
                                            $orderData['0']->vehicle_make,
                                    ],
                                    [
                                        'Name' => 'AutoModel',
                                        'Value' =>
                                            $orderData['0']->vehicle_model,
                                    ],
                                    [
                                        'Name' => 'AutoColor',
                                        'Value' => 'Custom',
                                    ],
                                    [
                                        'Name' => 'AutoYear',
                                        'Value' => '2020',
                                    ],
                                    [
                                        'Name' => 'EngineCap',
                                        'Value' => '2.5',
                                    ],
                                    [
                                        'Name' => 'SeatCap',
                                        'Value' => '5',
                                    ],
                                    [
                                        'Name' => 'AutoNote',
                                        'Value' => 'n/a',
                                    ],
                                ],
                            ],
                        ],
                    ];
                    break;
                case '4':
                    $product_type_id = '30';
                    $post_data = [
                        'SID' => $sid_live,
                        'Token' => $token_live,
                        'Type' => 'Fire',
                        'DataGroup' => [
                            [
                                'GroupName' => 'Basic Info',
                                'GroupTag' => 0,
                                'GroupCount' => 0,
                                'AttArray' => [
                                    [
                                        'Name' => 'TypeID',
                                        'Value' => $product_type_id,
                                    ],
                                    [
                                        'Name' => 'CoverageStartDate',
                                        'Value' => $effective_date,
                                    ],
                                    [
                                        'Name' => 'CoverageEndDate',
                                        'Value' => $expiration_date,
                                    ],
                                    [
                                        'Name' => 'PolicyInternalID',
                                        'Value' => $policy_number,
                                    ],
                                    [
                                        'Name' => 'PolicyDescription',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'RecorderType',
                                        'Value' => 'Company',
                                    ],
                                ],
                            ],
                            [
                                'GroupName' => 'Detail Info',
                                'GroupTag' => 1,
                                'GroupCount' => 0,
                                'AttArray' => [
                                    [
                                        'Name' => 'CustomerName',
                                        'Value' => $insured,
                                    ],
                                    [
                                        'Name' => 'CustomerBuildingDoorNo',
                                        'Value' => '3',
                                    ],
                                    [
                                        'Name' => 'CustomerBuildingName',
                                        'Value' => 'Personal Building',
                                    ],
                                    [
                                        'Name' => 'CustomerBuildingAddressLine',
                                        'Value' => $address,
                                    ],
                                    [
                                        'Name' =>
                                            'CustomerBuildingAddressCityLGA',
                                        'Value' => 'Abuja',
                                    ],
                                    [
                                        'Name' =>
                                            'CustomerBuildingAddressState',
                                        'Value' => 'Kaduna',
                                    ],
                                    [
                                        'Name' =>
                                            'CustomerBuildingAddressPostCode',
                                        'Value' => '900211',
                                    ],
                                    [
                                        'Name' => 'CustomerPhone',
                                        'Value' => $phone,
                                    ],
                                    [
                                        'Name' => 'CustomerEmail',
                                        'Value' => $email,
                                    ],
                                    [
                                        'Name' => 'PropertyBusiness',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'PropertyConstruction',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'PropertyConstructionValue',
                                        'Value' => $sum_insured,
                                    ],
                                    [
                                        'Name' => 'PropertyContent',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'PropertyContentValue',
                                        'Value' => $sum_insured,
                                    ],
                                    [
                                        'Name' => 'FireCoverageDetail',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'FireProtectionDetail',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'FireHistory',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'BurglaryCoverageDetail',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'BurglaryAntiTheftDetail',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'BurglaryHistory',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'HouseBuildingType',
                                        'Value' => 'PRIVATE_DEVELLING',
                                    ],
                                    [
                                        'Name' => 'HouseCoverageDetail',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'HouseSecurityDetail',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'HouseHistory',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'InsuredValue',
                                        'Value' => $sum_insured,
                                    ],
                                    [
                                        'Name' => 'Premium',
                                        'Value' => $premium,
                                    ],
                                    [
                                        'Name' => 'CommissionFee',
                                        'Value' => '0',
                                    ],
                                    [
                                        'Name' => 'ExtraFee',
                                        'Value' => '0',
                                    ],
                                    [
                                        'Name' => 'PremiumNote',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Terms',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Preamble',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Endorsements',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Exclusions',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Exceptions',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Conditions',
                                        'Value' => 'n/a',
                                    ],
                                ],
                            ],
                        ],
                    ];
                    //End of Fire Insurance
                    break;

                case '1':
                    $product_type_id = '53';

                    $post_data = [
                        'SID' => $sid_live,
                        'Token' => $token_live,
                        'Type' => 'misc',
                        'DataGroup' => [
                            [
                                'GroupName' => 'Basic Info',
                                'GroupTag' => 0,
                                'GroupCount' => 0,
                                'AttArray' => [
                                    [
                                        'Name' => 'TypeID',
                                        'Value' => 53,
                                    ],
                                    [
                                        'Name' => 'CoverageStartDate',
                                        'Value' => $effective_date,
                                    ],
                                    [
                                        'Name' => 'CoverageEndDate',
                                        'Value' => $expiration_date,
                                    ],
                                    [
                                        'Name' => 'PolicyInternalID',
                                        'Value' => $policy_number,
                                    ],
                                    [
                                        'Name' => 'PolicyDescription',
                                        'Value' => $product_name,
                                    ],
                                    [
                                        'Name' => 'RecorderType',
                                        'Value' => 'Company',
                                    ],
                                ],
                            ],
                            [
                                'GroupName' => 'Detail Info',
                                'GroupTag' => 1,
                                'GroupCount' => 0,
                                'AttArray' => [
                                    [
                                        'Name' => 'HolderType',
                                        'Value' => 'INDIVIDUAL',
                                    ],
                                    [
                                        'Name' => 'PersonNameLast',
                                        'Value' => $insured,
                                    ],
                                    [
                                        'Name' => 'PersonNameFirst',
                                        'Value' => $last_name,
                                    ],
                                    [
                                        'Name' => 'PersonIDDoc',
                                        'Value' => $means_of_id,
                                    ],
                                    [
                                        'Name' => 'PersonIDNo',
                                        'Value' => $means_of_id_number,
                                    ],
                                    [
                                        'Name' => 'AddressLine',
                                        'Value' => $address,
                                    ],
                                    [
                                        'Name' => 'CityLGA',
                                        'Value' => 'Abuja',
                                    ],
                                    [
                                        'Name' => 'State',
                                        'Value' => 'Abia',
                                    ],
                                    [
                                        'Name' => 'PostCode',
                                        'Value' => '90211',
                                    ],
                                    [
                                        'Name' => 'Phone',
                                        'Value' => $phone,
                                    ],
                                    [
                                        'Name' => 'Email',
                                        'Value' => $email,
                                    ],
                                    [
                                        'Name' => 'InsuranceDescription',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'InsuredValue',
                                        'Value' => $sum_insured,
                                    ],
                                    [
                                        'Name' => 'Premium',
                                        'Value' => $premium,
                                    ],
                                    [
                                        'Name' => 'CommissionFee',
                                        'Value' => '0',
                                    ],
                                    [
                                        'Name' => 'ExtraFee',
                                        'Value' => '0',
                                    ],
                                    [
                                        'Name' => 'PremiumNote',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Terms',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Preamble',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Endorsements',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Exclusions',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Exceptions',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Conditions',
                                        'Value' => 'n/a',
                                    ],
                                ],
                            ],
                        ],
                    ];
                    //End of Personal Insurance
                    break;

                case '2':
                    $product_type_id = '53';

                    $post_data = [
                        'SID' => $sid_live,
                        'Token' => $token_live,
                        'Type' => 'misc',
                        'DataGroup' => [
                            [
                                'GroupName' => 'Basic Info',
                                'GroupTag' => 0,
                                'GroupCount' => 0,
                                'AttArray' => [
                                    [
                                        'Name' => 'TypeID',
                                        'Value' => '54',
                                    ],
                                    [
                                        'Name' => 'CoverageStartDate',
                                        'Value' => $effective_date,
                                    ],
                                    [
                                        'Name' => 'CoverageEndDate',
                                        'Value' => $expiration_date,
                                    ],
                                    [
                                        'Name' => 'PolicyInternalID',
                                        'Value' => $policy_number,
                                    ],
                                    [
                                        'Name' => 'PolicyDescription',
                                        'Value' => $product_name,
                                    ],
                                    [
                                        'Name' => 'RecorderType',
                                        'Value' => 'Company',
                                    ],
                                ],
                            ],
                            [
                                'GroupName' => 'Detail Info',
                                'GroupTag' => 1,
                                'GroupCount' => 0,
                                'AttArray' => [
                                    [
                                        'Name' => 'HolderType',
                                        'Value' => 'INDIVIDUAL',
                                    ],
                                    [
                                        'Name' => 'PersonNameLast',
                                        'Value' => $insured,
                                    ],
                                    [
                                        'Name' => 'PersonNameFirst',
                                        'Value' => $last_name,
                                    ],
                                    [
                                        'Name' => 'PersonIDDoc',
                                        'Value' => $means_of_id,
                                    ],
                                    [
                                        'Name' => 'PersonIDNo',
                                        'Value' => $means_of_id_number,
                                    ],
                                    [
                                        'Name' => 'AddressLine',
                                        'Value' => $address,
                                    ],
                                    [
                                        'Name' => 'CityLGA',
                                        'Value' => 'Abuja',
                                    ],
                                    [
                                        'Name' => 'State',
                                        'Value' => 'Abia',
                                    ],
                                    [
                                        'Name' => 'PostCode',
                                        'Value' => '90211',
                                    ],
                                    [
                                        'Name' => 'Phone',
                                        'Value' => $phone,
                                    ],
                                    [
                                        'Name' => 'Email',
                                        'Value' => $email,
                                    ],
                                    [
                                        'Name' => 'InsuranceDescription',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'InsuredValue',
                                        'Value' => $sum_insured,
                                    ],
                                    [
                                        'Name' => 'Premium',
                                        'Value' => $premium,
                                    ],
                                    [
                                        'Name' => 'CommissionFee',
                                        'Value' => '0',
                                    ],
                                    [
                                        'Name' => 'ExtraFee',
                                        'Value' => '0',
                                    ],
                                    [
                                        'Name' => 'PremiumNote',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Terms',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Preamble',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Endorsements',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Exclusions',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Exceptions',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Conditions',
                                        'Value' => 'n/a',
                                    ],
                                ],
                            ],
                        ],
                    ];
                    //End of House Holder Insurance
                    break;
                
                 case '7':
                        $post_data = [
                        'SID' => $sid_live,
                        'Token' => $token_live,
                        // 'SID' => $sid_test,
                        // 'Token' => $token_test,
                        'Type' => 'Marine',
                        'DataGroup' => [
                            [
                                'GroupName' => 'Basic Info',
                                'GroupTag' => 0,
                                'GroupCount' => 0,
                                'AttArray' => [
                                    [
                                        'Name' => 'Insurer',
                                        'Value' => 'Veritas Kapital Assurance PLC',
                                    ],[
                                        'Name' => 'TypeID',
                                        'Value' => '41',
                                    ],[
                                        'Name' => 'CoverageStartDate',
                                        'Value' => $effective_date,
                                    ],[
                                        'Name' => 'CoverageEndDate',
                                        'Value' => $expiration_date,
                                    ],[
                                        'Name' => 'PolicyInternalID',
                                        'Value' => $policy_number,
                                    ],[
                                        'Name' => 'PolicyDescription',
                                        'Value' => 'n/a',
                                    ],[
                                        'Name' => 'RecorderType',
                                        'Value' => 'Company',
                                    ],[
                                        'Name' => 'DetailType',
                                        'Value' => 'Marine',
                                    ],[
                                        'Name' => 'InsuredType',
                                        'Value' => 'Marine',
                                    ],
                                ],
                            ],
                            [
                                'GroupName' => 'Detail Info',
                                'GroupTag' => 1,
                                'GroupCount' => 0,
                                'AttArray' => [
                                    [
                                        'Name' => 'OwnerName',
                                        'Value' => $insured,
                                    ],[
                                        'Name' => 'AddressLine',
                                        'Value' => $address,
                                    ],
                                    [
                                        'Name' => 'CityLGA',
                                        'Value' => 'Garki',
                                    ],
                                    [
                                        'Name' => 'State',
                                        'Value' => 'Kogi',
                                    ],
                                    [
                                        'Name' => 'PostCode',
                                        'Value' => '11755',
                                    ],
                                    [
                                        'Name' => 'Phone',
                                        'Value' => $phone,
                                    ],[
                                        'Name' => 'CoverageType',
                                        'Value' => 'General',
                                    ],
                                    [
                                        'Name' => 'Email',
                                        'Value' => $email,
                                    ],
                                    [
                                        'Name' => 'InsuredValue',
                                        'Value' => $orderData['0']->percent_sum_insured,
                                    ],
                                    [
                                        'Name' => 'Premium',
                                        'Value' => $premium,
                                    ],
                                    [
                                        'Name' => 'CommissionFee',
                                        'Value' => '0',
                                    ],
                                    [
                                        'Name' => 'ExtraFee',
                                        'Value' => '0',
                                    ],
                                    [
                                        'Name' => 'PremiumNote',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Terms',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Preamble',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Endorsements',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Exclusions',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Exceptions',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Conditions',
                                        'Value' => 'n/a',
                                    ],
                                ],
                            ],
                            [
                                'GroupName' => 'Insured Info',
                                'GroupTag' => 2,
                                'GroupCount' => 0,
                                'AttArray' => [
                                    [
                                        'Name' => 'InsuredNo',
                                        'Value' => '1',
                                    ],
                                    [
                                        'Name' => 'VessleName',
                                        'Value' => 'VESSEL',
                                    ],
                                    [
                                        'Name' => 'VessleRegNo',
                                        'Value' => 'VESSEL',
                                    ],
                                    [
                                        'Name' => 'VessleType',
                                        'Value' => 'VESSEL',
                                    ],
                                    [
                                        'Name' => 'VessleInsuredValue',
                                        'Value' => '0',
                                    ],
                                    [
                                        'Name' => 'VessleBuildYear',
                                        'Value' => '2020',
                                    ],
                                    [
                                        'Name' => 'VessleMakeModel',
                                        'Value' => 'VESSEL',
                                    ],
                                    [
                                        'Name' => 'VesslePurchaseYear',
                                        'Value' => '2020',
                                    ],
                                    [
                                        'Name' => 'VesslePurchaseValue',
                                        'Value' => '0',
                                    ],
                                    [
                                        'Name' => 'VessleUsage',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'VessleCapacityPassenger',
                                        'Value' => '12',
                                    ],
                                    [
                                        'Name' => 'VessleNote',
                                        'Value' => 'n/a',
                                    ],
                                ],
                            ],
                        ],
                    ];
            }


            $url_live = 'https://portal.naicom.gov.ng/api/v1/cp/policy/new';
            $url_test =
                'https://testportal.naicom.gov.ng:8443/api/v1/cp/policy/new';

            // $curl = curl_init();
            // curl_setopt($curl, CURLOPT_VERBOSE, true);
            // curl_setopt($curl, CURLOPT_HEADER, false);
            // curl_setopt($curl, CURLOPT_POST, true);
            // curl_setopt($curl, CURLOPT_URL, $url_live);

            // curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode($post_data, true));
            // $response = curl_exec($curl);
            // $status = curl_getinfo($curl, CURLINFO_HTTP_CODE);
            // curl_close($curl);
            $curl = curl_init();

            curl_setopt_array($curl, [
                CURLOPT_URL => $url_live,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'POST',
                CURLOPT_POSTFIELDS => json_encode($post_data),
                CURLOPT_HTTPHEADER => ['Content-Type: application/json'],
            ]);

            $response = curl_exec($curl);

            curl_close($curl);
            // echo $response;
            // return $response;

            $naicom_upload = json_decode($response, true);
            //dd($curl);
            //dd($naicom_upload);
            //SAVE NAICOM RETURN RECORD TO DB
            $uploadToNaicom = DB::table('naicom_upload')->insert([
                'policy_number' => $policyno,
                'naicom_uid' => $naicom_upload['PolicyUniqueID'],
                'naicom_policy_id' => $naicom_upload['PolicyID'],
                'insured_name' => $insured,
                'contact_address' => $address,
                'phone' => $phone,
                'email' => $email,
                'eff_from_date' => date('Y-m-d', strtotime($effective_date)),
                'eff_to_date' => date('Y-m-d', strtotime($end_date)),
                'sum_assured' => $sum_insured,
                'premium' => $premium,
                'product_name' => $product_name,
                'date_attempted' => date('Y-m-d H:i:s'),
                'message' => !empty($naicom_upload['ErrMsgs']['0'])
                    ? $naicom_upload['ErrMsgs']['0']
                    : 'Successful',
                'is_successful' => $naicom_upload['IsSucceed'],
                'create_by' => $email,
            ]);
            //$naicom_data =  new stdClass();
            //dd($uploadToNaicom);
            
            //dd($orderData);

            // add NAICOM uid and policy_no to transactions table
            if ($uploadToNaicom) {
                $updatetransactions = DB::table('tbl_transaction')
                    ->where('transaction_id', $orderData['0']->transaction_id)
                    ->update([
                        'policy_number' => $policyno,
                        'naicom_uid' => $naicom_upload['PolicyUniqueID'],
                        'eff_from_date' => date(
                            'Y-m-d',
                            strtotime($today)
                        ),
                        'eff_to_date' => date('Y-m-d', strtotime($end_date)),
                    ]);
                    $car_reg = trim(preg_replace("/\s+/", "", $orderData['0']->car_reg_number));
                    $uploadToReports = DB::table('retail_report')->insert([
                        'firstname' => $orderData['0']->firstName,
                        'lastname' => $last_name,
                        'email' => $email,
                        'address' => $address,
                        'telephone' => $phone,
                        'order_id' => $orderData['0']->order_id,
                        'order_status' => $orderData['0']->order_statusID,
                        'product_name' => $product_name,
                        'product_model' => $product_name,
                        'price' => $premium,
                        'policy_number' => $policyno,
                        'sku' => $orderData['0']->sku,
                        'upc' => $orderData['0']->upc,
                        'form_of_id' => $orderData['0']->form_of_id,
                        'id_number' => $orderData['0']->id_number,
                        'vehicle_make' => $orderData['0']->vehicle_make,
                        'vehicle_model' => $orderData['0']->vehicle_model,
                        'reg_no' => $car_reg,
                        'chassis_no' => $orderData['0']->chasis_number,
                        'color' => $orderData['0']->colour,
                        'date_added' => date('Y-m-d H:i:s'),
                        'end_date' => $end_date,
                    ]);

                    if ($updatetransactions && $uploadToReports) {
                        //$SendCustomerEmail = (new MailController)->sendCustomerEmail($orderData, $insertIntoDB, $email);
                        //$SendRetailEmail = (new MailController)->sendRetailEmail($orderData, $policyno, $eff_date, $end_date, $transRef, $amount);
                        //session()->pull('orderID');

                        //session()->put('transID', $orderData['0']->transaction_id);
                        
                        $orderData['0']->naicom_status = "success";
                        $orderData['0']->naicom_message = "Success";

                        return view('body.purchaseSuccess', compact('orderData'));
                    }else{
                        dd('Oops! NAICOM Server currently unavailable. Try again later.');
                    }
            }else{
                //return back()->with('errorMsg', 'Oops! No Response from NAICOM Server. Try again later');
                dd('Oops! NAICOM Server currently unavailable. Try again later');
            }
    }
    
    public function repushGombeNaicom()
    {
        $result = DB::table('tbl_transaction as trn')
            ->join('tbl_order as o', 'trn.orderID', '=', 'o.order_id')
            ->join('tbl_subpolicy', 'tbl_subpolicy.upc', '=', 'o.subPolicyID')
            ->join(
                'tbl_policy',
                'tbl_policy.policy_id',
                '=',
                'tbl_subpolicy.policyID'
            )
            ->where('trn.transaction_id', '=', 2894)
            
            ->orderByDesc('trn.transaction_id')
            ->get();
        //dd($result);

        foreach ($result as $value) {
            
            $today = $value->eff_from_date;
            $eff_date = date_create($today);
            $duration = date_add(
                $eff_date,
                date_interval_create_from_date_string('365 days')
            );
            $end_date = date_format($duration, 'Y-m-d H:i:s');

            $sid_live = 'f409a7ac-1140-4d39-8348-bb72310f60aa';
            $token_live = 'R+b4Xf3W2Eispwn0QBE5TYNIu3IxD2Cq';
            $sid_test = 'd5c6ffef-a99a-405a-9f85-6392f86bffb1';
            $token_test = 'RJFKerqc2Ejv/8bVmqlaQJ+FY5L4a/+x';
            $companyType = 'G';
            $companyId = '74';
            $means_of_id = 'PASSPORT'; //$orderData['0']->form_of_id ?? $orderData['0']->form_of_id ?: 'PASSPORT';
            $means_of_id_number = '123456789';
            $insured = $value->firstName . ' ' . $value->lastName;
            $effective_date = date('m/d/Y H:i:s A', strtotime($today));
            $expiration_date = date('m/d/Y H:i:s A ', strtotime($end_date));
            $premium = $value->subPolicy_price;
            $product_name = $value->policy_name;
            $policy_number = $value->policy_number;
            $sum_insured = $value->sum_insured;
            $registration_number = $value->car_reg_number;
            $address = $value->address;
            $phone =
                trim($value->phone) ?? trim($value->phone) ?:
                '+234(0)700 1000 500';
            $email =
                trim($value->email) ?? trim($value->email) ?:
                'info@veritaskapital.com';
            $last_name = $value->lastName ?? $value->lastName[1] ?: 'n/a';

            switch ($value->policyID) {
                case '3':
                    $post_data = [
                        // "SID" => $sid_live,
                        // "Token" => $sid_live,
                        'SID' => $sid_live,
                        'Token' => $token_live,
                        'Type' => 'Auto',
                        'DataGroup' => [
                            [
                                'GroupName' => 'Basic Info',
                                'GroupTag' => 0,
                                'GroupCount' => 0,
                                'AttArray' => [
                                    [
                                        'Name' => 'TypeID',
                                        'Value' => '127',
                                    ],
                                    [
                                        'Name' => 'CoverageStartDate',
                                        'Value' => $effective_date,
                                    ],
                                    [
                                        'Name' => 'CoverageEndDate',
                                        'Value' => $expiration_date,
                                    ],
                                    [
                                        'Name' => 'PolicyInternalID',
                                        'Value' => $policy_number,
                                    ],
                                    [
                                        'Name' => 'PolicyDescription',
                                        'Value' => 'n/a',
                                    ],[
                                        'Name' => 'RecorderType',
                                        'Value' => 'Company',
                                    ],
                                ],
                            ],
                            [
                                'GroupName' => 'Detail Info',
                                'GroupTag' => 1,
                                'GroupCount' => 0,
                                'AttArray' => [
                                    [
                                        'Name' => 'CoverageType',
                                        'Value' => 'THIRD_PARTY',
                                    ],
                                    [
                                        'Name' => 'OwnerType',
                                        'Value' => 'PERSON',
                                    ],
                                    [
                                        'Name' => 'OwnerLicense',
                                        'Value' => $registration_number,
                                    ],
                                    [
                                        'Name' => 'PersonNameLast',
                                        'Value' => $last_name,
                                    ],
                                    [
                                        'Name' => 'PersonNameFirst',
                                        'Value' => $insured,
                                    ],
                                    [
                                        'Name' => 'OrgType',
                                        'Value' => 'PRIVATE',
                                    ],
                                    [
                                        'Name' => 'OrgName',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'OrgID',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'AddressLine',
                                        'Value' => $address,
                                    ],
                                    [
                                        'Name' => 'CityLGA',
                                        'Value' => 'Garki',
                                    ],
                                    [
                                        'Name' => 'State',
                                        'Value' => 'FCT',
                                    ],
                                    [
                                        'Name' => 'PostCode',
                                        'Value' => '11755',
                                    ],
                                    [
                                        'Name' => 'Phone',
                                        'Value' => $phone,
                                    ],
                                    [
                                        'Name' => 'Email',
                                        'Value' => $email,
                                    ],
                                    [
                                        'Name' => 'InsuredValue',
                                        'Value' => '1000000',
                                    ],
                                    [
                                        'Name' => 'Premium',
                                        'Value' => $premium,
                                    ],
                                    [
                                        'Name' => 'CommissionFee',
                                        'Value' => '0',
                                    ],
                                    [
                                        'Name' => 'ExtraFee',
                                        'Value' => '0',
                                    ],
                                    [
                                        'Name' => 'PremiumNote',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Terms',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Preamble',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Endorsements',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Exclusions',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Exceptions',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Conditions',
                                        'Value' => 'n/a',
                                    ],
                                ],
                            ],
                            [
                                'GroupName' => 'Insured Info',
                                'GroupTag' => 2,
                                'GroupCount' => 0,
                                'AttArray' => [
                                    [
                                        'Name' => 'InsuredNo',
                                        'Value' => '1',
                                    ],
                                    [
                                        'Name' => 'VehicleID',
                                        'Value' => $registration_number,
                                    ],
                                    [
                                        'Name' => 'PlateNo',
                                        'Value' => $registration_number,
                                    ],
                                    [
                                        'Name' => 'RegNo',
                                        'Value' => $registration_number,
                                    ],
                                    [
                                        'Name' => 'RegDate',
                                        'Value' => 'June 07, 2020', //strtotime('m d, Y')
                                    ],
                                    [
                                        'Name' => 'RegExpDate',
                                        'Value' => 'June 07, 2024',
                                    ],
                                    [
                                        'Name' => 'RegMileage',
                                        'Value' => '100000',
                                    ],
                                    [
                                        'Name' => 'AutoType',
                                        'Value' => 'CAR',
                                    ],
                                    [
                                        'Name' => 'AutoMake',
                                        'Value' => $value->vehicle_make,
                                    ],
                                    [
                                        'Name' => 'AutoModel',
                                        'Value' => $value->vehicle_model,
                                    ],
                                    [
                                        'Name' => 'AutoColor',
                                        'Value' => 'Custom',
                                    ],
                                    [
                                        'Name' => 'AutoYear',
                                        'Value' => '2020',
                                    ],
                                    [
                                        'Name' => 'EngineCap',
                                        'Value' => '2.5',
                                    ],
                                    [
                                        'Name' => 'SeatCap',
                                        'Value' => '5',
                                    ],
                                    [
                                        'Name' => 'AutoNote',
                                        'Value' => 'n/a',
                                    ],
                                ],
                            ],
                        ],
                    ];
                    break;
                case '4':
                    $product_type_id = '30';
                    $post_data = [
                        'SID' => $sid_live,
                        'Token' => $token_live,
                        'Type' => 'Fire',
                        'DataGroup' => [
                            [
                                'GroupName' => 'Basic Info',
                                'GroupTag' => 0,
                                'GroupCount' => 0,
                                'AttArray' => [
                                    [
                                        'Name' => 'TypeID',
                                        'Value' => $product_type_id,
                                    ],
                                    [
                                        'Name' => 'CoverageStartDate',
                                        'Value' => $effective_date,
                                    ],
                                    [
                                        'Name' => 'CoverageEndDate',
                                        'Value' => $expiration_date,
                                    ],
                                    [
                                        'Name' => 'PolicyInternalID',
                                        'Value' => $policy_number,
                                    ],
                                    [
                                        'Name' => 'PolicyDescription',
                                        'Value' => 'n/a',
                                    ],
                                ],
                            ],
                            [
                                'GroupName' => 'Detail Info',
                                'GroupTag' => 1,
                                'GroupCount' => 0,
                                'AttArray' => [
                                    [
                                        'Name' => 'CustomerName',
                                        'Value' => $insured,
                                    ],
                                    [
                                        'Name' => 'CustomerBuildingDoorNo',
                                        'Value' => '3',
                                    ],
                                    [
                                        'Name' => 'CustomerBuildingName',
                                        'Value' => 'Personal Building',
                                    ],
                                    [
                                        'Name' => 'CustomerBuildingAddressLine',
                                        'Value' => $address,
                                    ],
                                    [
                                        'Name' =>
                                            'CustomerBuildingAddressCityLGA',
                                        'Value' => 'Abuja',
                                    ],
                                    [
                                        'Name' =>
                                            'CustomerBuildingAddressState',
                                        'Value' => 'Kaduna',
                                    ],
                                    [
                                        'Name' =>
                                            'CustomerBuildingAddressPostCode',
                                        'Value' => '900211',
                                    ],
                                    [
                                        'Name' => 'CustomerPhone',
                                        'Value' => $phone,
                                    ],
                                    [
                                        'Name' => 'CustomerEmail',
                                        'Value' => $email,
                                    ],
                                    [
                                        'Name' => 'PropertyBusiness',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'PropertyConstruction',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'PropertyConstructionValue',
                                        'Value' => $sum_insured,
                                    ],
                                    [
                                        'Name' => 'PropertyContent',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'PropertyContentValue',
                                        'Value' => $sum_insured,
                                    ],
                                    [
                                        'Name' => 'FireCoverageDetail',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'FireProtectionDetail',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'FireHistory',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'BurglaryCoverageDetail',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'BurglaryAntiTheftDetail',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'BurglaryHistory',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'HouseBuildingType',
                                        'Value' => 'PRIVATE_DEVELLING',
                                    ],
                                    [
                                        'Name' => 'HouseCoverageDetail',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'HouseSecurityDetail',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'HouseHistory',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'InsuredValue',
                                        'Value' => $sum_insured,
                                    ],
                                    [
                                        'Name' => 'Premium',
                                        'Value' => $premium,
                                    ],
                                    [
                                        'Name' => 'CommissionFee',
                                        'Value' => '0',
                                    ],
                                    [
                                        'Name' => 'ExtraFee',
                                        'Value' => '0',
                                    ],
                                    [
                                        'Name' => 'PremiumNote',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Terms',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Preamble',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Endorsements',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Exclusions',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Exceptions',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Conditions',
                                        'Value' => 'n/a',
                                    ],
                                ],
                            ],
                        ],
                    ];
                    //End of Fire Insurance
                    break;

                case '1':
                    $product_type_id = '53';

                    $post_data = [
                        'SID' => $sid_live,
                        'Token' => $token_live,
                        'Type' => 'misc',
                        'DataGroup' => [
                            [
                                'GroupName' => 'Basic Info',
                                'GroupTag' => 0,
                                'GroupCount' => 0,
                                'AttArray' => [
                                    [
                                        'Name' => 'TypeID',
                                        'Value' => 53,
                                    ],
                                    [
                                        'Name' => 'CoverageStartDate',
                                        'Value' => $effective_date,
                                    ],
                                    [
                                        'Name' => 'CoverageEndDate',
                                        'Value' => $expiration_date,
                                    ],
                                    [
                                        'Name' => 'PolicyInternalID',
                                        'Value' => $policy_number,
                                    ],
                                    [
                                        'Name' => 'PolicyDescription',
                                        'Value' => $product_name,
                                    ],
                                ],
                            ],
                            [
                                'GroupName' => 'Detail Info',
                                'GroupTag' => 1,
                                'GroupCount' => 0,
                                'AttArray' => [
                                    [
                                        'Name' => 'HolderType',
                                        'Value' => 'INDIVIDUAL',
                                    ],
                                    [
                                        'Name' => 'PersonNameLast',
                                        'Value' => $insured,
                                    ],
                                    [
                                        'Name' => 'PersonNameFirst',
                                        'Value' => $last_name,
                                    ],
                                    [
                                        'Name' => 'PersonIDDoc',
                                        'Value' => $means_of_id,
                                    ],
                                    [
                                        'Name' => 'PersonIDNo',
                                        'Value' => $means_of_id_number,
                                    ],
                                    [
                                        'Name' => 'AddressLine',
                                        'Value' => $address,
                                    ],
                                    [
                                        'Name' => 'CityLGA',
                                        'Value' => 'Abuja',
                                    ],
                                    [
                                        'Name' => 'State',
                                        'Value' => 'Abia',
                                    ],
                                    [
                                        'Name' => 'PostCode',
                                        'Value' => '90211',
                                    ],
                                    [
                                        'Name' => 'Phone',
                                        'Value' => $phone,
                                    ],
                                    [
                                        'Name' => 'Email',
                                        'Value' => $email,
                                    ],
                                    [
                                        'Name' => 'InsuranceDescription',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'InsuredValue',
                                        'Value' => $sum_insured,
                                    ],
                                    [
                                        'Name' => 'Premium',
                                        'Value' => $premium,
                                    ],
                                    [
                                        'Name' => 'CommissionFee',
                                        'Value' => '0',
                                    ],
                                    [
                                        'Name' => 'ExtraFee',
                                        'Value' => '0',
                                    ],
                                    [
                                        'Name' => 'PremiumNote',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Terms',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Preamble',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Endorsements',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Exclusions',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Exceptions',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Conditions',
                                        'Value' => 'n/a',
                                    ],
                                ],
                            ],
                        ],
                    ];
                    //End of Personal Insurance
                    break;

                case '2':
                    $product_type_id = '53';

                    $post_data = [
                        'SID' => $sid_live,
                        'Token' => $token_live,
                        'Type' => 'misc',
                        'DataGroup' => [
                            [
                                'GroupName' => 'Basic Info',
                                'GroupTag' => 0,
                                'GroupCount' => 0,
                                'AttArray' => [
                                    [
                                        'Name' => 'TypeID',
                                        'Value' => '54',
                                    ],
                                    [
                                        'Name' => 'CoverageStartDate',
                                        'Value' => $effective_date,
                                    ],
                                    [
                                        'Name' => 'CoverageEndDate',
                                        'Value' => $expiration_date,
                                    ],
                                    [
                                        'Name' => 'PolicyInternalID',
                                        'Value' => $policy_number,
                                    ],
                                    [
                                        'Name' => 'PolicyDescription',
                                        'Value' => $product_name,
                                    ],
                                ],
                            ],
                            [
                                'GroupName' => 'Detail Info',
                                'GroupTag' => 1,
                                'GroupCount' => 0,
                                'AttArray' => [
                                    [
                                        'Name' => 'HolderType',
                                        'Value' => 'INDIVIDUAL',
                                    ],
                                    [
                                        'Name' => 'PersonNameLast',
                                        'Value' => $insured,
                                    ],
                                    [
                                        'Name' => 'PersonNameFirst',
                                        'Value' => $last_name,
                                    ],
                                    [
                                        'Name' => 'PersonIDDoc',
                                        'Value' => $means_of_id,
                                    ],
                                    [
                                        'Name' => 'PersonIDNo',
                                        'Value' => $means_of_id_number,
                                    ],
                                    [
                                        'Name' => 'AddressLine',
                                        'Value' => $address,
                                    ],
                                    [
                                        'Name' => 'CityLGA',
                                        'Value' => 'Abuja',
                                    ],
                                    [
                                        'Name' => 'State',
                                        'Value' => 'Abia',
                                    ],
                                    [
                                        'Name' => 'PostCode',
                                        'Value' => '90211',
                                    ],
                                    [
                                        'Name' => 'Phone',
                                        'Value' => $phone,
                                    ],
                                    [
                                        'Name' => 'Email',
                                        'Value' => $email,
                                    ],
                                    [
                                        'Name' => 'InsuranceDescription',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'InsuredValue',
                                        'Value' => $sum_insured,
                                    ],
                                    [
                                        'Name' => 'Premium',
                                        'Value' => $premium,
                                    ],
                                    [
                                        'Name' => 'CommissionFee',
                                        'Value' => '0',
                                    ],
                                    [
                                        'Name' => 'ExtraFee',
                                        'Value' => '0',
                                    ],
                                    [
                                        'Name' => 'PremiumNote',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Terms',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Preamble',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Endorsements',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Exclusions',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Exceptions',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Conditions',
                                        'Value' => 'n/a',
                                    ],
                                ],
                            ],
                        ],
                    ];
                    //End of House Holder Insurance
                    break;
            }

            $url_live = 'https://portal.naicom.gov.ng/api/v1/cp/policy/new';
            $url_test =
                'https://testportal.naicom.gov.ng:8443/api/v1/cp/policy/new';

            // $curl = curl_init();
            // curl_setopt($curl, CURLOPT_VERBOSE, true);
            // curl_setopt($curl, CURLOPT_HEADER, false);
            // curl_setopt($curl, CURLOPT_POST, true);
            // curl_setopt($curl, CURLOPT_URL, $url_live);

            // curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode($post_data, true));
            // $response = curl_exec($curl);
            // $status = curl_getinfo($curl, CURLINFO_HTTP_CODE);
            // curl_close($curl);
            $curl = curl_init();

            curl_setopt_array($curl, [
                CURLOPT_URL => $url_live,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'POST',
                CURLOPT_POSTFIELDS => json_encode($post_data),
                CURLOPT_HTTPHEADER => ['Content-Type: application/json'],
            ]);

            $response = curl_exec($curl);

            curl_close($curl);
            // echo $response;
            // return $response;

            $naicom_upload = json_decode($response, true);
            dd($response);
            //dd($policyno);
            //SAVE NAICOM RETURN RECORD TO DB
            $uploadToNaicom = DB::table('naicom_upload')->insert([
                'policy_number' => $policyno,
                'naicom_uid' => $naicom_upload['PolicyUniqueID'],
                'naicom_policy_id' => $naicom_upload['PolicyID'],
                'insured_name' => $insured,
                'contact_address' => $address,
                'phone' => $phone,
                'email' => $email,
                'eff_from_date' => date('Y-m-d', strtotime($effective_date)),
                'eff_to_date' => date('Y-m-d', strtotime($end_date)),
                'sum_assured' => $sum_insured,
                'premium' => $premium,
                'product_name' => $product_name,
                'date_attempted' => date('Y-m-d H:i:s'),
                'message' => !empty($naicom_upload['ErrMsgs']['0'])
                    ? $naicom_upload['ErrMsgs']['0']
                    : 'Successful',
                'is_successful' => $naicom_upload['IsSucceed'],
                'create_by' => $email,
            ]);
            //$naicom_data =  new stdClass();
            //dd($uploadToNaicom);

            // add NAICOM uid and policy_no to transactions table
            if ($uploadToNaicom) {
                $updatetransactions = DB::table('tbl_transaction')
                    ->where('transaction_id', $value->transaction_id)
                    ->update([
                        'policy_number' => $policyno,
                        'naicom_uid' => $naicom_upload['PolicyUniqueID'],
                        'eff_from_date' => date('Y-m-d', strtotime($today)),
                        'eff_to_date' => date('Y-m-d', strtotime($end_date)),
                    ]);
                $uploadToReports = DB::table('retail_report')->insert([
                    'firstname' => $value->firstName,
                    'lastname' => $last_name,
                    'email' => $email,
                    'address' => $address,
                    'telephone' => $phone,
                    'order_id' => $value->order_id,
                    'order_status' => $value->order_statusID,
                    'product_name' => $product_name,
                    'product_model' => $product_name,
                    'price' => $premium,
                    'policy_number' => $policyno,
                    'sku' => $value->sku,
                    'upc' => $value->upc,
                    'form_of_id' => $value->form_of_id,
                    'id_number' => $value->id_number,
                    'vehicle_make' => $value->vehicle_make,
                    'vehicle_model' => $value->vehicle_model,
                    'reg_no' => $sum_insured,
                    'chassis_no' => $value->chasis_number,
                    'color' => $value->colour,
                    'date_added' => date('Y-m-d H:i:s'),
                    'end_date' => $end_date,
                ]);


            }
        }
        if ($updatetransactions && $uploadToReports) {
            //$SendCustomerEmail = (new MailController)->sendCustomerEmail($orderData, $insertIntoDB, $email);
            //$SendRetailEmail = (new MailController)->sendRetailEmail($orderData, $policyno, $eff_date, $end_date, $transRef, $amount);
            //session()->pull('orderID');

            //session()->put('transID', $orderData['0']->transaction_id);

            return 'success';
        }
    }
    
    public function repushGombeNaicom123()
    {
        $result = DB::table('tbl_transaction as trn')
            ->join('tbl_order as o', 'trn.orderID', '=', 'o.order_id')
            ->join('tbl_subpolicy', 'tbl_subpolicy.upc', '=', 'o.subPolicyID')
            ->join(
                'tbl_policy',
                'tbl_policy.policy_id',
                '=',
                'tbl_subpolicy.policyID'
            )
            ->where('tbl_policy.policy_id', '=', 3)
            //->where('naicom_uid', '')
            ->where('naicom_uid', null)
            ->whereIn('o.customerID', [42, 64, 71])
            
            ->orderByDesc('trn.transaction_id')
            ->get();
        //dd($result);

        foreach ($result as $value) {
            if ($value->policy_number === null) {
                $policyno =
                    'VKA/' .
                    $value->sku .
                    '/' .
                    date('Y') .
                    '/' .
                    $value->upc .
                    '/' .
                    '10' .
                    $value->order_id;
            } else {
                $policyno = $value->policy_number;
            }
            $today = $value->eff_from_date;
            $eff_date = date_create($today);
            $duration = date_add(
                $eff_date,
                date_interval_create_from_date_string('365 days')
            );
            $end_date = date_format($duration, 'Y-m-d H:i:s');

            // if ($value->policyID == 3 && $value->policy_number === null) {
            //     //upload motor policy to NIID
            //     $uploadToNiid = DB::connection('mysql2')
            //         ->table('3rd_niid_web_service_register')
            //         ->insert([
            //             'policy_no' => $policyno,
            //             'insured_name' =>
            //                 $value->firstName . ' ' . $value->lastName,
            //             'contact_address' => $value->address,
            //             'gsm' => $value->phone,
            //             'email' => $value->email,
            //             'eff_from_date' => $today,
            //             'eff_to_date' => $end_date,
            //             'type_of_cover' => 'T',
            //             'vehicle_category' => 'TBA',
            //             'engine_no' => $value->chasis_number,
            //             'chasis_no' => $value->chasis_number,
            //             'vehicle_color' => $value->colour,
            //             'year_of_make' => 'year_made',
            //             'vehicle_make' => $value->vehicle_make,
            //             'registration_no' => $value->car_reg_number,
            //             'vehicle_type' => 'TBA',
            //             'engine_capacity' => 'TBA',
            //             'vehicle_model' => $value->vehicle_model,
            //             'sum_assured' => $value->sum_insured,
            //             'premium' => $value->subPolicy_price,
            //             'cover_note_no' => 'TBA',
            //             'certificate_no' => 'TBA',
            //             'geographical_zone' => $value->state,
            //             'message' => '',
            //             'is_successful' => 0,
            //             'date_attempted' => now(),
            //         ]);
            // }

            $sid_live = 'f409a7ac-1140-4d39-8348-bb72310f60aa';
            $token_live = 'R+b4Xf3W2Eispwn0QBE5TYNIu3IxD2Cq';
            $sid_test = 'd5c6ffef-a99a-405a-9f85-6392f86bffb1';
            $token_test = 'RJFKerqc2Ejv/8bVmqlaQJ+FY5L4a/+x';
            $companyType = 'G';
            $companyId = '74';
            $means_of_id = 'PASSPORT'; //$orderData['0']->form_of_id ?? $orderData['0']->form_of_id ?: 'PASSPORT';
            $means_of_id_number = '123456789';
            $insured = $value->firstName . ' ' . $value->lastName;
            $effective_date = date('m/d/Y H:i:s A', strtotime($today));
            $expiration_date = date('m/d/Y H:i:s A ', strtotime($end_date));
            $premium = $value->subPolicy_price;
            $product_name = $value->policy_name;
            $policy_number = $policyno;
            $sum_insured = $value->sum_insured;
            $registration_number = $value->car_reg_number;
            $address = $value->address;
            $phone =
                trim($value->phone) ?? trim($value->phone) ?:
                '+234(0)700 1000 500';
            $email =
                trim($value->email) ?? trim($value->email) ?:
                'info@veritaskapital.com';
            $last_name = $value->lastName ?? $value->lastName[1] ?: 'n/a';

            switch ($value->policyID) {
                case '3':
                    $post_data = [
                        // "SID" => $sid_live,
                        // "Token" => $sid_live,
                        'SID' => $sid_live,
                        'Token' => $token_live,
                        'Type' => 'Auto',
                        'DataGroup' => [
                            [
                                'GroupName' => 'Basic Info',
                                'GroupTag' => 0,
                                'GroupCount' => 0,
                                'AttArray' => [
                                    [
                                        'Name' => 'TypeID',
                                        'Value' => '127',
                                    ],
                                    [
                                        'Name' => 'CoverageStartDate',
                                        'Value' => $effective_date,
                                    ],
                                    [
                                        'Name' => 'CoverageEndDate',
                                        'Value' => $expiration_date,
                                    ],
                                    [
                                        'Name' => 'PolicyInternalID',
                                        'Value' => $policy_number,
                                    ],
                                    [
                                        'Name' => 'PolicyDescription',
                                        'Value' => 'n/a',
                                    ],[
                                        'Name' => 'RecorderType',
                                        'Value' => 'Company',
                                    ],
                                ],
                            ],
                            [
                                'GroupName' => 'Detail Info',
                                'GroupTag' => 1,
                                'GroupCount' => 0,
                                'AttArray' => [
                                    [
                                        'Name' => 'CoverageType',
                                        'Value' => 'THIRD_PARTY',
                                    ],
                                    [
                                        'Name' => 'OwnerType',
                                        'Value' => 'PERSON',
                                    ],
                                    [
                                        'Name' => 'OwnerLicense',
                                        'Value' => $registration_number,
                                    ],
                                    [
                                        'Name' => 'PersonNameLast',
                                        'Value' => $last_name,
                                    ],
                                    [
                                        'Name' => 'PersonNameFirst',
                                        'Value' => $insured,
                                    ],
                                    [
                                        'Name' => 'OrgType',
                                        'Value' => 'PRIVATE',
                                    ],
                                    [
                                        'Name' => 'OrgName',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'OrgID',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'AddressLine',
                                        'Value' => $address,
                                    ],
                                    [
                                        'Name' => 'CityLGA',
                                        'Value' => 'Garki',
                                    ],
                                    [
                                        'Name' => 'State',
                                        'Value' => 'Kogi',
                                    ],
                                    [
                                        'Name' => 'PostCode',
                                        'Value' => '11755',
                                    ],
                                    [
                                        'Name' => 'Phone',
                                        'Value' => $phone,
                                    ],
                                    [
                                        'Name' => 'Email',
                                        'Value' => $email,
                                    ],
                                    [
                                        'Name' => 'InsuredValue',
                                        'Value' => '3000000',
                                    ],
                                    [
                                        'Name' => 'Premium',
                                        'Value' => $premium,
                                    ],
                                    [
                                        'Name' => 'CommissionFee',
                                        'Value' => '0',
                                    ],
                                    [
                                        'Name' => 'ExtraFee',
                                        'Value' => '0',
                                    ],
                                    [
                                        'Name' => 'PremiumNote',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Terms',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Preamble',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Endorsements',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Exclusions',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Exceptions',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Conditions',
                                        'Value' => 'n/a',
                                    ],
                                ],
                            ],
                            [
                                'GroupName' => 'Insured Info',
                                'GroupTag' => 2,
                                'GroupCount' => 0,
                                'AttArray' => [
                                    [
                                        'Name' => 'InsuredNo',
                                        'Value' => '1',
                                    ],
                                    [
                                        'Name' => 'VehicleID',
                                        'Value' => $registration_number,
                                    ],
                                    [
                                        'Name' => 'PlateNo',
                                        'Value' => $registration_number,
                                    ],
                                    [
                                        'Name' => 'RegNo',
                                        'Value' => $registration_number,
                                    ],
                                    [
                                        'Name' => 'RegDate',
                                        'Value' => 'June 07, 2020', //strtotime('m d, Y')
                                    ],
                                    [
                                        'Name' => 'RegExpDate',
                                        'Value' => 'June 07, 2024',
                                    ],
                                    [
                                        'Name' => 'RegMileage',
                                        'Value' => '100000',
                                    ],
                                    [
                                        'Name' => 'AutoType',
                                        'Value' => 'CAR',
                                    ],
                                    [
                                        'Name' => 'AutoMake',
                                        'Value' => $value->vehicle_make,
                                    ],
                                    [
                                        'Name' => 'AutoModel',
                                        'Value' => $value->vehicle_model,
                                    ],
                                    [
                                        'Name' => 'AutoColor',
                                        'Value' => 'Custom',
                                    ],
                                    [
                                        'Name' => 'AutoYear',
                                        'Value' => '2020',
                                    ],
                                    [
                                        'Name' => 'EngineCap',
                                        'Value' => '2.5',
                                    ],
                                    [
                                        'Name' => 'SeatCap',
                                        'Value' => '5',
                                    ],
                                    [
                                        'Name' => 'AutoNote',
                                        'Value' => 'n/a',
                                    ],
                                ],
                            ],
                        ],
                    ];
                    break;
                case '4':
                    $product_type_id = '30';
                    $post_data = [
                        'SID' => $sid_live,
                        'Token' => $token_live,
                        'Type' => 'Fire',
                        'DataGroup' => [
                            [
                                'GroupName' => 'Basic Info',
                                'GroupTag' => 0,
                                'GroupCount' => 0,
                                'AttArray' => [
                                    [
                                        'Name' => 'TypeID',
                                        'Value' => $product_type_id,
                                    ],
                                    [
                                        'Name' => 'CoverageStartDate',
                                        'Value' => $effective_date,
                                    ],
                                    [
                                        'Name' => 'CoverageEndDate',
                                        'Value' => $expiration_date,
                                    ],
                                    [
                                        'Name' => 'PolicyInternalID',
                                        'Value' => $policy_number,
                                    ],
                                    [
                                        'Name' => 'PolicyDescription',
                                        'Value' => 'n/a',
                                    ],
                                ],
                            ],
                            [
                                'GroupName' => 'Detail Info',
                                'GroupTag' => 1,
                                'GroupCount' => 0,
                                'AttArray' => [
                                    [
                                        'Name' => 'CustomerName',
                                        'Value' => $insured,
                                    ],
                                    [
                                        'Name' => 'CustomerBuildingDoorNo',
                                        'Value' => '3',
                                    ],
                                    [
                                        'Name' => 'CustomerBuildingName',
                                        'Value' => 'Personal Building',
                                    ],
                                    [
                                        'Name' => 'CustomerBuildingAddressLine',
                                        'Value' => $address,
                                    ],
                                    [
                                        'Name' =>
                                            'CustomerBuildingAddressCityLGA',
                                        'Value' => 'Abuja',
                                    ],
                                    [
                                        'Name' =>
                                            'CustomerBuildingAddressState',
                                        'Value' => 'Kaduna',
                                    ],
                                    [
                                        'Name' =>
                                            'CustomerBuildingAddressPostCode',
                                        'Value' => '900211',
                                    ],
                                    [
                                        'Name' => 'CustomerPhone',
                                        'Value' => $phone,
                                    ],
                                    [
                                        'Name' => 'CustomerEmail',
                                        'Value' => $email,
                                    ],
                                    [
                                        'Name' => 'PropertyBusiness',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'PropertyConstruction',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'PropertyConstructionValue',
                                        'Value' => $sum_insured,
                                    ],
                                    [
                                        'Name' => 'PropertyContent',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'PropertyContentValue',
                                        'Value' => $sum_insured,
                                    ],
                                    [
                                        'Name' => 'FireCoverageDetail',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'FireProtectionDetail',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'FireHistory',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'BurglaryCoverageDetail',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'BurglaryAntiTheftDetail',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'BurglaryHistory',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'HouseBuildingType',
                                        'Value' => 'PRIVATE_DEVELLING',
                                    ],
                                    [
                                        'Name' => 'HouseCoverageDetail',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'HouseSecurityDetail',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'HouseHistory',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'InsuredValue',
                                        'Value' => $sum_insured,
                                    ],
                                    [
                                        'Name' => 'Premium',
                                        'Value' => $premium,
                                    ],
                                    [
                                        'Name' => 'CommissionFee',
                                        'Value' => '0',
                                    ],
                                    [
                                        'Name' => 'ExtraFee',
                                        'Value' => '0',
                                    ],
                                    [
                                        'Name' => 'PremiumNote',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Terms',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Preamble',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Endorsements',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Exclusions',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Exceptions',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Conditions',
                                        'Value' => 'n/a',
                                    ],
                                ],
                            ],
                        ],
                    ];
                    //End of Fire Insurance
                    break;

                case '1':
                    $product_type_id = '53';

                    $post_data = [
                        'SID' => $sid_live,
                        'Token' => $token_live,
                        'Type' => 'misc',
                        'DataGroup' => [
                            [
                                'GroupName' => 'Basic Info',
                                'GroupTag' => 0,
                                'GroupCount' => 0,
                                'AttArray' => [
                                    [
                                        'Name' => 'TypeID',
                                        'Value' => 53,
                                    ],
                                    [
                                        'Name' => 'CoverageStartDate',
                                        'Value' => $effective_date,
                                    ],
                                    [
                                        'Name' => 'CoverageEndDate',
                                        'Value' => $expiration_date,
                                    ],
                                    [
                                        'Name' => 'PolicyInternalID',
                                        'Value' => $policy_number,
                                    ],
                                    [
                                        'Name' => 'PolicyDescription',
                                        'Value' => $product_name,
                                    ],
                                ],
                            ],
                            [
                                'GroupName' => 'Detail Info',
                                'GroupTag' => 1,
                                'GroupCount' => 0,
                                'AttArray' => [
                                    [
                                        'Name' => 'HolderType',
                                        'Value' => 'INDIVIDUAL',
                                    ],
                                    [
                                        'Name' => 'PersonNameLast',
                                        'Value' => $insured,
                                    ],
                                    [
                                        'Name' => 'PersonNameFirst',
                                        'Value' => $last_name,
                                    ],
                                    [
                                        'Name' => 'PersonIDDoc',
                                        'Value' => $means_of_id,
                                    ],
                                    [
                                        'Name' => 'PersonIDNo',
                                        'Value' => $means_of_id_number,
                                    ],
                                    [
                                        'Name' => 'AddressLine',
                                        'Value' => $address,
                                    ],
                                    [
                                        'Name' => 'CityLGA',
                                        'Value' => 'Abuja',
                                    ],
                                    [
                                        'Name' => 'State',
                                        'Value' => 'Abia',
                                    ],
                                    [
                                        'Name' => 'PostCode',
                                        'Value' => '90211',
                                    ],
                                    [
                                        'Name' => 'Phone',
                                        'Value' => $phone,
                                    ],
                                    [
                                        'Name' => 'Email',
                                        'Value' => $email,
                                    ],
                                    [
                                        'Name' => 'InsuranceDescription',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'InsuredValue',
                                        'Value' => $sum_insured,
                                    ],
                                    [
                                        'Name' => 'Premium',
                                        'Value' => $premium,
                                    ],
                                    [
                                        'Name' => 'CommissionFee',
                                        'Value' => '0',
                                    ],
                                    [
                                        'Name' => 'ExtraFee',
                                        'Value' => '0',
                                    ],
                                    [
                                        'Name' => 'PremiumNote',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Terms',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Preamble',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Endorsements',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Exclusions',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Exceptions',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Conditions',
                                        'Value' => 'n/a',
                                    ],
                                ],
                            ],
                        ],
                    ];
                    //End of Personal Insurance
                    break;

                case '2':
                    $product_type_id = '53';

                    $post_data = [
                        'SID' => $sid_live,
                        'Token' => $token_live,
                        'Type' => 'misc',
                        'DataGroup' => [
                            [
                                'GroupName' => 'Basic Info',
                                'GroupTag' => 0,
                                'GroupCount' => 0,
                                'AttArray' => [
                                    [
                                        'Name' => 'TypeID',
                                        'Value' => '54',
                                    ],
                                    [
                                        'Name' => 'CoverageStartDate',
                                        'Value' => $effective_date,
                                    ],
                                    [
                                        'Name' => 'CoverageEndDate',
                                        'Value' => $expiration_date,
                                    ],
                                    [
                                        'Name' => 'PolicyInternalID',
                                        'Value' => $policy_number,
                                    ],
                                    [
                                        'Name' => 'PolicyDescription',
                                        'Value' => $product_name,
                                    ],
                                ],
                            ],
                            [
                                'GroupName' => 'Detail Info',
                                'GroupTag' => 1,
                                'GroupCount' => 0,
                                'AttArray' => [
                                    [
                                        'Name' => 'HolderType',
                                        'Value' => 'INDIVIDUAL',
                                    ],
                                    [
                                        'Name' => 'PersonNameLast',
                                        'Value' => $insured,
                                    ],
                                    [
                                        'Name' => 'PersonNameFirst',
                                        'Value' => $last_name,
                                    ],
                                    [
                                        'Name' => 'PersonIDDoc',
                                        'Value' => $means_of_id,
                                    ],
                                    [
                                        'Name' => 'PersonIDNo',
                                        'Value' => $means_of_id_number,
                                    ],
                                    [
                                        'Name' => 'AddressLine',
                                        'Value' => $address,
                                    ],
                                    [
                                        'Name' => 'CityLGA',
                                        'Value' => 'Abuja',
                                    ],
                                    [
                                        'Name' => 'State',
                                        'Value' => 'Abia',
                                    ],
                                    [
                                        'Name' => 'PostCode',
                                        'Value' => '90211',
                                    ],
                                    [
                                        'Name' => 'Phone',
                                        'Value' => $phone,
                                    ],
                                    [
                                        'Name' => 'Email',
                                        'Value' => $email,
                                    ],
                                    [
                                        'Name' => 'InsuranceDescription',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'InsuredValue',
                                        'Value' => $sum_insured,
                                    ],
                                    [
                                        'Name' => 'Premium',
                                        'Value' => $premium,
                                    ],
                                    [
                                        'Name' => 'CommissionFee',
                                        'Value' => '0',
                                    ],
                                    [
                                        'Name' => 'ExtraFee',
                                        'Value' => '0',
                                    ],
                                    [
                                        'Name' => 'PremiumNote',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Terms',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Preamble',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Endorsements',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Exclusions',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Exceptions',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Conditions',
                                        'Value' => 'n/a',
                                    ],
                                ],
                            ],
                        ],
                    ];
                    //End of House Holder Insurance
                    break;
            }

            $url_live = 'https://portal.naicom.gov.ng/api/v1/cp/policy/new';
            $url_test =
                'https://testportal.naicom.gov.ng:8443/api/v1/cp/policy/new';

            // $curl = curl_init();
            // curl_setopt($curl, CURLOPT_VERBOSE, true);
            // curl_setopt($curl, CURLOPT_HEADER, false);
            // curl_setopt($curl, CURLOPT_POST, true);
            // curl_setopt($curl, CURLOPT_URL, $url_live);

            // curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode($post_data, true));
            // $response = curl_exec($curl);
            // $status = curl_getinfo($curl, CURLINFO_HTTP_CODE);
            // curl_close($curl);
            $curl = curl_init();

            curl_setopt_array($curl, [
                CURLOPT_URL => $url_live,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'POST',
                CURLOPT_POSTFIELDS => json_encode($post_data),
                CURLOPT_HTTPHEADER => ['Content-Type: application/json'],
            ]);

            $response = curl_exec($curl);

            curl_close($curl);
            // echo $response;
            // return $response;

            $naicom_upload = json_decode($response, true);
            //dd($curl);
            //dd($policyno);
            //SAVE NAICOM RETURN RECORD TO DB
            $uploadToNaicom = DB::table('naicom_upload')->insert([
                'policy_number' => $policyno,
                'naicom_uid' => $naicom_upload['PolicyUniqueID'],
                'naicom_policy_id' => $naicom_upload['PolicyID'],
                'insured_name' => $insured,
                'contact_address' => $address,
                'phone' => $phone,
                'email' => $email,
                'eff_from_date' => date('Y-m-d', strtotime($effective_date)),
                'eff_to_date' => date('Y-m-d', strtotime($end_date)),
                'sum_assured' => $sum_insured,
                'premium' => $premium,
                'product_name' => $product_name,
                'date_attempted' => date('Y-m-d H:i:s'),
                'message' => !empty($naicom_upload['ErrMsgs']['0'])
                    ? $naicom_upload['ErrMsgs']['0']
                    : 'Successful',
                'is_successful' => $naicom_upload['IsSucceed'],
                'create_by' => $email,
            ]);
            //$naicom_data =  new stdClass();
            //dd($uploadToNaicom);

            // add NAICOM uid and policy_no to transactions table
            if ($uploadToNaicom) {
                $updatetransactions = DB::table('tbl_transaction')
                    ->where('transaction_id', $value->transaction_id)
                    ->update([
                        'policy_number' => $policyno,
                        'naicom_uid' => $naicom_upload['PolicyUniqueID'],
                        'eff_from_date' => date('Y-m-d', strtotime($today)),
                        'eff_to_date' => date('Y-m-d', strtotime($end_date)),
                    ]);
                $uploadToReports = DB::table('retail_report')->insert([
                    'firstname' => $value->firstName,
                    'lastname' => $last_name,
                    'email' => $email,
                    'address' => $address,
                    'telephone' => $phone,
                    'order_id' => $value->order_id,
                    'order_status' => $value->order_statusID,
                    'product_name' => $product_name,
                    'product_model' => $product_name,
                    'price' => $premium,
                    'policy_number' => $policyno,
                    'sku' => $value->sku,
                    'upc' => $value->upc,
                    'form_of_id' => $value->form_of_id,
                    'id_number' => $value->id_number,
                    'vehicle_make' => $value->vehicle_make,
                    'vehicle_model' => $value->vehicle_model,
                    'reg_no' => $sum_insured,
                    'chassis_no' => $value->chasis_number,
                    'color' => $value->colour,
                    'date_added' => date('Y-m-d H:i:s'),
                    'end_date' => $end_date,
                ]);


            }
        }
        if ($updatetransactions && $uploadToReports) {
            //$SendCustomerEmail = (new MailController)->sendCustomerEmail($orderData, $insertIntoDB, $email);
            //$SendRetailEmail = (new MailController)->sendRetailEmail($orderData, $policyno, $eff_date, $end_date, $transRef, $amount);
            //session()->pull('orderID');

            //session()->put('transID', $orderData['0']->transaction_id);

            return 'success';
        }
    }
    
    public function repaymentFunc()
    {
        return view('body.repayment');
    }

    public function repaymentCallback()
    {
        $paymentDetails = Paystack::getPaymentData();

        //dd($paymentDetails);
        $insertIntoDB = DB::table('tbl_transaction')->insertGetId([
            'orderID' => $paymentDetails['data']['metadata']['orderID'],
            'transaction_ref' => $paymentDetails['data']['reference'],
            'payment_method' => 'PAYSTACK',
            'payment_statusID' => 5,
            'amount' => $paymentDetails['data']['metadata']['premium'],
            'transaction_date' => now(),
        ]);

        if ($insertIntoDB) {
            return back()->with('successMsg', 'Payment Successful');
        }
    }
    
    public function getDestinationCountry($country_id)
    {
        $record = DB::table('tbl_country')->where('id', '=', $country_id)->get()->toArray();

        if (count($record) > 0) {
            return $record[0]->iso;
        }
        
        return 'N/A';
    }
    
    public function reprintcert()
    {
        return view('body.reprint_certificate');
    }

    public function verifyReprint(Request $request)
    {
        // Query to fetch matching transaction record
        $ifExist = DB::table('tbl_transaction')
            ->join('tbl_order', 'tbl_order.order_id', '=', 'tbl_transaction.orderID')
            ->join('tbl_subpolicy', 'tbl_subpolicy.upc', '=', 'tbl_order.subPolicyID')
            ->join('tbl_policy', 'tbl_policy.policy_id', '=', 'tbl_subpolicy.policyID')
            ->where(function ($query) use ($request) {
                $query->where('tbl_transaction.policy_number', '=', $request->renewal_ID)
                    ->orWhere('tbl_order.car_reg_number', '=', $request->renewal_ID);
            })
            ->where('tbl_transaction.payment_statusID', '=', 5)
            ->orderBy('transaction_date', 'desc')
            ->limit(1)
            ->get()
            ->toArray();

        // Check if record exists
        if (empty($ifExist)) {
            return back()->with('verifyError', 'Record Not Found!');
        }

        // Check if policy is expired
        $expiryDate = Carbon::parse($ifExist[0]->eff_to_date);
        if ($expiryDate->isPast()) {
            return back()->with('verifyError', 'Policy Expired!');
        }

        // Store relevant data in session and return success response
        $request->session()->put('orderID', $ifExist[0]->order_id);

        return back()->with([
            'verifySuccess' => 'Record Found!',
            'id' => $ifExist[0]->transaction_id,
            'policy_number' => $ifExist[0]->policy_number,
            'firstName' => $ifExist[0]->firstName,
            'lastName' => $ifExist[0]->lastName,
            'premium' => $ifExist[0]->amount,
            'policy_name' => $ifExist[0]->policy_name,
            'expiry' => $ifExist[0]->eff_to_date,
        ]);
    }
    
    public function forgotPasswordPage()
    {
        return view('body.forgot_password');
    }

    public function passwordRecoveryMail(Request $request)
    {
        // Query to fetch matching transaction record
        $ifExist = DB::table('tbl_customer')
            ->where('email', '=', $request->email)
        ->first();

        // Check if record exists
        if (empty($ifExist)) {
            return back()->with('verifyError', 'Email Does Not Exist!');
        }else{
            $uniqueString = Str::random(20) . time();

            $updatequery = DB::table('tbl_customer')
                ->where('customer_id', $ifExist->customer_id)
            ->update(['password_reset_link' => $uniqueString]);

            $SendCustomerResetMail = (new MailController)->SendCustomerResetPasswordMail($request->email, $uniqueString, $ifExist);

            $response = json_decode($SendCustomerResetMail);

            if ($response->status == "success") {
                return back()->with([
                    'verifySuccess' => 'Reset link sent to the registered email submitted!',
                ]);
            } else {
                return back()->with([
                    'verifyError' => 'Error Sending Email!' . $response->message,
                ]);
            }

        }


    }

    public function resetPasswordPage($id)
    {
        return view('body.reset_password', compact('id'));
    }

    public function resetPassword(Request $request)
    {
        //dd($request->id);
        $request->validate([
            'password' => [
                'required',
                'min:8',  // At least 8 characters
                'regex:/[A-Z]/',  // At least one uppercase letter
                'regex:/[a-z]/',  // At least one lowercase letter
                'regex:/[!@#$%^&*(),.?":{}|<>]/',  // At least one special character
                'confirmed'  // Ensures password matches password_confirmation
            ],
        ]);

        $updatequery = DB::table('tbl_customer')
            ->where('password_reset_link', $request->id)
        ->update(['password_reset_link' => '', 'password' => Hash::make($request->password)]);

        if ($updatequery) {
            return back()->with([
                'verifySuccess' => 'Password Reset Successful!',
            ]);
        } else {
            return back()->with([
                'verifyError' => 'Error Reseting Password!',
            ]);
        }


    }
}
